/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers;

import java.util.Iterator;
import pt.ist.fenixWebFramework.renderers.OutputRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlInlineContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.layouts.FlowLayout;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;
import pt.ist.fenixWebFramework.renderers.model.MetaObject;
import pt.ist.fenixWebFramework.renderers.model.MetaSlot;

public class FlowRenderer
extends OutputRenderer {
    private String eachClasses;
    private String eachStyle;
    private boolean eachInline = true;
    private boolean labelExcluded = false;
    private String labelTerminator;
    private String labelClasses;
    private String labelStyle;

    public String getEachClasses() {
        return this.eachClasses;
    }

    public void setEachClasses(String eachClasses) {
        this.eachClasses = eachClasses;
    }

    public boolean isEachInline() {
        return this.eachInline;
    }

    public void setEachInline(boolean eachInline) {
        this.eachInline = eachInline;
    }

    public String getEachStyle() {
        return this.eachStyle;
    }

    public void setEachStyle(String eachStyle) {
        this.eachStyle = eachStyle;
    }

    public boolean isLabelExcluded() {
        return this.labelExcluded;
    }

    public void setLabelExcluded(boolean labelExcluded) {
        this.labelExcluded = labelExcluded;
    }

    public String getLabelTerminator() {
        return this.labelTerminator;
    }

    public void setLabelTerminator(String labelTerminator) {
        this.labelTerminator = labelTerminator;
    }

    public String getLabelClasses() {
        return this.labelClasses;
    }

    public void setLabelClasses(String labelClasses) {
        this.labelClasses = labelClasses;
    }

    public String getLabelStyle() {
        return this.labelStyle;
    }

    public void setLabelStyle(String labelStyle) {
        this.labelStyle = labelStyle;
    }

    @Override
    protected Layout getLayout(Object object, Class type) {
        MetaObject meta = this.getContext().getMetaObject();
        final Iterator<MetaSlot> slots = meta.getSlots().iterator();
        return new FlowLayout(){

            @Override
            protected boolean hasMoreComponents() {
                return slots.hasNext();
            }

            @Override
            protected HtmlComponent getNextComponent() {
                MetaSlot slot = (MetaSlot)slots.next();
                HtmlComponent component = FlowRenderer.this.renderSlot(slot);
                return this.createContainer(slot, component);
            }

            private HtmlComponent createContainer(MetaSlot slot, HtmlComponent component) {
                if (FlowRenderer.this.isLabelExcluded()) {
                    return component;
                }
                HtmlInlineContainer container = new HtmlInlineContainer();
                HtmlText label = new HtmlText(this.addLabelTerminator(slot.getLabel()), false);
                HtmlInlineContainer labelContainer = new HtmlInlineContainer();
                labelContainer.addChild(label);
                labelContainer.setStyle(FlowRenderer.this.getLabelStyle());
                labelContainer.setClasses(FlowRenderer.this.getLabelClasses());
                container.addChild(labelContainer);
                container.addChild(component);
                return container;
            }

            protected String addLabelTerminator(String label) {
                if (FlowRenderer.this.getLabelTerminator() == null) {
                    return label;
                }
                if (label == null) {
                    return null;
                }
                if (label.endsWith(FlowRenderer.this.getLabelTerminator())) {
                    return label;
                }
                return label + FlowRenderer.this.getLabelTerminator();
            }
        };
    }
}

