/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.fenixedu.commons.i18n.I18N;
import pt.ist.fenixWebFramework.renderers.OutputRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;

public class DateRenderer
extends OutputRenderer {
    private static final String DEFAULT_FORMAT = "dd/MM/yyyy";
    private String format;

    public void setFormat(String format) {
        this.format = format;
    }

    public String getFormat() {
        return this.format == null ? DEFAULT_FORMAT : this.format;
    }

    public boolean isFormatSet() {
        return this.format != null;
    }

    @Override
    protected Layout getLayout(Object object, Class type) {
        return new Layout(){

            @Override
            public HtmlComponent createComponent(Object object, Class type) {
                Date date = (Date)object;
                if (date == null) {
                    return new HtmlText();
                }
                SimpleDateFormat dateFormat = new SimpleDateFormat(DateRenderer.this.getFormat(), I18N.getLocale());
                return new HtmlText(dateFormat.format(date));
            }
        };
    }
}

