/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers;

import pt.ist.fenixWebFramework.renderers.InputRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlLabel;
import pt.ist.fenixWebFramework.renderers.components.HtmlListItem;
import pt.ist.fenixWebFramework.renderers.components.HtmlRadioButton;
import pt.ist.fenixWebFramework.renderers.components.HtmlRadioButtonList;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.contexts.PresentationContext;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;
import pt.ist.fenixWebFramework.renderers.model.MetaObject;
import pt.ist.fenixWebFramework.renderers.model.MetaObjectFactory;
import pt.ist.fenixWebFramework.renderers.model.MetaSlotKey;
import pt.ist.fenixWebFramework.renderers.utils.RenderKit;
import pt.ist.fenixWebFramework.renderers.utils.RenderMode;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixWebFramework.renderers.utils.RendererPropertyUtils;

public class BooleanRadioInputRenderer
extends InputRenderer {
    private String readOnlyIf;
    private String readOnlyIfNot;
    private String trueLabel;
    private String falseLabel;
    private String bundle;
    private String eachClasses;
    private String eachStyle;

    public BooleanRadioInputRenderer() {
        this.setStyle("white-space: nowrap;");
    }

    public String getReadOnlyIf() {
        return this.readOnlyIf;
    }

    public void setReadOnlyIf(String readOnlyIf) {
        this.readOnlyIf = readOnlyIf;
    }

    public String getEachClasses() {
        return this.eachClasses;
    }

    public String getReadOnlyIfNot() {
        return this.readOnlyIfNot;
    }

    public void setReadOnlyIfNot(String readOnlyIfNot) {
        this.readOnlyIfNot = readOnlyIfNot;
    }

    public void setEachClasses(String eachClasses) {
        this.eachClasses = eachClasses;
    }

    public String getEachStyle() {
        return this.eachStyle;
    }

    public void setEachStyle(String eachStyle) {
        this.eachStyle = eachStyle;
    }

    public String getBundle() {
        return this.bundle;
    }

    public void setBundle(String bundle) {
        this.bundle = bundle;
    }

    public String getFalseLabel() {
        return this.falseLabel;
    }

    public void setFalseLabel(String falseLabel) {
        this.falseLabel = falseLabel;
    }

    public String getTrueLabel() {
        return this.trueLabel;
    }

    public void setTrueLabel(String trueLabel) {
        this.trueLabel = trueLabel;
    }

    @Override
    protected Layout getLayout(Object object, Class type) {
        return new Layout(){

            @Override
            public HtmlComponent createComponent(Object object, Class type) {
                Boolean booleanObject = (Boolean)object;
                if (BooleanRadioInputRenderer.this.getReadOnlyIf() != null || BooleanRadioInputRenderer.this.getReadOnlyIfNot() != null) {
                    Object parentObject = null;
                    if (BooleanRadioInputRenderer.this.getContext().getParentContext() != null) {
                        parentObject = BooleanRadioInputRenderer.this.getContext().getParentContext().getMetaObject().getObject();
                    }
                    Boolean useReadOnlyIfResult = null;
                    Boolean useReadOnlyIfNotResult = null;
                    try {
                        if (BooleanRadioInputRenderer.this.getReadOnlyIf() != null) {
                            useReadOnlyIfResult = (Boolean)RendererPropertyUtils.getProperty(parentObject, BooleanRadioInputRenderer.this.getReadOnlyIf(), false);
                        }
                        if (BooleanRadioInputRenderer.this.getReadOnlyIfNot() != null) {
                            useReadOnlyIfNotResult = (Boolean)RendererPropertyUtils.getProperty(parentObject, BooleanRadioInputRenderer.this.getReadOnlyIfNot(), false);
                        }
                    }
                    catch (ClassCastException e) {
                        e.printStackTrace();
                    }
                    if ((useReadOnlyIfNotResult != null || useReadOnlyIfResult != null) && (useReadOnlyIfNotResult != null && !useReadOnlyIfNotResult.booleanValue() || useReadOnlyIfResult != null && useReadOnlyIfResult.booleanValue())) {
                        if (booleanObject == null) {
                            return new HtmlText("");
                        }
                        return new HtmlText(String.valueOf(booleanObject));
                    }
                }
                HtmlRadioButtonList radioList = new HtmlRadioButtonList();
                Boolean booleanTrue = Boolean.TRUE;
                MetaObject booleanMetaObject = MetaObjectFactory.createObject(booleanTrue, null);
                PresentationContext newContext = BooleanRadioInputRenderer.this.getContext().createSubContext(booleanMetaObject);
                newContext.setRenderMode(RenderMode.OUTPUT);
                HtmlComponent component = this.getBooleanComponent(booleanTrue, newContext);
                HtmlLabel trueLabel = new HtmlLabel();
                trueLabel.setBody(component);
                HtmlRadioButton buttonTrue = radioList.addOption(trueLabel, booleanTrue.toString());
                trueLabel.setFor(buttonTrue);
                Boolean booleanFalse = Boolean.FALSE;
                booleanMetaObject = MetaObjectFactory.createObject(booleanFalse, null);
                newContext = BooleanRadioInputRenderer.this.getContext().createSubContext(booleanMetaObject);
                newContext.setRenderMode(RenderMode.OUTPUT);
                component = this.getBooleanComponent(booleanFalse, newContext);
                HtmlLabel falseLabel = new HtmlLabel();
                falseLabel.setBody(component);
                HtmlRadioButton buttonFalse = radioList.addOption(falseLabel, booleanFalse.toString());
                falseLabel.setFor(buttonFalse);
                buttonTrue.setChecked(booleanObject == null ? false : booleanObject);
                buttonFalse.setChecked(booleanObject == null ? false : booleanObject == false);
                radioList.setTargetSlot((MetaSlotKey)BooleanRadioInputRenderer.this.getInputContext().getMetaObject().getKey());
                for (HtmlListItem item : radioList.getList().getItems()) {
                    item.setClasses(BooleanRadioInputRenderer.this.getEachClasses());
                    item.setStyle(BooleanRadioInputRenderer.this.getEachStyle());
                }
                return radioList;
            }

            private HtmlComponent getBooleanComponent(Boolean value, PresentationContext newContext) {
                if (value == null) {
                    return RenderKit.getInstance().render(newContext, value);
                }
                if (value.booleanValue()) {
                    if (BooleanRadioInputRenderer.this.getTrueLabel() == null) {
                        return RenderKit.getInstance().render(newContext, value);
                    }
                    return new HtmlText(RenderUtils.getResourceString(BooleanRadioInputRenderer.this.getBundle(), BooleanRadioInputRenderer.this.getTrueLabel()));
                }
                if (BooleanRadioInputRenderer.this.getFalseLabel() == null) {
                    return RenderKit.getInstance().render(newContext, value);
                }
                return new HtmlText(RenderUtils.getResourceString(BooleanRadioInputRenderer.this.getBundle(), BooleanRadioInputRenderer.this.getFalseLabel()));
            }
        };
    }
}

