/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import pt.ist.fenixWebFramework.renderers.OutputRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlBlockContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlInlineContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlScript;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;

public abstract class AbstractToolTipRenderer
extends OutputRenderer {
    private String bundle;
    private boolean key;
    private String subLayout;
    private boolean useParent;
    private boolean escape = true;
    private String openClasses;
    private String closedClasses;
    private String textClasses;
    private Map<String, String> properties = new HashMap<String, String>();

    public boolean isUseParent() {
        return this.useParent;
    }

    public void setUseParent(boolean useParent) {
        this.useParent = useParent;
    }

    public String getSubLayout() {
        return this.subLayout;
    }

    public void setSubLayout(String subLayout) {
        this.subLayout = subLayout;
    }

    private Map<String, String> getPropertiesMap() {
        return this.properties;
    }

    public void setSubProperty(String property, String value) {
        this.properties.put(property, value);
    }

    public String getSubProperty(String property) {
        return this.properties.get(property);
    }

    public boolean isEscape() {
        return this.escape;
    }

    public void setEscape(boolean escape) {
        this.escape = escape;
    }

    public String getOpenClasses() {
        return this.openClasses;
    }

    public void setOpenClasses(String openClasses) {
        this.openClasses = openClasses;
    }

    public String getClosedClasses() {
        return this.closedClasses;
    }

    public void setClosedClasses(String closedClasses) {
        this.closedClasses = closedClasses;
    }

    public String getTextClasses() {
        return this.textClasses;
    }

    public void setTextClasses(String textClasses) {
        this.textClasses = textClasses;
    }

    public String getBundle() {
        return this.bundle;
    }

    public void setBundle(String bundle) {
        this.bundle = bundle;
    }

    public boolean isKey() {
        return this.key;
    }

    public void setKey(boolean key) {
        this.key = key;
    }

    public abstract class ToolTipLayout
    extends Layout {
        protected Properties getProperties() {
            Properties properties = new Properties();
            Map map = AbstractToolTipRenderer.this.getPropertiesMap();
            for (String property : map.keySet()) {
                properties.put(property, map.get(property));
            }
            return properties;
        }

        protected HtmlContainer wrapUpCompletion(HtmlComponent renderedComponent, HtmlComponent hoverComponent) {
            HtmlBlockContainer container = new HtmlBlockContainer();
            HtmlInlineContainer span = new HtmlInlineContainer();
            span.addChild(renderedComponent);
            container.addChild(span);
            String id = HtmlComponent.getValidIdOrName(String.valueOf(hoverComponent.hashCode())) + ":" + System.currentTimeMillis();
            HtmlBlockContainer toolTipContainer = new HtmlBlockContainer();
            container.setId(id);
            container.setOnMouseOver(this.getScript(id, AbstractToolTipRenderer.this.getOpenClasses()));
            container.setOnMouseOut(this.getScript(id, AbstractToolTipRenderer.this.getClosedClasses()));
            container.setClasses(AbstractToolTipRenderer.this.getClosedClasses());
            toolTipContainer.setClasses(AbstractToolTipRenderer.this.getTextClasses());
            toolTipContainer.addChild(hoverComponent);
            container.addChild(toolTipContainer);
            HtmlScript script = new HtmlScript();
            script.setContentType("text/javascript");
            script.setScript(this.getScript(id, AbstractToolTipRenderer.this.getClosedClasses()));
            container.addChild(script);
            return container;
        }

        private String getScript(String id, String classes) {
            return String.format("document.getElementById('%s').className='%s';", id, classes);
        }

        protected Object getTargetObject(Object object) {
            if (AbstractToolTipRenderer.this.isUseParent()) {
                if (AbstractToolTipRenderer.this.getContext().getParentContext() != null) {
                    return AbstractToolTipRenderer.this.getContext().getParentContext().getMetaObject().getObject();
                }
                return null;
            }
            return object;
        }
    }
}

