/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.rendererExtensions.taglib;

import java.util.Collection;
import javax.servlet.jsp.JspException;
import pt.ist.fenixWebFramework.rendererExtensions.converters.DomainObjectKeyArrayConverter;
import pt.ist.fenixWebFramework.rendererExtensions.converters.DomainObjectKeyConverter;
import pt.ist.fenixWebFramework.renderers.components.state.HiddenSlot;
import pt.ist.fenixWebFramework.renderers.converters.EnumConverter;
import pt.ist.fenixWebFramework.renderers.model.MetaObjectFactory;
import pt.ist.fenixWebFramework.renderers.taglib.HiddenSlotTag;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.FenixFramework;

public class FenixHiddenSlotTag
extends HiddenSlotTag {
    private String oid;
    private boolean isCollection;

    public String getOid() {
        return this.oid;
    }

    public void setOid(String oid) {
        this.oid = oid;
    }

    @Override
    public void release() {
        super.release();
        this.isCollection = false;
    }

    @Override
    protected Object findObject() throws JspException {
        if (this.getName() != null) {
            return super.findObject();
        }
        if (this.getOid() == null) {
            throw new JspException("must specify at 'name' or 'oid' and 'type'");
        }
        Object object = this.getPersistentObject();
        if (object == null) {
            throw new JspException("could not find object " + this.getOid());
        }
        return object;
    }

    @Override
    protected void addHiddenSlot(String slot, Object value, String converterName) throws JspException {
        if (value == null && converterName == null) {
            return;
        }
        if (value instanceof Collection) {
            this.isCollection = true;
            Collection collection = (Collection)value;
            for (Object object : collection) {
                this.addHiddenSlot(slot, object, converterName);
            }
        } else if (value instanceof DomainObject) {
            String usedConverterName = this.getNextDomainObjectConverter();
            DomainObject domainObject = (DomainObject)value;
            String objectValue = MetaObjectFactory.createObject(domainObject, null).getKey().toString();
            this.addHiddenSlot(slot, objectValue, usedConverterName);
        } else if (value instanceof Enum) {
            String enumConverterName = EnumConverter.class.getName();
            this.addHiddenSlot(slot, ((Enum)value).name(), enumConverterName);
        } else {
            super.addHiddenSlot(slot, value, converterName);
        }
    }

    @Override
    protected boolean isMultiple() {
        return super.isMultiple() || this.isCollection;
    }

    private String getNextDomainObjectConverter() {
        if (this.getConverter() != null) {
            return this.getConverter();
        }
        HiddenSlot slot = this.getContainerParent().getHiddenSlot(this.getSlot());
        if (slot != null) {
            return DomainObjectKeyArrayConverter.class.getName();
        }
        if (this.isMultiple()) {
            return DomainObjectKeyArrayConverter.class.getName();
        }
        return DomainObjectKeyConverter.class.getName();
    }

    protected Object getPersistentObject() throws JspException {
        if (this.getOid() != null) {
            return FenixFramework.getDomainObject((String)this.getOid());
        }
        return null;
    }
}

