/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.rendererExtensions;

import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.joda.time.DateTimeFieldType;
import org.joda.time.Partial;
import org.joda.time.base.AbstractPartial;
import pt.ist.fenixWebFramework.renderers.DateInputRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.converters.ConversionException;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;

public class PartialInputRenderer
extends DateInputRenderer {
    private boolean second = false;
    private boolean minute = false;
    private boolean hour = false;
    private boolean day = false;
    private boolean month = false;
    private boolean year = false;

    public boolean isDay() {
        return this.day;
    }

    public void setDay(boolean day) {
        this.day = day;
    }

    public boolean isHour() {
        return this.hour;
    }

    public void setHour(boolean hour) {
        this.hour = hour;
    }

    public boolean isMinute() {
        return this.minute;
    }

    public void setMinute(boolean minute) {
        this.minute = minute;
    }

    public boolean isMonth() {
        return this.month;
    }

    public void setMonth(boolean month) {
        this.month = month;
    }

    public boolean isSecond() {
        return this.second;
    }

    public void setSecond(boolean second) {
        this.second = second;
    }

    public boolean isYear() {
        return this.year;
    }

    public void setYear(boolean year) {
        this.year = year;
    }

    @Override
    public String getFormat() {
        if (this.isFormatSet()) {
            return super.getFormat();
        }
        StringBuilder format = new StringBuilder();
        if (this.isDay()) {
            format.append("dd");
        }
        if (this.isMonth()) {
            format.append((format.length() > 0 ? "/" : "") + "MM");
        }
        if (this.isYear()) {
            format.append((format.length() > 0 ? "/" : "") + "yyyy");
        }
        if (this.isHour()) {
            format.append((format.length() > 0 ? " " : "") + "HH");
        }
        if (this.isMinute()) {
            format.append((format.length() > 0 ? ":" : "") + "mm");
        }
        if (this.isSecond()) {
            format.append((format.length() > 0 ? ":" : "") + "ss");
        }
        return format.toString();
    }

    @Override
    protected HtmlComponent createTextField(Object object, Class type) {
        Date date = this.convertPartialToDate((AbstractPartial)object);
        return super.createTextField(date, type);
    }

    private Date convertPartialToDate(AbstractPartial partial) {
        if (partial == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        if (this.isDay()) {
            calendar.set(5, partial.get(DateTimeFieldType.dayOfMonth()));
        }
        if (this.isMonth()) {
            calendar.set(2, partial.get(DateTimeFieldType.monthOfYear()) - 1);
        }
        if (this.isYear()) {
            calendar.set(1, partial.get(DateTimeFieldType.year()));
        }
        if (this.isHour()) {
            calendar.set(11, partial.get(DateTimeFieldType.hourOfDay()));
        }
        if (this.isMinute()) {
            calendar.set(12, partial.get(DateTimeFieldType.minuteOfHour()));
        }
        if (this.isSecond()) {
            calendar.set(13, partial.get(DateTimeFieldType.secondOfMinute()));
        }
        return calendar.getTime();
    }

    @Override
    protected Converter getDateConverter(SimpleDateFormat dateFormat) {
        Converter dateConverter = super.getDateConverter(dateFormat);
        return new PartialConverter(dateConverter);
    }

    public class PartialConverter
    extends Converter {
        private final Converter dateConverter;

        public PartialConverter(Converter dateConverter) {
            this.dateConverter = dateConverter;
        }

        @Override
        public Object convert(Class type, Object value) {
            Date date = (Date)this.dateConverter.convert(type, value);
            if (date == null) {
                return null;
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            try {
                return this.convertCalendarToPartial(type, calendar);
            }
            catch (Exception e) {
                throw new ConversionException("fenix.renderers.converter.partial", (Throwable)e, true, value);
            }
        }

        private Object convertCalendarToPartial(Class type, Calendar calendar) throws Exception {
            if (type.equals(Partial.class)) {
                Partial partial = new Partial();
                if (PartialInputRenderer.this.isDay()) {
                    partial = partial.with(DateTimeFieldType.dayOfMonth(), calendar.get(5));
                }
                if (PartialInputRenderer.this.isMonth()) {
                    partial = partial.with(DateTimeFieldType.monthOfYear(), calendar.get(2) + 1);
                }
                if (PartialInputRenderer.this.isYear()) {
                    partial = partial.with(DateTimeFieldType.year(), calendar.get(1));
                }
                if (PartialInputRenderer.this.isHour()) {
                    partial = partial.with(DateTimeFieldType.hourOfDay(), calendar.get(11));
                }
                if (PartialInputRenderer.this.isMinute()) {
                    partial = partial.with(DateTimeFieldType.minuteOfHour(), calendar.get(12));
                }
                if (PartialInputRenderer.this.isSecond()) {
                    partial = partial.with(DateTimeFieldType.secondOfMinute(), calendar.get(13));
                }
                return partial;
            }
            Method method = type.getMethod("fromCalendarFields", Calendar.class);
            return method.invoke(null, calendar);
        }
    }
}

