/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.rendererExtensions;

import com.google.common.base.Strings;
import java.util.Locale;
import org.fenixedu.commons.i18n.I18N;
import org.fenixedu.commons.i18n.LocalizedString;
import pt.ist.fenixWebFramework.renderers.StringRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlBlockContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlInlineContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;

public class LocalizedStringRenderer
extends StringRenderer {
    private String language;
    private boolean forceShowLanguage;
    private boolean languageShown;
    private boolean inline;
    private String languageClasses;

    public LocalizedStringRenderer() {
        this.setLanguageShown(true);
        this.setInline(true);
        this.setShowLanguageForced(false);
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public boolean isInline() {
        return this.inline;
    }

    public void setInline(boolean inline) {
        this.inline = inline;
    }

    public boolean isLanguageShown() {
        return this.languageShown;
    }

    public void setLanguageShown(boolean languageShown) {
        this.languageShown = languageShown;
    }

    public String getLanguageClasses() {
        return this.languageClasses;
    }

    public void setLanguageClasses(String languageClasses) {
        this.languageClasses = languageClasses;
    }

    public boolean isShowLanguageForced() {
        return this.forceShowLanguage;
    }

    public void setShowLanguageForced(boolean forceShowLanguage) {
        this.forceShowLanguage = forceShowLanguage;
    }

    @Override
    protected HtmlComponent renderComponent(Layout layout, Object object, Class type) {
        if (object == null) {
            return super.renderComponent(layout, null, type);
        }
        LocalizedString mlString = this.getLocalized(object);
        String value = this.getRenderedText(mlString);
        HtmlComponent component = super.renderComponent(layout, value, type);
        if (mlString.isEmpty()) {
            return component;
        }
        Locale contentLocale = this.getUsedLanguage(mlString);
        String language = contentLocale.getLanguage();
        if (language.equals(I18N.getLocale().getLanguage()) && !this.isShowLanguageForced() && !this.isLanguageShown()) {
            return component;
        }
        component.setLanguage(contentLocale.toLanguageTag());
        HtmlContainer container = this.isInline() ? new HtmlInlineContainer() : new HtmlBlockContainer();
        container.addChild(component);
        container.setIndented(false);
        HtmlText languageComponent = contentLocale == null ? new HtmlText() : new HtmlText(" (" + contentLocale.getDisplayLanguage(I18N.getLocale()) + ")");
        languageComponent.setClasses(this.getLanguageClasses());
        languageComponent.addClass("otherLanguage");
        container.addChild(languageComponent);
        return container;
    }

    private Locale getUsedLanguage(LocalizedString mlString) {
        Locale locale = this.getLanguage() != null ? new Locale.Builder().setLanguageTag(this.getLanguage()).build() : I18N.getLocale();
        return this.getAvailableLocaleFromMls(mlString, locale);
    }

    private Locale getAvailableLocaleFromMls(LocalizedString mlString, Locale locale) {
        if (mlString.getContent(locale) != null) {
            return locale;
        }
        Locale lessSpecific = this.generifyLocale(locale);
        if (lessSpecific != null) {
            return this.getAvailableLocaleFromMls(mlString, lessSpecific);
        }
        return mlString.getLocales().isEmpty() ? null : (Locale)mlString.getLocales().iterator().next();
    }

    private Locale generifyLocale(Locale locale) {
        if (Strings.isNullOrEmpty((String)locale.getVariant())) {
            if (Strings.isNullOrEmpty((String)locale.getCountry())) {
                return null;
            }
            return new Locale(locale.getLanguage());
        }
        return new Locale(locale.getLanguage(), locale.getCountry());
    }

    protected String getRenderedText(LocalizedString mlString) {
        Locale locale = this.getUsedLanguage(mlString);
        return locale == null ? null : mlString.getContent(locale);
    }

    protected LocalizedString getLocalized(Object object) {
        if (object instanceof LocalizedString) {
            return (LocalizedString)object;
        }
        return null;
    }
}

