/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.rendererExtensions;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.fenixedu.commons.i18n.I18N;
import org.joda.time.Interval;
import pt.ist.fenixWebFramework.renderers.InputRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlHiddenField;
import pt.ist.fenixWebFramework.renderers.components.HtmlInlineContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlParagraphContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.components.HtmlTextInput;
import pt.ist.fenixWebFramework.renderers.components.controllers.HtmlController;
import pt.ist.fenixWebFramework.renderers.components.converters.ConversionException;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;
import pt.ist.fenixWebFramework.renderers.components.state.IViewState;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;
import pt.ist.fenixWebFramework.renderers.model.MetaSlotKey;

public class IntervalAsDatesInputRenderer
extends InputRenderer {
    private String startLabel;
    private String endLabel;
    private boolean multiLine = true;
    private String dateFormat;
    private String dateSize;
    private Integer dateMaxLength = 10;

    public boolean isMultiLine() {
        return this.multiLine;
    }

    public void setMultiLine(boolean multiLine) {
        this.multiLine = multiLine;
    }

    public String getStartLabel() {
        return this.startLabel;
    }

    public void setStartLabel(String startLabel) {
        this.startLabel = startLabel;
    }

    public String getEndLabel() {
        return this.endLabel;
    }

    public void setEndLabel(String endLabel) {
        this.endLabel = endLabel;
    }

    public String getDateFormat() {
        return this.dateFormat == null ? "dd/MM/yyyy" : this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public Integer getDateMaxLength() {
        return this.dateMaxLength;
    }

    public void setDateMaxLength(Integer dateMaxLength) {
        this.dateMaxLength = dateMaxLength;
    }

    public String getDateSize() {
        return this.dateSize;
    }

    public void setDateSize(String dateSize) {
        this.dateSize = dateSize;
    }

    protected Locale getLocale() {
        return I18N.getLocale();
    }

    @Override
    protected Layout getLayout(Object object, Class type) {
        return new IntervalLayout(new SimpleDateFormat(this.getDateFormat(), this.getLocale()), this.startLabel, this.endLabel);
    }

    private class IntervalController
    extends HtmlController {
        private final HtmlHiddenField valueField;
        private final DateFormat dateFormat;
        private final HtmlTextInput startDateField;
        private final HtmlTextInput endDateField;

        public IntervalController(HtmlHiddenField hiddenField, DateFormat dateFormat, HtmlTextInput startDateField, HtmlTextInput endDateField) {
            this.valueField = hiddenField;
            this.dateFormat = dateFormat;
            this.startDateField = startDateField;
            this.endDateField = endDateField;
        }

        @Override
        public void execute(IViewState viewState) {
            String startValue = this.startDateField.getValue();
            String endValue = this.endDateField.getValue();
            if ((startValue == null || startValue.isEmpty()) && (endValue == null || endValue.isEmpty())) {
                this.valueField.setValue(null);
            } else {
                try {
                    Date startDate = this.dateFormat.parse(startValue);
                    Date endDate = this.dateFormat.parse(endValue);
                    String value = String.format("%s;%s", startDate.getTime(), endDate.getTime());
                    this.valueField.setValue(value);
                }
                catch (Exception e) {
                    this.valueField.setValue("invalid");
                }
            }
        }
    }

    public static class IntervalConverter
    extends Converter {
        public static final String INVALID = "invalid";

        public Interval convert(Class type, Object value) {
            if (value == null || String.valueOf(value).length() == 0) {
                return null;
            }
            try {
                if (value.equals(INVALID)) {
                    throw new ConversionException("fenix.renderers.converter.interval.convert", true, value);
                }
                String[] fields = String.valueOf(value).split(";");
                return new Interval(Long.parseLong(fields[0]), Long.parseLong(fields[1]));
            }
            catch (Exception e) {
                throw new ConversionException("fenix.renderers.converter.interval.convert", (Throwable)e, true, value);
            }
        }
    }

    public class IntervalLayout
    extends Layout {
        private final DateFormat dateFormat;
        private final String startLabel;
        private final String endLabel;
        private final boolean multiLine;

        public IntervalLayout(DateFormat simpleDateFormat, String startLabel, String endLabel) {
            this.multiLine = IntervalAsDatesInputRenderer.this.isMultiLine();
            this.dateFormat = simpleDateFormat;
            this.startLabel = startLabel;
            this.endLabel = endLabel;
        }

        private HtmlContainer getContainer() {
            return this.multiLine ? new HtmlParagraphContainer() : new HtmlInlineContainer();
        }

        @Override
        public HtmlComponent createComponent(Object object, Class type) {
            Interval interval = (Interval)object;
            MetaSlotKey key = (MetaSlotKey)IntervalAsDatesInputRenderer.this.getInputContext().getMetaObject().getKey();
            HtmlInlineContainer parentContainer = new HtmlInlineContainer();
            HtmlHiddenField hiddenField = new HtmlHiddenField();
            hiddenField.setTargetSlot(key);
            parentContainer.addChild(hiddenField);
            HtmlContainer startContainer = this.getContainer();
            if (this.startLabel != null) {
                startContainer.addChild(new HtmlText(this.startLabel));
            }
            HtmlTextInput startDateField = new HtmlTextInput();
            startDateField.setName(key.toString() + "_StartDate");
            startDateField.setSize(IntervalAsDatesInputRenderer.this.getDateSize());
            startDateField.setMaxLength(IntervalAsDatesInputRenderer.this.getDateMaxLength());
            startContainer.addChild(startDateField);
            startContainer.addChild(new HtmlText(this.getFormatLabel()));
            HtmlContainer endContainer = this.getContainer();
            if (this.endLabel != null) {
                endContainer.addChild(new HtmlText(this.endLabel));
            }
            HtmlTextInput endDateField = new HtmlTextInput();
            endDateField.setName(key.toString() + "_EndDate");
            endDateField.setSize(IntervalAsDatesInputRenderer.this.getDateSize());
            endDateField.setMaxLength(IntervalAsDatesInputRenderer.this.getDateMaxLength());
            endContainer.addChild(endDateField);
            endContainer.addChild(new HtmlText(this.getFormatLabel()));
            parentContainer.addChild(startContainer);
            parentContainer.addChild(endContainer);
            if (interval != null) {
                startDateField.setValue(this.dateFormat.format(interval.getStart().toDate()));
                endDateField.setValue(this.dateFormat.format(interval.getEnd().toDate()));
            }
            hiddenField.setConverter(new IntervalConverter());
            endDateField.setController(new IntervalController(hiddenField, this.dateFormat, startDateField, endDateField));
            return parentContainer;
        }

        protected String getFormatLabel() {
            return IntervalAsDatesInputRenderer.this.getDateFormat();
        }
    }
}

