/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.rendererExtensions;

import java.util.Calendar;
import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.DateTimeFieldType;
import org.joda.time.Duration;
import org.joda.time.ReadablePeriod;
import org.joda.time.TimeOfDay;
import pt.ist.fenixWebFramework.renderers.DateRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;

public class DurationRenderer
extends DateRenderer {
    private boolean showFormat = false;
    private Duration duration;

    public boolean isShowFormat() {
        return this.showFormat;
    }

    public void setShowFormat(boolean showFormat) {
        this.showFormat = showFormat;
    }

    @Override
    public String getFormat() {
        if (this.isFormatSet()) {
            return super.getFormat();
        }
        String format = "HH:mm:ss";
        return format.trim();
    }

    @Override
    protected Layout getLayout(Object object, Class type) {
        this.duration = (Duration)object;
        DateTime dateTime = TimeOfDay.MIDNIGHT.toDateTimeToday().plus((ReadablePeriod)this.duration.toPeriod());
        final Date date = dateTime != null ? this.convertDateTimeToCalendar(dateTime).getTime() : null;
        final Layout superLayout = super.getLayout(date, type);
        return new Layout(){

            @Override
            public HtmlComponent createComponent(Object object, Class type) {
                HtmlText text = (HtmlText)superLayout.createComponent(date, type);
                String formatText = DurationRenderer.this.isShowFormat() ? " (" + DurationRenderer.this.getFormat() + ")" : "";
                text.setText(text.getText() + formatText);
                return text;
            }
        };
    }

    private Calendar convertDateTimeToCalendar(DateTime dt) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(11, dt.get(DateTimeFieldType.hourOfDay()));
        calendar.set(12, dt.get(DateTimeFieldType.minuteOfHour()));
        calendar.set(13, dt.get(DateTimeFieldType.secondOfMinute()));
        return calendar;
    }
}

