/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.validators;

import com.google.common.base.Predicate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import pt.ist.fenixWebFramework.renderers.validators.DateValidator;
import pt.ist.fenixWebFramework.renderers.validators.HtmlChainValidator;

public class AdvancedDateValidator
extends DateValidator {
    private String validationPeriod;
    private static Predicate<DateTime> pastPredicate = new Predicate<DateTime>(){

        public boolean apply(DateTime dateTime) {
            return dateTime.isBeforeNow();
        }
    };
    private static Predicate<DateTime> pastOrTodayPredicate = new Predicate<DateTime>(){

        public boolean apply(DateTime dateTime) {
            return dateTime.isBeforeNow() || dateTime.toLocalDate().isEqual((ReadablePartial)new LocalDate());
        }
    };
    private static Predicate<DateTime> futurePredicate = new Predicate<DateTime>(){

        public boolean apply(DateTime dateTime) {
            return dateTime.isAfterNow();
        }
    };

    public AdvancedDateValidator() {
    }

    public AdvancedDateValidator(HtmlChainValidator htmlChainValidator) {
        super(htmlChainValidator);
    }

    public AdvancedDateValidator(HtmlChainValidator htmlChainValidator, String dateFormat) {
        super(htmlChainValidator, dateFormat);
    }

    @Override
    public void performValidation() {
        super.performValidation();
        if (this.isValid()) {
            try {
                DateTime dateTime = new DateTime(new SimpleDateFormat(this.getDateFormat()).parse(this.getComponent().getValue()).getTime());
                this.setValid(this.getValidationPeriodType().evaluateDate(dateTime));
            }
            catch (ParseException e) {
                this.setValid(false);
                e.printStackTrace();
            }
        }
    }

    public String getValidationPeriod() {
        return this.validationPeriod;
    }

    public void setValidationPeriod(String validationPeriod) {
        this.validationPeriod = validationPeriod;
        this.setMessage("renderers.validator.advancedDate." + this.getValidationPeriod());
    }

    public ValidationPeriodType getValidationPeriodType() {
        if (this.validationPeriod != null) {
            return ValidationPeriodType.valueOf(this.getValidationPeriod().toUpperCase());
        }
        return null;
    }

    static /* synthetic */ Predicate access$000() {
        return pastPredicate;
    }

    static /* synthetic */ Predicate access$100() {
        return pastOrTodayPredicate;
    }

    static /* synthetic */ Predicate access$200() {
        return futurePredicate;
    }

    private static enum ValidationPeriodType {
        PAST((Predicate<DateTime>)AdvancedDateValidator.access$000()),
        PASTORTODAY((Predicate<DateTime>)AdvancedDateValidator.access$100()),
        FUTURE((Predicate<DateTime>)AdvancedDateValidator.access$200());

        private Predicate<DateTime> predicate;

        private ValidationPeriodType(Predicate<DateTime> predicate) {
            this.predicate = predicate;
        }

        protected boolean evaluateDate(DateTime dateTime) {
            return this.predicate.apply((Object)dateTime);
        }
    }
}

