/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.taglib;

import java.io.IOException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.beanutils.PropertyUtils;
import org.fenixedu.bennu.core.security.Authenticate;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.state.IViewState;
import pt.ist.fenixWebFramework.renderers.components.state.ViewDestination;
import pt.ist.fenixWebFramework.renderers.contexts.PresentationContext;
import pt.ist.fenixWebFramework.renderers.schemas.Schema;
import pt.ist.fenixWebFramework.renderers.utils.RenderKit;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

public abstract class BaseRenderObjectTag
extends TagSupport {
    private String name;
    private String scope;
    private String property;
    private String type;
    private String layout;
    private String schema;
    private Schema anonymousSchema;
    private Properties properties;
    private String sortBy;
    private Map<String, ViewDestination> destinations = new Hashtable<String, ViewDestination>();

    public void release() {
        super.release();
        this.name = null;
        this.scope = null;
        this.property = null;
        this.type = null;
        this.layout = null;
        this.schema = null;
        this.properties = null;
        this.destinations = new Hashtable<String, ViewDestination>();
    }

    public Schema getAnonymousSchema() {
        return this.anonymousSchema;
    }

    public void setAnonymousSchema(Schema anonymousSchema) {
        this.anonymousSchema = anonymousSchema;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getLayout() {
        if (this.layout == null) {
            return null;
        }
        if (this.layout.equals("")) {
            return null;
        }
        return this.layout;
    }

    public void setLayout(String layout) {
        this.layout = layout;
    }

    public void setTemplate(String template) {
        this.layout = "template";
        this.addRenderProperty("template", template);
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public String getSchema() {
        if (this.schema == null) {
            return null;
        }
        if (this.schema.equals("")) {
            return null;
        }
        return this.schema;
    }

    public Properties getRenderProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        return this.properties;
    }

    public void addRenderProperty(String name, String value) {
        this.getRenderProperties().setProperty(name, value);
    }

    public static int getScopeByName(String scope) throws JspException {
        switch (scope.toLowerCase()) {
            case "request": {
                return 2;
            }
            case "page": {
                return 1;
            }
            case "session": {
                return 3;
            }
            case "application": {
                return 4;
            }
        }
        throw new IllegalArgumentException("Cannot find page scope: " + scope);
    }

    protected Object getTargetObject() throws JspException {
        Object object = this.getTargetObjectByName();
        return this.getTargetObjectByProperty(object);
    }

    protected Object getTargetObjectByProperty(Object object) {
        if (object != null && this.getProperty() != null) {
            try {
                return PropertyUtils.getProperty((Object)object, (String)this.getProperty());
            }
            catch (Exception e) {
                throw new RuntimeException("object '" + object + "' does not have property '" + this.getProperty() + "'", e);
            }
        }
        return object;
    }

    protected Object getTargetObjectByName() throws JspException {
        if (this.getName() != null) {
            if (this.getScope() != null && this.getScope().length() > 0) {
                return this.pageContext.getAttribute(this.getName(), BaseRenderObjectTag.getScopeByName(this.getScope()));
            }
            return this.pageContext.findAttribute(this.getName());
        }
        return null;
    }

    public int doStartTag() throws JspException {
        return 1;
    }

    public int doEndTag() throws JspException {
        Object object = this.getTargetObject();
        if (object == null && !this.isNullAccepted()) {
            throw new RuntimeException("cannot present the null value, name='" + this.getName() + "' property='" + this.getProperty() + "' scope='" + this.getScope() + "'");
        }
        if (object instanceof List) {
            object = this.sortCollection((Collection)object);
        }
        String layout = this.getLayout();
        Properties properties = this.getRenderProperties();
        PresentationContext context = this.createPresentationContext(object, layout, this.getRealSchema(), properties);
        context.getViewState().setUser(Authenticate.getUser());
        HtmlComponent component = this.renderObject(context, object);
        try {
            this.drawComponent(context, component);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new JspException("failed to render component", (Throwable)e);
        }
        this.release();
        return 6;
    }

    protected Schema getRealSchema() {
        Schema anonymousSchema = this.getAnonymousSchema();
        return anonymousSchema != null ? anonymousSchema : RenderKit.getInstance().findSchema(this.getSchema());
    }

    protected boolean isNullAccepted() {
        return this.getType() != null;
    }

    protected Collection sortCollection(Collection collection) {
        if (this.getSortBy() != null) {
            return RenderUtils.sortCollectionWithCriteria(collection, this.getSortBy());
        }
        return collection;
    }

    protected abstract PresentationContext createPresentationContext(Object var1, String var2, Schema var3, Properties var4);

    protected abstract HtmlComponent renderObject(PresentationContext var1, Object var2) throws JspException;

    protected void drawComponent(PresentationContext context, HtmlComponent component) throws IOException, JspException {
        component.draw(this.pageContext);
    }

    protected ViewDestination normalizeDestination(ViewDestination destination, String currentPath, String module) {
        if (destination.getModule() == null) {
            destination.setModule(module);
        }
        if (destination.getPath() == null) {
            destination.setPath(currentPath);
        }
        return destination;
    }

    public void addDestination(String name, String path, String module, boolean redirect) {
        this.destinations.put(name, new ViewDestination(path, module, redirect));
    }

    public Map<String, ViewDestination> getDestinations() {
        return this.destinations;
    }

    protected void setViewStateDestinations(IViewState viewState) {
        viewState.setInputDestination(this.getInputDestination());
        String currentPath = this.getCurrentPath();
        String module = RenderUtils.getModule((HttpServletRequest)this.pageContext.getRequest());
        for (String name : this.getDestinations().keySet()) {
            ViewDestination destination = this.getDestinations().get(name);
            viewState.addDestination(name, this.normalizeDestination(destination, currentPath, module));
        }
    }

    protected ViewDestination getInputDestination() {
        String currentPath = this.getCurrentPath();
        String module = RenderUtils.getModule((HttpServletRequest)this.pageContext.getRequest());
        return new ViewDestination(currentPath, module, false);
    }

    protected String getCurrentPath() {
        HttpServletRequest request;
        String module;
        String contextPath;
        String mapping = RenderUtils.getCurrentActionMappingURL(this.pageContext);
        String currentPath = mapping != null ? mapping : ((HttpServletRequest)this.pageContext.getRequest()).getServletPath();
        if (currentPath.startsWith(contextPath = ((HttpServletRequest)this.pageContext.getRequest()).getContextPath())) {
            currentPath = currentPath.substring(contextPath.length());
        }
        if ((module = RenderUtils.getModule((HttpServletRequest)this.pageContext.getRequest())) != null && currentPath.startsWith(module)) {
            currentPath = currentPath.substring(module.length());
        }
        if ((request = (HttpServletRequest)this.pageContext.getRequest()).getQueryString() != null) {
            currentPath = currentPath + "?" + request.getQueryString();
        }
        return currentPath;
    }

    public static Object lookup(PageContext pageContext, String name, String property, String scope) throws JspException {
        Object bean;
        Object object = bean = scope == null ? pageContext.findAttribute(name) : pageContext.getAttribute(name, BaseRenderObjectTag.getScopeByName(scope));
        if (bean == null || property == null) {
            return bean;
        }
        try {
            return PropertyUtils.getProperty((Object)bean, (String)property);
        }
        catch (Exception e) {
            throw new JspException("Error while getting property '" + property + "' of " + bean, (Throwable)e);
        }
    }
}

