/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.components.state;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.fenixedu.bennu.core.security.Authenticate;
import pt.ist.fenixWebFramework.renderers.components.state.IViewState;
import pt.ist.fenixWebFramework.renderers.components.state.LifeCycleConstants;
import pt.ist.fenixWebFramework.renderers.components.state.ViewState;

public class EditRequest
extends HttpServletRequestWrapper {
    private List<IViewState> viewStates;
    private final String publicModuleName = "publico";

    public EditRequest(HttpServletRequest request) {
        super(request);
    }

    public List<IViewState> getAllViewStates() throws IOException, ClassNotFoundException {
        if (this.viewStates == null) {
            this.viewStates = ViewState.decodeFromBase64(this.getParameter(LifeCycleConstants.VIEWSTATE_PARAM_NAME));
        }
        String contextPath = ((HttpServletRequest)this.getRequest()).getContextPath();
        String requestURI = ((HttpServletRequest)this.getRequest()).getRequestURI().toString();
        for (IViewState viewState : this.viewStates) {
            viewState.setRequest((HttpServletRequest)this);
            this.checkUserIdentity(viewState, requestURI, contextPath);
        }
        return this.viewStates;
    }

    private void checkUserIdentity(IViewState viewState, String requestURI, String contextPath) {
        if (!requestURI.startsWith(contextPath + "/" + "publico" + "/") && !Objects.equals(viewState.getUser(), Authenticate.getUser())) {
            throw new ViewStateUserChangedException();
        }
    }

    public static class ViewStateUserChangedException
    extends RuntimeException {
        public ViewStateUserChangedException() {
            super("viewstate.user.changed");
        }
    }
}

