/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import pt.ist.fenixWebFramework.renderers.InputRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlBlockContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlFormComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlImage;
import pt.ist.fenixWebFramework.renderers.components.HtmlScript;
import pt.ist.fenixWebFramework.renderers.components.HtmlTable;
import pt.ist.fenixWebFramework.renderers.components.HtmlTableCell;
import pt.ist.fenixWebFramework.renderers.components.HtmlTableRow;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.components.Validatable;
import pt.ist.fenixWebFramework.renderers.layouts.FormLayout;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;
import pt.ist.fenixWebFramework.renderers.model.MetaObject;
import pt.ist.fenixWebFramework.renderers.model.MetaSlot;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixWebFramework.renderers.validators.HtmlChainValidator;

public class StandardInputRenderer
extends InputRenderer {
    private String rowClasses;
    private String columnClasses;
    private String validatorClasses;
    private boolean hideValidators = false;
    private String labelTerminator;
    private boolean displayLabel = Boolean.TRUE;
    private boolean requiredMessageShown = true;
    private boolean optionalMarkShown = false;
    private String helpNoJavascriptClasses;
    private String helpClosedClasses;
    private String helpOpenClasses;
    private String helpTextClasses;
    private String helpImageIcon;

    public boolean isDisplayLabel() {
        return this.displayLabel;
    }

    public void setDisplayLabel(boolean displayLabel) {
        this.displayLabel = displayLabel;
    }

    public String getColumnClasses() {
        return this.columnClasses;
    }

    public void setColumnClasses(String columnClasses) {
        this.columnClasses = columnClasses;
    }

    public String getRowClasses() {
        return this.rowClasses;
    }

    public void setRowClasses(String rowClasses) {
        this.rowClasses = rowClasses;
    }

    public boolean isHideValidators() {
        return this.hideValidators;
    }

    public void setHideValidators(boolean hideValidators) {
        this.hideValidators = hideValidators;
    }

    public String getValidatorClasses() {
        return this.validatorClasses;
    }

    public void setValidatorClasses(String validatorClasses) {
        this.validatorClasses = validatorClasses;
    }

    public String getLabelTerminator() {
        return this.labelTerminator;
    }

    public void setLabelTerminator(String labelTerminator) {
        this.labelTerminator = labelTerminator;
    }

    @Override
    protected Layout getLayout(Object object, Class type) {
        return new ObjectInputFormLayout(this.getContext().getMetaObject());
    }

    public boolean isOptionalMarkShown() {
        return this.optionalMarkShown;
    }

    public void setOptionalMarkShown(boolean optionalMarkShown) {
        this.optionalMarkShown = optionalMarkShown;
    }

    public boolean isRequiredMessageShown() {
        return this.requiredMessageShown;
    }

    public void setRequiredMessageShown(boolean requiredMessageShown) {
        this.requiredMessageShown = requiredMessageShown;
    }

    public String getHelpImageIcon() {
        return this.helpImageIcon;
    }

    public void setHelpImageIcon(String helpImageIcon) {
        this.helpImageIcon = helpImageIcon;
    }

    public String getHelpNoJavascriptClasses() {
        return this.helpNoJavascriptClasses;
    }

    public void setHelpNoJavascriptClasses(String helpNoJavascript) {
        this.helpNoJavascriptClasses = helpNoJavascript;
    }

    public String getHelpClosedClasses() {
        return this.helpClosedClasses;
    }

    public void setHelpClosedClasses(String helpClosed) {
        this.helpClosedClasses = helpClosed;
    }

    public String getHelpOpenClasses() {
        return this.helpOpenClasses;
    }

    public void setHelpOpenClasses(String helpOpen) {
        this.helpOpenClasses = helpOpen;
    }

    public String getHelpTextClasses() {
        return this.helpTextClasses;
    }

    public void setHelpTextClasses(String helpTextClasses) {
        this.helpTextClasses = helpTextClasses;
    }

    class ObjectInputTabularLayout {
        public ObjectInputTabularLayout(MetaObject object) {
        }

        protected HtmlComponent renderHelpOnComponent(HtmlComponent renderedSlot, String bundle, String helpLabel, String slotName) {
            String id = slotName + ":" + System.currentTimeMillis();
            HtmlBlockContainer container = new HtmlBlockContainer();
            HtmlBlockContainer helpContainer = new HtmlBlockContainer();
            helpContainer.setId(id);
            helpContainer.setClasses(StandardInputRenderer.this.getHelpNoJavascriptClasses());
            helpContainer.setOnMouseOver(this.getScript(id, StandardInputRenderer.this.getHelpOpenClasses()));
            helpContainer.setOnMouseOut(this.getScript(id, StandardInputRenderer.this.getHelpClosedClasses()));
            HtmlImage htmlImage = new HtmlImage();
            htmlImage.setSource(StandardInputRenderer.this.getHelpImageIcon());
            htmlImage.setDescription("help icon");
            helpContainer.addChild(htmlImage);
            HtmlBlockContainer textContainer = new HtmlBlockContainer();
            textContainer.setClasses(StandardInputRenderer.this.getHelpTextClasses());
            textContainer.addChild(new HtmlText(RenderUtils.getResourceString(bundle, helpLabel), false));
            helpContainer.addChild(textContainer);
            container.addChild(helpContainer);
            HtmlScript script = new HtmlScript();
            script.setContentType("text/javascript");
            script.setScript(this.getScript(id, StandardInputRenderer.this.getHelpClosedClasses()));
            container.addChild(script);
            HtmlTable table = new HtmlTable();
            HtmlTableRow row = table.createRow();
            HtmlTableCell cell = row.createCell();
            cell.setBody(renderedSlot);
            HtmlTableCell anotherCell = row.createCell();
            anotherCell.setBody(container);
            return table;
        }

        protected String getScript(String id, String classes) {
            return String.format("document.getElementById('%s').className='%s';", id, classes);
        }
    }

    class ObjectInputFormLayout
    extends FormLayout {
        private final MetaObject object;
        private final Map<Integer, Validatable> inputComponents;

        public ObjectInputFormLayout(MetaObject object) {
            this.object = object;
            this.inputComponents = new HashMap<Integer, Validatable>();
        }

        @Override
        public int getNumberOfRows() {
            return this.object.getSlots().size();
        }

        @Override
        public String getLabelText(int rowIndex) {
            MetaSlot slot = this.object.getSlots().get(rowIndex);
            return slot.getLabel();
        }

        @Override
        public HtmlComponent getRenderedSlot(int rowIndex) {
            Validatable validatable;
            MetaSlot slot = this.object.getSlots().get(rowIndex);
            HtmlComponent renderedSlot = StandardInputRenderer.this.renderSlot(slot);
            if (!slot.isReadOnly() && (validatable = StandardInputRenderer.this.findValidatableComponent(renderedSlot)) != null) {
                HtmlFormComponent formComponent = (HtmlFormComponent)validatable;
                if (formComponent.getId() == null) {
                    formComponent.setId(slot.getKey().toString());
                }
                this.inputComponents.put(rowIndex, validatable);
            }
            return renderedSlot;
        }

        @Override
        public Supplier<Optional<String>> getValidationError(int rowIndex) {
            HtmlChainValidator chainValidator;
            if (StandardInputRenderer.this.isHideValidators()) {
                return Optional::empty;
            }
            Validatable inputComponent = this.inputComponents.get(rowIndex);
            if (inputComponent != null && (chainValidator = StandardInputRenderer.this.getChainValidator(inputComponent, this.object.getSlots().get(rowIndex))) != null && !chainValidator.isEmpty()) {
                return () -> {
                    if (chainValidator.isValid()) {
                        return Optional.empty();
                    }
                    return Optional.ofNullable(chainValidator.getErrorMessage());
                };
            }
            return Optional::empty;
        }

        @Override
        public Optional<String> getHelpLabel(int rowIndex) {
            MetaSlot slot = this.object.getSlots().get(rowIndex);
            if (!slot.hasHelp()) {
                return Optional.empty();
            }
            String value = RenderUtils.getResourceString(slot.getBundle(), slot.getHelpLabel());
            return value == null ? Optional.of("!" + slot.getHelpLabel() + "!") : Optional.of(value);
        }

        @Override
        public boolean displayLabel() {
            return StandardInputRenderer.this.isDisplayLabel();
        }
    }
}

