/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.commons.beanutils.PropertyUtils;
import pt.ist.fenixWebFramework.renderers.DataProvider;
import pt.ist.fenixWebFramework.renderers.InputRenderer;
import pt.ist.fenixWebFramework.renderers.components.converters.ConversionException;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;
import pt.ist.fenixWebFramework.renderers.model.MetaObject;
import pt.ist.fenixWebFramework.renderers.model.MetaSlot;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

public abstract class SelectionRenderer
extends InputRenderer {
    private String providerClass;
    private String from;
    private DataProvider provider;
    private String sortBy;

    public String getProviderClass() {
        return this.providerClass;
    }

    public void setProviderClass(String providerClass) {
        this.providerClass = providerClass;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    protected DataProvider getProvider() {
        if (this.provider == null) {
            String className = this.getProviderClass();
            try {
                if (this.providerClass != null) {
                    Class<?> providerCass = Class.forName(className);
                    this.provider = (DataProvider)providerCass.newInstance();
                } else {
                    this.provider = new FromProvider();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("could not get a data provider instance", e);
            }
        }
        return this.provider;
    }

    protected Converter getConverter() {
        return this.getProvider() == null ? null : this.getProvider().getConverter();
    }

    protected Collection<?> getPossibleObjects() {
        Object object = ((MetaSlot)this.getInputContext().getMetaObject()).getMetaObject().getObject();
        Object value = this.getInputContext().getMetaObject().getObject();
        Collection collection = (Collection)this.getProvider().provide(object, value);
        if (this.getSortBy() == null) {
            return collection;
        }
        return RenderUtils.sortCollectionWithCriteria(collection, this.getSortBy());
    }

    protected static class MultipleSelectOptionConverter
    extends Converter {
        private final List<MetaObject> metaObjects;
        private final Converter converter;

        public MultipleSelectOptionConverter(List<MetaObject> metaObjects, Converter converter) {
            this.metaObjects = metaObjects;
            this.converter = converter;
        }

        @Override
        public Object convert(Class type, Object value) {
            String[] textValues = (String[])value;
            if (textValues == null || textValues.length == 0) {
                return new ArrayList();
            }
            if (this.converter != null) {
                return this.converter.convert(type, value);
            }
            ArrayList<Object> result = new ArrayList<Object>();
            for (MetaObject metaObject : this.metaObjects) {
                for (String textValue : textValues) {
                    if (!textValue.equals(metaObject.getKey().toString())) continue;
                    result.add(metaObject.getObject());
                }
            }
            return result;
        }
    }

    protected static class SingleSelectOptionConverter
    extends Converter {
        private final List<MetaObject> metaObjects;
        private final Converter converter;

        public SingleSelectOptionConverter(List<MetaObject> metaObjects, Converter converter) {
            this.metaObjects = metaObjects;
            this.converter = converter;
        }

        @Override
        public Object convert(Class type, Object value) {
            String textValue = (String)value;
            if (textValue == null || textValue.length() == 0) {
                return null;
            }
            if (this.converter != null) {
                return this.converter.convert(type, value);
            }
            for (MetaObject metaObject : this.metaObjects) {
                if (!textValue.equals(metaObject.getKey().toString())) continue;
                return metaObject.getObject();
            }
            throw new ConversionException("renderers.select.convert.invalid.value");
        }
    }

    private class FromProvider
    implements DataProvider {
        private FromProvider() {
        }

        @Override
        public Object provide(Object source, Object currentValue) {
            try {
                if (source != null) {
                    return PropertyUtils.getProperty((Object)source, (String)SelectionRenderer.this.getFrom());
                }
                Class type = SelectionRenderer.this.getInputContext().getMetaObject().getType();
                String getter = SelectionRenderer.this.getFrom();
                getter = "get" + getter.substring(0, 1).toUpperCase(Locale.ENGLISH) + getter.substring(1);
                return type.getMethod(getter, new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("exception while accessing 'from' collection", e);
            }
        }

        @Override
        public Converter getConverter() {
            return null;
        }
    }
}

