/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import pt.ist.fenixWebFramework.renderers.SelectionRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlMenu;
import pt.ist.fenixWebFramework.renderers.components.HtmlMenuOption;
import pt.ist.fenixWebFramework.renderers.components.converters.BiDirectionalConverter;
import pt.ist.fenixWebFramework.renderers.contexts.PresentationContext;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;
import pt.ist.fenixWebFramework.renderers.model.MetaObject;
import pt.ist.fenixWebFramework.renderers.model.MetaObjectFactory;
import pt.ist.fenixWebFramework.renderers.model.MetaSlotKey;
import pt.ist.fenixWebFramework.renderers.schemas.Schema;
import pt.ist.fenixWebFramework.renderers.utils.RenderKit;
import pt.ist.fenixWebFramework.renderers.utils.RenderMode;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

public class MenuOptionListRenderer
extends SelectionRenderer {
    private String format;
    private String eachSchema;
    private String eachLayout;
    private boolean saveOptions;
    private boolean nullOptionHidden;
    private String defaultText;
    private String bundle;
    private boolean key;

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getEachLayout() {
        return this.eachLayout;
    }

    public void setEachLayout(String eachLayout) {
        this.eachLayout = eachLayout;
    }

    public String getEachSchema() {
        return this.eachSchema;
    }

    public void setEachSchema(String eachSchema) {
        this.eachSchema = eachSchema;
    }

    public String getBundle() {
        return this.bundle;
    }

    public void setBundle(String bundle) {
        this.bundle = bundle;
    }

    public String getDefaultText() {
        return this.defaultText;
    }

    public void setDefaultText(String defaultText) {
        this.defaultText = defaultText;
    }

    public boolean isKey() {
        return this.key;
    }

    public void setKey(boolean key) {
        this.key = key;
    }

    public boolean isSaveOptions() {
        return this.saveOptions;
    }

    public void setSaveOptions(boolean saveOptions) {
        this.saveOptions = saveOptions;
    }

    public boolean isNullOptionHidden() {
        return this.nullOptionHidden;
    }

    public void setNullOptionHidden(boolean nullOptionHidden) {
        this.nullOptionHidden = nullOptionHidden;
    }

    @Override
    protected Layout getLayout(Object object, Class type) {
        return new MenuOptionLayout();
    }

    class MenuOptionLayout
    extends Layout {
        MenuOptionLayout() {
        }

        @Override
        public HtmlComponent createComponent(Object object, Class type) {
            List<MetaObject> possibleMetaObjects;
            HtmlMenu menu = new HtmlMenu();
            if (!MenuOptionListRenderer.this.isNullOptionHidden()) {
                String defaultOptionTitle = this.getDefaultTitle();
                menu.createDefaultOption(defaultOptionTitle).setSelected(object == null);
            }
            RenderKit kit = RenderKit.getInstance();
            Schema schema = kit.findSchema(MenuOptionListRenderer.this.getEachSchema());
            if (this.hasSavedPossibleMetaObjects()) {
                possibleMetaObjects = this.getPossibleMetaObjects();
            } else {
                possibleMetaObjects = new ArrayList<MetaObject>();
                for (MetaObject possibility : MenuOptionListRenderer.this.getPossibleObjects()) {
                    possibleMetaObjects.add(MetaObjectFactory.createObject(possibility, schema));
                }
            }
            for (MetaObject metaObject : possibleMetaObjects) {
                Object obj = metaObject.getObject();
                HtmlMenuOption option = menu.createOption(null);
                if (MenuOptionListRenderer.this.getConverter() instanceof BiDirectionalConverter) {
                    option.setValue(((BiDirectionalConverter)MenuOptionListRenderer.this.getConverter()).deserialize(obj));
                } else {
                    option.setValue(metaObject.getKey().toString());
                }
                if (Strings.isNullOrEmpty((String)MenuOptionListRenderer.this.getEachLayout())) {
                    if (Enum.class.isAssignableFrom(obj.getClass()) && Strings.isNullOrEmpty((String)MenuOptionListRenderer.this.getFormat())) {
                        this.fillBodyWithRenderKit(kit, metaObject, obj, option);
                    } else {
                        option.setText(this.getObjectLabel(obj));
                    }
                } else {
                    this.fillBodyWithRenderKit(kit, metaObject, obj, option);
                }
                if (!obj.equals(object)) continue;
                option.setSelected(true);
            }
            if (MenuOptionListRenderer.this.isSaveOptions()) {
                this.savePossibleMetaObjects(possibleMetaObjects);
            }
            menu.setConverter(new SelectionRenderer.SingleSelectOptionConverter(possibleMetaObjects, MenuOptionListRenderer.this.getConverter()));
            menu.setTargetSlot((MetaSlotKey)MenuOptionListRenderer.this.getInputContext().getMetaObject().getKey());
            return menu;
        }

        private void fillBodyWithRenderKit(RenderKit kit, MetaObject metaObject, Object obj, HtmlMenuOption option) {
            PresentationContext newContext = MenuOptionListRenderer.this.getContext().createSubContext(metaObject);
            newContext.setLayout(MenuOptionListRenderer.this.getEachLayout());
            newContext.setRenderMode(RenderMode.OUTPUT);
            HtmlComponent component = kit.render(newContext, obj);
            option.setBody(component);
        }

        private boolean hasSavedPossibleMetaObjects() {
            return MenuOptionListRenderer.this.getInputContext().getViewState().getLocalAttribute("options") != null;
        }

        private List<MetaObject> getPossibleMetaObjects() {
            return (List)MenuOptionListRenderer.this.getInputContext().getViewState().getLocalAttribute("options");
        }

        private void savePossibleMetaObjects(List<MetaObject> possibleMetaObjects) {
            MenuOptionListRenderer.this.getInputContext().getViewState().setLocalAttribute("options", possibleMetaObjects);
        }

        private String getDefaultTitle() {
            if (MenuOptionListRenderer.this.getDefaultText() == null) {
                return RenderUtils.getResourceString("renderers.menu.default.title");
            }
            if (MenuOptionListRenderer.this.isKey()) {
                return RenderUtils.getResourceString(MenuOptionListRenderer.this.getBundle(), MenuOptionListRenderer.this.getDefaultText());
            }
            return MenuOptionListRenderer.this.getDefaultText();
        }

        protected String getObjectLabel(Object object) {
            if (MenuOptionListRenderer.this.getFormat() != null) {
                return RenderUtils.getFormattedProperties(MenuOptionListRenderer.this.getFormat(), object);
            }
            return String.valueOf(object);
        }
    }
}

