/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers;

import com.google.common.base.Predicate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import pt.ist.fenixWebFramework.renderers.InputRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlHiddenField;
import pt.ist.fenixWebFramework.renderers.components.HtmlInlineContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlMenu;
import pt.ist.fenixWebFramework.renderers.components.HtmlMenuOption;
import pt.ist.fenixWebFramework.renderers.components.HtmlSimpleValueComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlTextInput;
import pt.ist.fenixWebFramework.renderers.contexts.InputContext;
import pt.ist.fenixWebFramework.renderers.contexts.PresentationContext;
import pt.ist.fenixWebFramework.renderers.converters.EnumConverter;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;
import pt.ist.fenixWebFramework.renderers.model.MetaObject;
import pt.ist.fenixWebFramework.renderers.model.MetaSlotKey;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

public class EnumInputRenderer
extends InputRenderer {
    private String defaultText;
    private String defaultTextBundle;
    private boolean defaultOptionHidden = false;
    private String bundle;
    private boolean key;
    private String excludedValues;
    private String includedValues;
    private boolean sort;
    private boolean readOnly;
    private boolean disabled;
    private String onChange;

    public String getBundle() {
        return this.bundle;
    }

    public void setBundle(String bundle) {
        this.bundle = bundle;
    }

    public String getDefaultText() {
        return this.defaultText;
    }

    public void setDefaultText(String defaultText) {
        this.defaultText = defaultText;
    }

    public boolean isDefaultOptionHidden() {
        return this.defaultOptionHidden;
    }

    public void setDefaultOptionHidden(boolean defaultOptionHidden) {
        this.defaultOptionHidden = defaultOptionHidden;
    }

    public String getExcludedValues() {
        return this.excludedValues;
    }

    public void setExcludedValues(String excludedValues) {
        this.excludedValues = excludedValues;
    }

    public String getIncludedValues() {
        return this.includedValues;
    }

    public void setIncludedValues(String includedValues) {
        this.includedValues = includedValues;
    }

    public boolean isKey() {
        return this.key;
    }

    public void setKey(boolean key) {
        this.key = key;
    }

    public String getOnChange() {
        return this.onChange;
    }

    public void setOnChange(String onChange) {
        this.onChange = onChange;
    }

    @Override
    protected Layout getLayout(Object object, Class type) {
        if (this.getReadOnly()) {
            return new Layout(){

                @Override
                public HtmlComponent createComponent(Object targetObject, Class type) {
                    Enum enumerate = (Enum)targetObject;
                    HtmlInlineContainer container = new HtmlInlineContainer();
                    HtmlHiddenField value = new HtmlHiddenField();
                    value.setValue(enumerate.name());
                    value.setConverter(new EnumConverter());
                    container.addChild(value);
                    InputContext context = EnumInputRenderer.this.getInputContext();
                    value.setTargetSlot((MetaSlotKey)context.getMetaObject().getKey());
                    HtmlTextInput component = new HtmlTextInput();
                    component.setValue(RenderUtils.getEnumString(enumerate));
                    container.addChild(component);
                    return container;
                }

                @Override
                public void applyStyle(HtmlComponent component) {
                    HtmlInlineContainer block = (HtmlInlineContainer)component;
                    HtmlTextInput textInput = (HtmlTextInput)block.getChild(new Predicate<HtmlComponent>(){

                        public boolean apply(HtmlComponent elem) {
                            return !(elem instanceof HtmlHiddenField);
                        }
                    });
                    super.applyStyle(textInput);
                    textInput.setReadOnly(true);
                    textInput.setDisabled(EnumInputRenderer.this.getDisabled());
                }
            };
        }
        return new Layout(){

            @Override
            public HtmlComponent createComponent(Object targetObject, Class type) {
                Enum enumerate = (Enum)targetObject;
                if (!type.isEnum() && Enum.class.isAssignableFrom(type)) {
                    type = type.getEnclosingClass();
                }
                Object bean = this.getRenderedObject();
                Collection constants = EnumInputRenderer.this.getIncludedEnumValues(type, bean);
                Collection excludedValues = EnumInputRenderer.this.getExcludedEnumValues(type, bean);
                ArrayList<EnumValues> pairList = new ArrayList<EnumValues>();
                for (Object object : constants) {
                    Enum oneEnum = (Enum)object;
                    pairList.add(new EnumValues(oneEnum, RenderUtils.getEnumString(oneEnum, EnumInputRenderer.this.getBundle())));
                }
                if (EnumInputRenderer.this.isSort()) {
                    Collections.sort(pairList, new Comparator<EnumValues>(){

                        @Override
                        public int compare(EnumValues o1, EnumValues o2) {
                            return o1.value.compareTo(o2.value);
                        }
                    });
                }
                HtmlSimpleValueComponent holderComponent = EnumInputRenderer.this.createInputContainerComponent(enumerate);
                for (EnumValues pair : pairList) {
                    Enum oneEnum = pair.obj;
                    String description = pair.value;
                    if (excludedValues.contains(oneEnum)) continue;
                    EnumInputRenderer.this.addEnumElement(enumerate, holderComponent, oneEnum, description);
                }
                holderComponent.setConverter(new EnumConverter());
                holderComponent.setTargetSlot((MetaSlotKey)EnumInputRenderer.this.getInputContext().getMetaObject().getKey());
                return holderComponent;
            }

            private Object getRenderedObject() {
                PresentationContext parentContext;
                PresentationContext context = EnumInputRenderer.this.getContext();
                if (context != null && (parentContext = context.getParentContext()) != null) {
                    MetaObject metaObject = parentContext.getMetaObject();
                    return metaObject == null ? null : metaObject.getObject();
                }
                return null;
            }

            @Override
            public void applyStyle(HtmlComponent component) {
                super.applyStyle(component);
                HtmlSimpleValueComponent holderComponent = (HtmlSimpleValueComponent)component;
                holderComponent.setDisabled(EnumInputRenderer.this.getDisabled());
            }

            class EnumValues
            implements Serializable {
                private final Enum obj;
                private final String value;

                public EnumValues(Enum obj, String value) {
                    this.obj = obj;
                    this.value = value;
                }
            }
        };
    }

    protected void addEnumElement(Enum enumerate, HtmlSimpleValueComponent holder, Enum oneEnum, String description) {
        HtmlMenu menu = (HtmlMenu)holder;
        HtmlMenuOption option = menu.createOption(description);
        option.setValue(oneEnum.toString());
        if (enumerate != null && oneEnum.equals(enumerate)) {
            option.setSelected(true);
        }
    }

    protected HtmlSimpleValueComponent createInputContainerComponent(Enum enumerate) {
        HtmlMenu menu = new HtmlMenu();
        if (!this.isDefaultOptionHidden()) {
            String defaultOptionTitle = this.getDefaultTitle();
            menu.createDefaultOption(defaultOptionTitle).setSelected(enumerate == null);
        }
        if (this.getOnChange() != null && !this.getOnChange().trim().isEmpty()) {
            menu.setOnChange(this.getOnChange());
        }
        return menu;
    }

    private String getDefaultTitle() {
        if (this.getDefaultText() == null) {
            return RenderUtils.getResourceString("renderers.menu.default.title");
        }
        if (this.isKey()) {
            return RenderUtils.getResourceString(this.getDefaultTextBundle(), this.getDefaultText());
        }
        return this.getDefaultText();
    }

    private Collection<Object> getIncludedEnumValues(Class type, Object object) {
        String valuesString = this.getIncludedValues();
        if (valuesString == null || valuesString.length() == 0) {
            Object[] constants = type.getEnumConstants();
            if (constants == null) {
                constants = type.getDeclaringClass().getEnumConstants();
            }
            return Arrays.asList(constants);
        }
        String formatedValues = object == null ? valuesString : RenderUtils.getFormattedProperties(valuesString, object);
        return this.getEnumValues(type, formatedValues);
    }

    private Collection<Object> getExcludedEnumValues(Class type, Object object) {
        String valuesString = this.getExcludedValues();
        if (valuesString == null || valuesString.length() == 0) {
            return Collections.emptyList();
        }
        String formatedValues = object == null ? valuesString : RenderUtils.getFormattedProperties(valuesString, object);
        return this.getEnumValues(type, formatedValues);
    }

    private Collection<Object> getEnumValues(Class type, String valuesString) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (String part : valuesString.split(",")) {
            String trimmedValue = part.trim();
            if (trimmedValue.length() <= 0) continue;
            result.add(Enum.valueOf(type, trimmedValue));
        }
        return result;
    }

    public boolean isSort() {
        return this.sort;
    }

    public void setSort(boolean sort) {
        this.sort = sort;
    }

    public boolean getDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public String getDefaultTextBundle() {
        return this.defaultTextBundle;
    }

    public void setDefaultTextBundle(String defaultTextBundle) {
        this.defaultTextBundle = defaultTextBundle;
    }
}

