/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import pt.ist.fenixWebFramework.renderers.OutputRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlBlockContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlCheckBox;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlImage;
import pt.ist.fenixWebFramework.renderers.components.HtmlInlineContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlLabel;
import pt.ist.fenixWebFramework.renderers.components.HtmlLink;
import pt.ist.fenixWebFramework.renderers.components.HtmlScript;
import pt.ist.fenixWebFramework.renderers.components.HtmlTable;
import pt.ist.fenixWebFramework.renderers.components.HtmlTableCell;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;
import pt.ist.fenixWebFramework.renderers.layouts.TabularLayout;
import pt.ist.fenixWebFramework.renderers.model.MetaObject;
import pt.ist.fenixWebFramework.renderers.model.MetaObjectCollection;
import pt.ist.fenixWebFramework.renderers.model.MetaObjectFactory;
import pt.ist.fenixWebFramework.renderers.model.MetaSlot;
import pt.ist.fenixWebFramework.renderers.schemas.Schema;
import pt.ist.fenixWebFramework.renderers.utils.CollectionPager;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixWebFramework.renderers.utils.RendererPropertyUtils;

public class CollectionRenderer
extends OutputRenderer {
    private String caption;
    private String summary;
    private String rowClasses;
    private String columnClasses;
    private String headerClasses;
    private String prefixes;
    private String suffixes;
    private boolean checkable;
    private String checkboxName;
    private String checkboxValue;
    private boolean selectAllShown;
    private String selectAllLocation = "bottom";
    private String headerTooltips;
    private static final String LOCATION_BOTTOM = "bottom";
    private static final String LOCATION_TOP = "top";
    private static final String LOCATION_BOTH = "both";
    private Boolean displayHeaders = Boolean.TRUE;
    protected Map<String, TableLink> links;
    private final Map<String, ColumnCss> columnCss;
    protected List<TableLink> sortedLinks;
    private String sortBy;
    private boolean groupLinks;
    private String linkGroupSeparator;
    private boolean rowForLinks;
    private Boolean pagedLayout = Boolean.FALSE;
    private int pageSize;
    private int numberOfPages;
    private int actualPage = 0;
    private String pagingAction;
    private CollectionPager pager;
    private String pagerClasses;

    public CollectionRenderer() {
        this.links = new Hashtable<String, TableLink>();
        this.sortedLinks = new ArrayList<TableLink>();
        this.columnCss = new Hashtable<String, ColumnCss>();
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getColumnClasses() {
        return this.columnClasses;
    }

    public void setColumnClasses(String columnClasses) {
        this.columnClasses = columnClasses;
    }

    public String getHeaderClasses() {
        return this.headerClasses;
    }

    public void setHeaderClasses(String headerClasses) {
        this.headerClasses = headerClasses;
    }

    public String getRowClasses() {
        return this.rowClasses;
    }

    public boolean getDisplayHeaders() {
        return this.displayHeaders;
    }

    public void setDisplayHeaders(boolean displayHeaders) {
        this.displayHeaders = displayHeaders;
    }

    public void setRowClasses(String rowClasses) {
        this.rowClasses = rowClasses;
    }

    public String getSuffixes() {
        return this.suffixes;
    }

    public void setSuffixes(String suffixes) {
        this.suffixes = suffixes;
    }

    public String getPrefixes() {
        return this.prefixes;
    }

    public void setPrefixes(String prefixes) {
        this.prefixes = prefixes;
    }

    private String getStringPart(String string, int index) {
        if (string == null) {
            return null;
        }
        String[] stringParts = string.split(",");
        return stringParts[index % stringParts.length];
    }

    protected TableLink getTableLink(String name) {
        TableLink tableLink = this.links.get(name);
        if (tableLink == null) {
            tableLink = new TableLink(name);
            this.links.put(name, tableLink);
            this.sortedLinks.add(tableLink);
        }
        return tableLink;
    }

    protected TableLink getTableLink(int order) {
        Collections.sort(this.sortedLinks);
        return this.sortedLinks.get(order);
    }

    protected int getSortedLinksSize() {
        return this.sortedLinks.size();
    }

    public String getLink(String name) {
        return this.getTableLink(name).getLink();
    }

    public void setCounter(String name, String value) {
        this.getTableLink(name).setCounter(value);
    }

    public String getCounter(String name) {
        return this.getTableLink(name).getCounter();
    }

    public void setLink(String name, String value) {
        this.getTableLink(name).setLink(value);
    }

    public String getModule(String name) {
        return this.getTableLink(name).getModule();
    }

    public void setModule(String name, String value) {
        this.getTableLink(name).setModule(value);
    }

    public String getParam(String name) {
        return this.getTableLink(name).getParam();
    }

    public void setParam(String name, String value) {
        this.getTableLink(name).setParam(value);
    }

    public String getKey(String name) {
        return this.getTableLink(name).getKey();
    }

    public void setKey(String name, String value) {
        this.getTableLink(name).setKey(value);
    }

    public String getBundle(String name) {
        return this.getTableLink(name).getBundle();
    }

    public void setBundle(String name, String value) {
        this.getTableLink(name).setBundle(value);
    }

    public String getText(String name) {
        return this.getTableLink(name).getText();
    }

    public void setText(String name, String value) {
        this.getTableLink(name).setText(value);
    }

    public String getOrder(String name) {
        return this.getTableLink(name).getOrder();
    }

    public void setOrder(String name, String value) {
        this.getTableLink(name).setOrder(value);
    }

    public boolean isExcludedFromFirst(String name) {
        return this.getTableLink(name).isExcludeFromFirst();
    }

    public void setExcludedFromFirst(String name, String value) {
        this.getTableLink(name).setExcludeFromFirst(new Boolean(value));
    }

    public boolean isExcludedFromLast(String name) {
        return this.getTableLink(name).isExcludeFromLast();
    }

    public void setVisibleIf(String name, String value) {
        this.getTableLink(name).setVisibleIf(value);
    }

    public String getVisibleIf(String name) {
        return this.getTableLink(name).getVisibleIf();
    }

    public void setVisibleIfNot(String name, String value) {
        this.getTableLink(name).setVisibleIfNot(value);
    }

    public String getVisibleIfNot(String name) {
        return this.getTableLink(name).getVisibleIfNot();
    }

    public String getIcon(String name) {
        return this.getTableLink(name).getIcon();
    }

    public void setIcon(String name, String value) {
        this.getTableLink(name).setIcon(value);
    }

    public void setExcludedFromLast(String name, String value) {
        this.getTableLink(name).setExcludeFromLast(new Boolean(value));
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public boolean isGroupLinks() {
        return this.groupLinks;
    }

    public void setGroupLinks(boolean groupLinks) {
        this.groupLinks = groupLinks;
    }

    public String getLinkGroupSeparator() {
        return this.linkGroupSeparator;
    }

    public void setLinkGroupSeparator(String linkGroupSeparator) {
        this.linkGroupSeparator = linkGroupSeparator;
    }

    public boolean isRowForLinks() {
        return this.rowForLinks;
    }

    public void setRowForLinks(boolean rowForLinks) {
        this.rowForLinks = rowForLinks;
        this.setGroupLinks(true);
    }

    public boolean isCheckable() {
        return this.checkable;
    }

    public void setCheckable(boolean checkable) {
        this.checkable = checkable;
    }

    public String getCheckboxName() {
        return this.checkboxName;
    }

    public void setCheckboxName(String checkboxName) {
        this.checkboxName = checkboxName;
    }

    public String getCheckboxValue() {
        return this.checkboxValue;
    }

    public void setCheckboxValue(String checkboxValue) {
        this.checkboxValue = checkboxValue;
    }

    public boolean isSelectAllShown() {
        return this.selectAllShown;
    }

    public void setSelectAllShown(boolean selectAllShown) {
        this.selectAllShown = selectAllShown;
    }

    public String getSelectAllLocation() {
        return this.selectAllLocation;
    }

    public void setSelectAllLocation(String selectAllLocation) {
        this.selectAllLocation = selectAllLocation;
        if (this.selectAllLocation != null) {
            this.selectAllLocation = this.selectAllLocation.toLowerCase();
        }
    }

    public String getLinkFormat(String name) {
        return this.getTableLink(name).getLinkFormat();
    }

    public void setLinkFormat(String name, String value) {
        this.getTableLink(name).setLinkFormat(value);
    }

    public String getCustomLink(String name) {
        return this.getTableLink(name).getCustom();
    }

    public void setCustomLink(String name, String value) {
        this.getTableLink(name).setCustom(value);
    }

    public String getContextRelative(String name) {
        return Boolean.toString(this.getTableLink(name).isContextRelative());
    }

    public void setContextRelative(String name, String value) {
        this.getTableLink(name).setContextRelative(Boolean.parseBoolean(value));
    }

    public void setConfirmationTitleKey(String name, String value) {
        this.getTableLink(name).setConfirmationTitleKey(value);
    }

    public String getConfirmationTitleKey(String name) {
        return this.getTableLink(name).getConfirmationTitleKey();
    }

    public void setConfirmationKey(String name, String value) {
        this.getTableLink(name).setConfirmationKey(value);
    }

    public String getConfirmationKey(String name) {
        return this.getTableLink(name).getConfirmationKey();
    }

    public void setConfirmationBundle(String name, String value) {
        this.getTableLink(name).setConfirmationBundle(value);
    }

    public String getConfirmationBundle(String name) {
        return this.getTableLink(name).getConfirmationBundle();
    }

    public String getConfirmationArgs(String name) {
        return this.getTableLink(name).getConfirmationArgs();
    }

    public void setConfirmationArgs(String name, String value) {
        this.getTableLink(name).setConfirmationArgs(value);
    }

    public String getBlankTarget(String name) {
        return Boolean.toString(this.getTableLink(name).getBlankTarget());
    }

    public void setBlankTarget(String name, String value) {
        this.getTableLink(name).setBlankTarget(Boolean.parseBoolean(value));
    }

    public String getTarget(String name) {
        return this.getTableLink(name).getTarget();
    }

    public void setTarget(String name, String value) {
        this.getTableLink(name).setTarget(value);
    }

    protected int getNumberOfLinkColumns() {
        if (this.isRowForLinks()) {
            return 0;
        }
        if (this.isGroupLinks() && this.links.size() > 0) {
            return 1;
        }
        return this.links.size();
    }

    protected int getNumberOfLinks() {
        return this.links.size();
    }

    public ColumnCss getColumnCss(String name) {
        ColumnCss columnCss = this.columnCss.get(name);
        if (columnCss == null) {
            columnCss = new ColumnCss();
            this.columnCss.put(name, columnCss);
        }
        return columnCss;
    }

    public void setUseCssIf(String name, String property) {
        this.getColumnCss(name).setUseIf(property);
    }

    public String getUseCssIf(String name) {
        return this.getColumnCss(name).getUseIf();
    }

    public void setUseCssIfNot(String name, String property) {
        this.getColumnCss(name).setUseIfNot(property);
    }

    public String getUseCssIfNot(String name) {
        return this.getColumnCss(name).getUseIfNot();
    }

    public void setColumn(String name, int column) {
        this.getColumnCss(name).setColumnNumber(column);
    }

    public int getColumn(String name) {
        return this.getColumnCss(name).getColumnNumber();
    }

    public void setConditionalColumnClass(String name, String cssClasses) {
        this.getColumnCss(name).setStyleClass(cssClasses);
    }

    public String getConditionalColumnClass(String name) {
        return this.getColumnCss(name).getStyleClass();
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
        this.pagedLayout = true;
    }

    public String getPagingAction() {
        return this.pagingAction;
    }

    public void setPagingAction(String pagingAction) {
        this.pagingAction = pagingAction;
        this.pagedLayout = true;
    }

    public int getActualPage() {
        return this.actualPage;
    }

    public void setActualPage(int actualPage) {
        this.actualPage = actualPage;
    }

    public String getPagerClasses() {
        return this.pagerClasses;
    }

    public void setPagerClasses(String pagerClasses) {
        this.pagerClasses = pagerClasses;
    }

    public List<ColumnCss> getColumnCssFor(int columnIndex) {
        ArrayList<ColumnCss> csses = new ArrayList<ColumnCss>();
        for (ColumnCss columnCss : this.columnCss.values()) {
            if (columnCss.getColumnNumber() != columnIndex) continue;
            csses.add(columnCss);
        }
        return csses;
    }

    public boolean isConfirmationUsed() {
        for (TableLink link : this.links.values()) {
            if (link.getConfirmationKey() == null) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Layout getLayout(Object object, Class type) {
        Collection sortedCollection = RenderUtils.sortCollectionWithCriteria((Collection)object, this.getSortBy());
        Collection pagedSortedCollection = this.checkForPager(sortedCollection);
        if (pagedSortedCollection != null) {
            sortedCollection = pagedSortedCollection;
        }
        return new CollectionTabularLayout(sortedCollection);
    }

    protected <T> Collection<T> checkForPager(Collection<T> sortedCollection) {
        Collection result = null;
        if (this.pagedLayout.booleanValue()) {
            this.pager = new CollectionPager<T>(sortedCollection, this.pageSize);
            this.numberOfPages = this.pager.getNumberOfPages();
            int page = this.actualPage == 0 ? 1 : this.actualPage;
            result = this.pager.getPage(page);
        }
        return result;
    }

    public HtmlComponent generateLinksComponent(Object object) {
        HtmlBlockContainer container = new HtmlBlockContainer();
        if (this.actualPage == 1) {
            HtmlInlineContainer spanBack = new HtmlInlineContainer();
            HtmlText goBack = new HtmlText("<<");
            spanBack.addChild(goBack);
            container.addChild(spanBack);
            HtmlInlineContainer spanPrev = new HtmlInlineContainer();
            HtmlText goPrev = new HtmlText("<");
            spanPrev.addChild(goPrev);
            container.addChild(spanPrev);
        } else {
            HtmlLink linkBack = new HtmlLink();
            linkBack.setText("<<");
            linkBack.setUrl(this.getPagingAction() + "&amp;actualPage=1");
            container.addChild(linkBack);
            HtmlLink linkPrev = new HtmlLink();
            linkPrev.setText("<");
            linkPrev.setUrl(this.getPagingAction() + "&amp;actualPage=" + (this.getActualPage() - 1));
            container.addChild(linkPrev);
        }
        int start = 0;
        start = this.actualPage < 3 ? 1 : (this.actualPage > this.numberOfPages - 3 ? this.numberOfPages - 4 : this.actualPage - 2);
        int end = start + 4;
        if (end > this.numberOfPages) {
            end = this.numberOfPages;
        }
        for (int i = start; i <= end; ++i) {
            if (i == this.actualPage) {
                HtmlInlineContainer spanPage = new HtmlInlineContainer();
                HtmlText presentPage = new HtmlText(String.valueOf(i));
                spanPage.addChild(presentPage);
                container.addChild(spanPage);
                continue;
            }
            HtmlLink linkPages = new HtmlLink();
            linkPages.setText(String.valueOf(i));
            linkPages.setUrl(this.getPagingAction() + "&amp;actualPage=" + String.valueOf(i));
            container.addChild(linkPages);
        }
        if (this.actualPage == this.numberOfPages) {
            HtmlInlineContainer spanNext = new HtmlInlineContainer();
            HtmlText goNext = new HtmlText(">");
            spanNext.addChild(goNext);
            container.addChild(spanNext);
            HtmlInlineContainer spanForth = new HtmlInlineContainer();
            HtmlText goForth = new HtmlText(">>");
            spanForth.addChild(goForth);
            container.addChild(spanForth);
        } else {
            HtmlLink linkNext = new HtmlLink();
            linkNext.setText(">");
            linkNext.setUrl(this.getPagingAction() + "&amp;actualPage=" + (this.getActualPage() + 1));
            container.addChild(linkNext);
            HtmlLink linkForth = new HtmlLink();
            linkForth.setText(">>");
            linkForth.setUrl(this.getPagingAction() + "&amp;actualPage=" + this.numberOfPages);
            container.addChild(linkForth);
        }
        container.setClasses(this.getPagerClasses());
        return container;
    }

    public static class TableLink
    implements Comparable<TableLink> {
        private String name;
        private String link;
        private String module;
        private String param;
        private String text;
        private String key;
        private String bundle;
        private String order;
        private boolean excludeFromFirst;
        private boolean excludeFromLast;
        private String linkFormat;
        private Boolean contextRelative;
        private final Boolean hasContext = false;
        private String custom;
        private String visibleIf;
        private String visibleIfNot;
        private String confirmationKey;
        private String confirmationBundle;
        private String confirmationArgs;
        private String confirmationTitleKey;
        private String icon;
        private String counter;
        private Boolean blankTarget = false;
        private String target;

        public String getConfirmationTitleKey() {
            return this.confirmationTitleKey;
        }

        public void setConfirmationTitleKey(String confirmationTitle) {
            this.confirmationTitleKey = confirmationTitle;
        }

        public TableLink() {
            this.excludeFromFirst = false;
            this.excludeFromLast = false;
        }

        public TableLink(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getBundle() {
            return this.bundle;
        }

        public void setBundle(String bundle) {
            this.bundle = bundle;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getLink() {
            return this.link;
        }

        public void setLink(String link) {
            this.link = link;
        }

        public String getModule() {
            return this.module;
        }

        public void setModule(String module) {
            this.module = module;
        }

        public String getParam() {
            return this.param;
        }

        public void setParam(String param) {
            this.param = param;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public String getOrder() {
            return this.order;
        }

        public void setOrder(String order) {
            this.order = order;
        }

        public boolean isExcludeFromFirst() {
            return this.excludeFromFirst;
        }

        public void setExcludeFromFirst(boolean excludeFromFirst) {
            this.excludeFromFirst = excludeFromFirst;
        }

        public boolean isExcludeFromLast() {
            return this.excludeFromLast;
        }

        public void setExcludeFromLast(boolean excludeFromLast) {
            this.excludeFromLast = excludeFromLast;
        }

        public String getLinkFormat() {
            return this.linkFormat;
        }

        public void setLinkFormat(String linkFormat) {
            this.linkFormat = linkFormat;
        }

        public String getVisibleIf() {
            return this.visibleIf;
        }

        public void setVisibleIf(String visibleIf) {
            this.visibleIf = visibleIf;
        }

        public String getVisibleIfNot() {
            return this.visibleIfNot;
        }

        public void setVisibleIfNot(String visibleIfNot) {
            this.visibleIfNot = visibleIfNot;
        }

        public Boolean isContextRelative() {
            return this.contextRelative;
        }

        public void setContextRelative(Boolean contextRelative) {
            this.contextRelative = contextRelative;
        }

        public boolean isContextRelativeSet() {
            return this.contextRelative != null;
        }

        public String getCustom() {
            return this.custom;
        }

        public void setCustom(String custom) {
            this.custom = custom;
        }

        public String getConfirmationKey() {
            return this.confirmationKey;
        }

        public void setConfirmationKey(String confirmationKey) {
            this.confirmationKey = confirmationKey;
        }

        public String getConfirmationBundle() {
            return this.confirmationBundle;
        }

        public void setConfirmationBundle(String confirmationBundle) {
            this.confirmationBundle = confirmationBundle;
        }

        public String getConfirmationArgs() {
            return this.confirmationArgs;
        }

        public void setConfirmationArgs(String confirmationArgs) {
            this.confirmationArgs = confirmationArgs;
        }

        public Boolean getBlankTarget() {
            return this.blankTarget;
        }

        public void setBlankTarget(Boolean blankTarget) {
            this.blankTarget = blankTarget;
        }

        public String getTarget() {
            return this.target;
        }

        public void setTarget(String target) {
            this.target = target;
        }

        public String getIcon() {
            return this.icon;
        }

        public void setIcon(String value) {
            this.icon = value;
        }

        @Override
        public int compareTo(TableLink other) {
            if (this.getOrder() == null) {
                return 0;
            }
            if (other.getOrder() == null) {
                return 0;
            }
            return this.getOrder().compareTo(other.getOrder());
        }

        public HtmlComponent generateLink(Object object) {
            if (this.getVisibleIf() != null) {
                try {
                    Boolean visible = (Boolean)RendererPropertyUtils.getProperty(object, this.getVisibleIf(), false);
                    if (visible != null && !visible.booleanValue()) {
                        return null;
                    }
                }
                catch (ClassCastException e) {
                    e.printStackTrace();
                }
            }
            if (this.getVisibleIfNot() != null) {
                try {
                    Boolean notVisible = (Boolean)RendererPropertyUtils.getProperty(object, this.getVisibleIfNot(), false);
                    if (notVisible != null && notVisible.booleanValue()) {
                        return null;
                    }
                }
                catch (ClassCastException e) {
                    e.printStackTrace();
                }
            }
            if (this.getCustom() != null) {
                return new HtmlText(RenderUtils.getFormattedProperties(this.getCustom(), object), false);
            }
            HtmlLink link = new HtmlLink();
            if (this.isContextRelativeSet()) {
                link.setContextRelative(this.isContextRelative());
            }
            if (this.getBlankTarget().booleanValue()) {
                link.setTarget("_blank");
            } else if (this.getTarget() != null && !this.getTarget().isEmpty()) {
                link.setTarget(this.getTarget());
            }
            if (this.getIcon() != null && !this.getIcon().equals("none")) {
                HtmlLink forImage = new HtmlLink();
                forImage.setModuleRelative(false);
                forImage.setContextRelative(true);
                forImage.setUrl("/images/" + this.getIcon() + ".gif");
                HtmlImage image = new HtmlImage();
                image.setSource(forImage.calculateUrl());
                image.setDescription(this.getLinkText(this, object));
                link.setBody(image);
            } else {
                link.setText(this.getLinkText(this, object));
            }
            link.setModule(this.getModule());
            if (this.getLinkFormat() != null) {
                link.setUrl(RenderUtils.getFormattedProperties(this.getLinkFormat(), object));
            } else {
                link.setUrl(this.getLink());
                this.setLinkParameters(object, link, this);
            }
            if (this.getConfirmationKey() != null) {
                String arguments = this.getConfirmationArgs() != null ? this.getConfirmationArgs() : "";
                String[] argumentsArray = arguments.split(",");
                Object[] formattedArgsArray = new String[argumentsArray.length];
                for (int i = 0; i < argumentsArray.length; ++i) {
                    formattedArgsArray[i] = RenderUtils.getFormattedProperties(argumentsArray[i], object);
                }
                if (link.getId() == null) {
                    link.setId(this.getName() + "-" + object.hashCode());
                }
                String confirmationMessage = this.getConfirmationBundle() != null ? RenderUtils.getResourceString(this.getConfirmationBundle(), this.getConfirmationKey(), formattedArgsArray) : RenderUtils.getResourceString(this.getConfirmationKey());
                String confirmationTitle = this.getConfirmationBundle() != null ? RenderUtils.getResourceString(this.getConfirmationBundle(), this.getConfirmationTitleKey()) : RenderUtils.getResourceString(this.getConfirmationTitleKey());
                HtmlInlineContainer container = new HtmlInlineContainer();
                container.addChild(link);
                String scriptText = "linkConfirmationHook('" + link.getId() + "','" + (confirmationMessage != null ? confirmationMessage : "") + "', '" + (confirmationTitle != null ? confirmationTitle : "") + "');";
                HtmlScript script = new HtmlScript();
                script.setContentType("text/javascript");
                script.setScript(scriptText);
                container.addChild(script);
                return container;
            }
            return link;
        }

        public String getLinkText(TableLink tableLink, Object object) {
            String text = tableLink.getText();
            if (text != null) {
                return text;
            }
            String key = tableLink.getKey();
            String bundle = tableLink.getBundle();
            if (key == null) {
                return tableLink.getName();
            }
            text = RenderUtils.getResourceString(bundle, key);
            if (text == null) {
                text = tableLink.getName();
            }
            return this.getCounter() != null ? text + RenderUtils.getFormattedProperties(this.getCounter(), object) : text;
        }

        protected void setLinkParameters(Object object, HtmlLink link, TableLink tableLink) {
            String[] parameters;
            String linkParam = tableLink.getParam();
            if (linkParam == null) {
                return;
            }
            for (String name : parameters = tableLink.getParam().split(",")) {
                String customValue;
                String realName;
                String slotName;
                String[] parameterParts = name.split("=", -1);
                if (parameterParts.length >= 1) {
                    String[] nameParts = parameterParts[0].split("/");
                    slotName = nameParts[0];
                    realName = nameParts.length == 2 ? nameParts[1] : slotName;
                    customValue = parameterParts.length > 1 ? parameterParts[1] : null;
                } else {
                    slotName = parameterParts[0];
                    realName = parameterParts[0];
                    customValue = null;
                }
                try {
                    String value;
                    String string = value = customValue != null ? customValue : String.valueOf(PropertyUtils.getProperty((Object)object, (String)slotName));
                    if (value == null) continue;
                    link.setParameter(realName, value);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public void setCounter(String counter) {
            this.counter = counter;
        }

        public String getCounter() {
            return this.counter;
        }
    }

    public static class ColumnCss {
        private int columnNumber;
        private String useIf;
        private String useIfNot;
        private String styleClass;

        public int getColumnNumber() {
            return this.columnNumber;
        }

        public void setColumnNumber(int columnNumber) {
            this.columnNumber = columnNumber;
        }

        public String getUseIf() {
            return this.useIf;
        }

        public void setUseIf(String useIf) {
            this.useIf = useIf;
        }

        public String getStyleClass() {
            return this.styleClass;
        }

        public void setStyleClass(String styleClass) {
            this.styleClass = styleClass;
        }

        public String getUseIfNot() {
            return this.useIfNot;
        }

        public void setUseIfNot(String useIfNot) {
            this.useIfNot = useIfNot;
        }
    }

    public class CollectionTabularLayout
    extends TabularLayout {
        List<MetaObject> metaObjects;

        @Override
        public HtmlComponent createComponent(Object object, Class type) {
            if (CollectionRenderer.this.pagedLayout.booleanValue()) {
                HtmlBlockContainer htmlBlockContainer = new HtmlBlockContainer();
                HtmlComponent linksComponent = CollectionRenderer.this.generateLinksComponent(object);
                htmlBlockContainer.addChild(linksComponent);
                htmlBlockContainer.addChild(super.createComponent(object, type));
                htmlBlockContainer.addChild(linksComponent);
                return htmlBlockContainer;
            }
            return super.createComponent(object, type);
        }

        @Override
        public void applyStyle(HtmlComponent component) {
            if (CollectionRenderer.this.pagedLayout.booleanValue()) {
                component.getChild(new Predicate<HtmlComponent>(){

                    public boolean apply(HtmlComponent component) {
                        return component instanceof HtmlTable;
                    }
                }).setClasses(this.getClasses());
            } else {
                component.setClasses(this.getClasses());
            }
            component.setStyle(this.getStyle());
            component.setTitle(this.getTitle());
            super.applyStyle(component);
        }

        public CollectionTabularLayout(Collection object) {
            this.metaObjects = this.getMetaObjects(object);
        }

        private List<MetaObject> getMetaObjects(Collection collection) {
            ArrayList<MetaObject> metaObjects = new ArrayList<MetaObject>();
            MetaObject contextMetaObject = CollectionRenderer.this.getContext().getMetaObject();
            if (contextMetaObject instanceof MetaObjectCollection) {
                MetaObjectCollection multipleMetaObject = (MetaObjectCollection)CollectionRenderer.this.getContext().getMetaObject();
                block0: for (Object object : collection) {
                    for (MetaObject metaObject : multipleMetaObject.getAllMetaObjects()) {
                        if (!object.equals(metaObject.getObject())) continue;
                        metaObjects.add(metaObject);
                        continue block0;
                    }
                }
            } else {
                Schema schema = CollectionRenderer.this.getContext().getSchema();
                for (Object object : collection) {
                    metaObjects.add(MetaObjectFactory.createObject(object, schema));
                }
            }
            return metaObjects;
        }

        @Override
        public HtmlComponent createLayout(Object object, Class type) {
            HtmlBlockContainer container;
            HtmlComponent component = super.createLayout(object, type);
            if (CollectionRenderer.this.isConfirmationUsed()) {
                container = new HtmlBlockContainer();
                this.addScripts(container);
                container.addChild(component);
                component = container;
            }
            if (CollectionRenderer.this.isCheckable() && CollectionRenderer.this.isSelectAllShown()) {
                container = new HtmlBlockContainer();
                HtmlComponent selectAllComponent = this.createInvertSelectionLink();
                if (String.valueOf(CollectionRenderer.this.getSelectAllLocation()).contains(CollectionRenderer.LOCATION_TOP) || String.valueOf(CollectionRenderer.this.getSelectAllLocation()).contains(CollectionRenderer.LOCATION_BOTH)) {
                    container.addChild(selectAllComponent);
                }
                container.addChild(component);
                if (String.valueOf(CollectionRenderer.this.getSelectAllLocation()).contains(CollectionRenderer.LOCATION_BOTTOM) || String.valueOf(CollectionRenderer.this.getSelectAllLocation()).contains(CollectionRenderer.LOCATION_BOTH)) {
                    container.addChild(selectAllComponent);
                }
                return container;
            }
            return component;
        }

        protected void addScripts(HtmlContainer container) {
            String[] scriptNames;
            HtmlLink link = new HtmlLink();
            link.setModuleRelative(false);
            link.setContextRelative(true);
            for (String script : scriptNames = new String[]{"jquery.ui.draggable.js", "jquery.alerts.js", "alertHandlers.js"}) {
                this.addSingleScript(container, link, script);
            }
        }

        private void addSingleScript(HtmlContainer container, HtmlLink link, String scriptName) {
            link.setUrl("/bennu-renderers/js/" + scriptName);
            HtmlScript script = new HtmlScript("text/javascript", link.calculateUrl(), true);
            container.addChild(script);
        }

        private HtmlComponent createInvertSelectionLink() {
            HtmlInlineContainer container = new HtmlInlineContainer();
            HtmlScript script = new HtmlScript();
            script.setContentType("text/javascript");
            script.setConditional(true);
            script.setScript("function invertSelectionAll(n) {    var allChecked = true;    var elements = document.getElementsByName(n);\n    for (var index=0; index<elements.length; index++) {        var element = elements[index];\n        if (! element.checked) {            allChecked = false;            element.checked = true;        }    }\n    if (allChecked) {        for (var index=0; index<elements.length; index++) {            elements[index].checked = false;        }    }}");
            container.addChild(script);
            String selectAllScript = "invertSelectionAll('" + CollectionRenderer.this.getCheckboxName() + "')";
            HtmlLink link = new HtmlLink();
            link.setContextRelative(false);
            link.setText(RenderUtils.getResourceString("renderers.table.selectAll"));
            link.setOnClick(selectAllScript);
            link.setOnDblClick(selectAllScript);
            container.addChild(link);
            return container;
        }

        @Override
        protected boolean hasHeader() {
            return CollectionRenderer.this.displayHeaders.booleanValue() ? this.metaObjects.size() > 0 : false;
        }

        @Override
        protected int getNumberOfColumns() {
            if (this.metaObjects.size() > 0) {
                MetaObject metaObject = this.metaObjects.get(0);
                return metaObject.getSlots().size() + CollectionRenderer.this.getNumberOfLinkColumns() + (CollectionRenderer.this.isCheckable() ? 1 : 0);
            }
            return 0;
        }

        @Override
        protected int getNumberOfRows() {
            if (CollectionRenderer.this.isRowForLinks()) {
                return this.metaObjects.size() * 2;
            }
            return this.metaObjects.size();
        }

        protected MetaObject getObject(int index) {
            return this.metaObjects.get(index);
        }

        @Override
        protected HtmlComponent getHeaderComponent(int columnIndex) {
            if (columnIndex == 0 && CollectionRenderer.this.isCheckable()) {
                return new HtmlText();
            }
            if (columnIndex < this.getNumberOfColumns() - CollectionRenderer.this.getNumberOfLinkColumns()) {
                HtmlLabel label = new HtmlLabel();
                MetaSlot metaSlot = this.getObject(0).getSlots().get(columnIndex - (CollectionRenderer.this.isCheckable() ? 1 : 0));
                label.setFor(metaSlot.getKey().toString());
                if (Strings.isNullOrEmpty((String)this.getHeaderToolTip(columnIndex))) {
                    label.setTitle(metaSlot.getTitle());
                }
                HtmlText text = new HtmlText();
                text.setEscaped(false);
                if (!metaSlot.isReadOnly()) {
                    text.setText(this.getLabel(columnIndex) + (metaSlot.isRequired() ? " (*)" : ""));
                } else {
                    text.setText(this.getLabel(columnIndex));
                }
                label.setBody(text);
                return label;
            }
            return new HtmlText();
        }

        private String getHeaderToolTip(int columnIndex) {
            String headerToolTip;
            MetaSlot metaSlot = this.metaObjects.get(0).getSlots().get(columnIndex - (CollectionRenderer.this.isCheckable() ? 1 : 0));
            String string = headerToolTip = metaSlot.getProperties() == null ? "" : metaSlot.getProperties().getProperty("headerToolTip");
            if (!Strings.isNullOrEmpty((String)headerToolTip)) {
                return " <a href=\"#\" class=\"help\">[?]<span>" + RenderUtils.getResourceString(metaSlot.getBundle(), headerToolTip) + "</span></a>";
            }
            return "";
        }

        protected String getLabel(int columnIndex) {
            int realIndex = columnIndex - (CollectionRenderer.this.isCheckable() ? 1 : 0);
            if (realIndex >= 0) {
                return this.getObject(0).getSlots().get(realIndex).getLabel() + this.getHeaderToolTip(columnIndex);
            }
            return "";
        }

        @Override
        protected void costumizeCell(HtmlTableCell cell, int rowIndex, int columnIndex) {
            super.costumizeCell(cell, rowIndex, columnIndex);
            if (CollectionRenderer.this.isRowForLinks() && rowIndex % 2 == 1) {
                cell.setColspan(this.getNumberOfColumns());
            }
        }

        @Override
        protected HtmlComponent getComponent(int rowIndex, int columnIndex) {
            int objectRow = CollectionRenderer.this.isRowForLinks() ? rowIndex / 2 : rowIndex;
            MetaObject object = this.getObject(objectRow);
            CollectionRenderer.this.getContext().setMetaObject(object);
            if (CollectionRenderer.this.isRowForLinks() && rowIndex % 2 == 1) {
                return this.generateLinkComponent(object, rowIndex, columnIndex);
            }
            if (columnIndex == 0 && CollectionRenderer.this.isCheckable()) {
                HtmlCheckBox checkBox = new HtmlCheckBox();
                checkBox.setName(CollectionRenderer.this.getCheckboxName());
                if (CollectionRenderer.this.getCheckboxValue() != null) {
                    Object realObject = object.getObject();
                    try {
                        String checkBoxValue = String.valueOf(PropertyUtils.getProperty((Object)realObject, (String)CollectionRenderer.this.getCheckboxValue()));
                        boolean checked = false;
                        String[] existingValues = CollectionRenderer.this.getContext().getViewState().getRequest().getParameterValues(CollectionRenderer.this.getCheckboxName());
                        if (existingValues != null) {
                            for (String value : existingValues) {
                                if (!value.equals(checkBoxValue)) continue;
                                checked = true;
                                break;
                            }
                        }
                        checkBox.setChecked(checked);
                        checkBox.setUserValue(checkBoxValue);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("could not set check box value by reading property '" + CollectionRenderer.this.getCheckboxValue() + "' from object " + realObject, e);
                    }
                }
                return checkBox;
            }
            if (columnIndex < this.getNumberOfColumns() - CollectionRenderer.this.getNumberOfLinkColumns()) {
                return this.generateObjectComponent(columnIndex - (CollectionRenderer.this.isCheckable() ? 1 : 0), object);
            }
            return this.generateLinkComponent(object, rowIndex, columnIndex - (this.getNumberOfColumns() - CollectionRenderer.this.getNumberOfLinkColumns()));
        }

        @Override
        protected String getCellClasses(int rowIndex, int columnIndex) {
            int objectRow = CollectionRenderer.this.isRowForLinks() ? rowIndex / 2 : rowIndex;
            MetaObject object = this.getObject(objectRow);
            if (CollectionRenderer.this.isRowForLinks() && rowIndex % 2 == 1) {
                return null;
            }
            if (columnIndex == 0 && CollectionRenderer.this.isCheckable()) {
                return null;
            }
            if (columnIndex < this.getNumberOfColumns() - CollectionRenderer.this.getNumberOfLinkColumns()) {
                String styleClass = null;
                for (ColumnCss columnCss : CollectionRenderer.this.getColumnCssFor(columnIndex)) {
                    if (!this.canApplyConditionalClasses(object, columnCss)) continue;
                    styleClass = (styleClass != null ? styleClass + " " : "") + columnCss.getStyleClass();
                }
                return styleClass;
            }
            return null;
        }

        protected HtmlComponent generateObjectComponent(int columnIndex, MetaObject object) {
            MetaSlot slot = this.getSlotUsingName(object, columnIndex);
            if (slot == null) {
                return new HtmlText();
            }
            HtmlComponent component = CollectionRenderer.this.renderSlot(slot);
            component = this.wrapPrefixAndSuffix(component, columnIndex);
            return component;
        }

        private boolean canApplyConditionalClasses(MetaObject metaObject, ColumnCss columnCss) {
            Boolean useIf = columnCss.getUseIf() != null && (Boolean)RendererPropertyUtils.getProperty(metaObject.getObject(), columnCss.getUseIf(), false) != false;
            Boolean useIfNot = columnCss.getUseIfNot() != null && (Boolean)RendererPropertyUtils.getProperty(metaObject.getObject(), columnCss.getUseIfNot(), false) != false;
            return useIf != false || useIfNot == false;
        }

        protected MetaSlot getSlotUsingName(MetaObject object, int columnIndex) {
            MetaObject referenceObject = this.getObject(0);
            MetaSlot referenceSlot = referenceObject.getSlots().get(columnIndex);
            MetaSlot directSlot = object.getSlots().get(columnIndex);
            if (directSlot.getName().equals(referenceSlot.getName())) {
                return directSlot;
            }
            for (MetaSlot slot : object.getSlots()) {
                if (!slot.getName().equals(referenceSlot.getName())) continue;
                return slot;
            }
            return null;
        }

        protected HtmlComponent generateLinkComponent(MetaObject object, int rowIndex, int number) {
            if (CollectionRenderer.this.isGroupLinks() || CollectionRenderer.this.isRowForLinks()) {
                HtmlInlineContainer container = new HtmlInlineContainer();
                container.setIndented(false);
                boolean includeSeparator = false;
                for (int i = 0; i < CollectionRenderer.this.getNumberOfLinks(); ++i) {
                    HtmlComponent component = this.generateSingleLinkComponent(object, rowIndex, i);
                    if (component == null) continue;
                    if (includeSeparator) {
                        container.addChild(new HtmlText(CollectionRenderer.this.getLinkGroupSeparator(), false));
                    }
                    container.addChild(component);
                    includeSeparator = true;
                }
                return container;
            }
            HtmlComponent component = this.generateSingleLinkComponent(object, rowIndex, number);
            return component == null ? new HtmlText() : component;
        }

        protected HtmlComponent generateSingleLinkComponent(MetaObject object, int rowIndex, int number) {
            TableLink tableLink = CollectionRenderer.this.getTableLink(number);
            if (rowIndex == 0 && tableLink.isExcludeFromFirst()) {
                return null;
            }
            if (rowIndex == this.getNumberOfRows() - 1 && tableLink.isExcludeFromLast()) {
                return null;
            }
            return tableLink.generateLink(object.getObject());
        }

        protected HtmlComponent wrapPrefixAndSuffix(HtmlComponent component, int columnIndex) {
            String suffix;
            HtmlInlineContainer container = null;
            String prefix = CollectionRenderer.this.getStringPart(CollectionRenderer.this.getPrefixes(), columnIndex);
            if (prefix != null) {
                container = new HtmlInlineContainer();
                container.addChild(new HtmlText(prefix));
                container.addChild(component);
            }
            if ((suffix = CollectionRenderer.this.getStringPart(CollectionRenderer.this.getSuffixes(), columnIndex)) != null) {
                if (container != null) {
                    container.addChild(new HtmlText(suffix));
                } else {
                    container = new HtmlInlineContainer();
                    container.addChild(component);
                    container.addChild(new HtmlText(suffix));
                }
            }
            return container != null ? container : component;
        }
    }
}

