/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.portal.servlet;

import com.mitchellbosecke.pebble.error.ParserException;
import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.extension.NodeVisitor;
import com.mitchellbosecke.pebble.lexer.Token;
import com.mitchellbosecke.pebble.lexer.TokenStream;
import com.mitchellbosecke.pebble.node.AbstractRenderableNode;
import com.mitchellbosecke.pebble.node.BodyNode;
import com.mitchellbosecke.pebble.node.Node;
import com.mitchellbosecke.pebble.node.RenderableNode;
import com.mitchellbosecke.pebble.node.expression.Expression;
import com.mitchellbosecke.pebble.parser.Parser;
import com.mitchellbosecke.pebble.template.EvaluationContext;
import com.mitchellbosecke.pebble.template.PebbleTemplateImpl;
import com.mitchellbosecke.pebble.template.ScopeChain;
import com.mitchellbosecke.pebble.tokenParser.AbstractTokenParser;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Stream;

public class LazyForTokenParser
extends AbstractTokenParser {
    public RenderableNode parse(Token token, Parser parser) throws ParserException {
        TokenStream stream = parser.getStream();
        int lineNumber = token.getLineNumber();
        stream.next();
        String iterationVariable = parser.getExpressionParser().parseNewVariableName();
        stream.expect(Token.Type.NAME, "in");
        Expression iterable = parser.getExpressionParser().parseExpression();
        stream.expect(Token.Type.EXECUTE_END);
        BodyNode body = parser.subparse(test -> test.test(Token.Type.NAME, new String[]{"endLazyFor"}));
        stream.next();
        stream.expect(Token.Type.EXECUTE_END);
        return new ForNode(lineNumber, iterationVariable, iterable, body);
    }

    public String getTag() {
        return "lazyFor";
    }

    private static final class ForNode
    extends AbstractRenderableNode {
        private final String variableName;
        private final Expression<?> iterableExpression;
        private final BodyNode body;

        public ForNode(int lineNumber, String variableName, Expression<?> iterableExpression, BodyNode body) {
            super(lineNumber);
            this.variableName = variableName;
            this.iterableExpression = iterableExpression;
            this.body = body;
        }

        public void render(PebbleTemplateImpl self, Writer writer, EvaluationContext context) throws PebbleException, IOException {
            Object value = this.iterableExpression.evaluate(self, context);
            if (value == null) {
                return;
            }
            Stream<?> stream = this.getStream(value);
            ScopeChain scopeChain = context.getScopeChain();
            scopeChain.pushScope();
            stream.forEach(obj -> {
                try {
                    scopeChain.put(this.variableName, obj);
                    this.body.render(self, writer, context);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            scopeChain.popScope();
        }

        private Stream<?> getStream(Object obj) {
            if (obj instanceof Stream) {
                return (Stream)obj;
            }
            if (obj instanceof Collection) {
                return ((Collection)obj).stream();
            }
            if (obj.getClass().isArray()) {
                return Arrays.stream((Object[])obj);
            }
            throw new ClassCastException(obj + " cannot be cast to Stream");
        }

        public void accept(NodeVisitor visitor) {
            visitor.visit((Node)this);
        }
    }
}

