/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.portal.servlet;

import com.mitchellbosecke.pebble.PebbleEngine;
import com.mitchellbosecke.pebble.error.LoaderException;
import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.extension.Extension;
import com.mitchellbosecke.pebble.loader.ClasspathLoader;
import com.mitchellbosecke.pebble.loader.Loader;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import com.qubit.terra.framework.services.ServiceProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.fenixedu.bennu.alerts.Alert;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.core.util.CoreConfiguration;
import org.fenixedu.bennu.portal.BennuPortalConfiguration;
import org.fenixedu.bennu.portal.domain.MenuFunctionality;
import org.fenixedu.bennu.portal.domain.PortalConfiguration;
import org.fenixedu.bennu.portal.service.PebblePortalExtensionProvider;
import org.fenixedu.bennu.portal.servlet.BennuPortalDispatcher;
import org.fenixedu.bennu.portal.servlet.PortalBackend;
import org.fenixedu.bennu.portal.servlet.PortalBackendRegistry;
import org.fenixedu.bennu.portal.servlet.PortalExtension;
import org.fenixedu.bennu.portal.servlet.PortalResponseWrapper;
import org.fenixedu.commons.i18n.I18N;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebFilter(value={"/*"}, asyncSupported=true)
public class PortalLayoutInjector
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(PortalLayoutInjector.class);
    private static final String SKIP_LAYOUT_INJECTION = "$$SKIP_LAYOUT_INJECTION$$";
    private static ThreadLocal<Map<String, Object>> contextExtensions = new ThreadLocal();
    private PebbleEngine engine;

    public void init(FilterConfig filterConfig) throws ServletException {
        final ServletContext servletContext = filterConfig.getServletContext();
        List<PortalExtension> extensions = List.of(new PortalExtension(servletContext));
        if (ServiceProvider.isServiceAvailable(PebblePortalExtensionProvider.class)) {
            extensions = ((PebblePortalExtensionProvider)ServiceProvider.getService(PebblePortalExtensionProvider.class)).provide(servletContext);
        }
        this.engine = new PebbleEngine.Builder().extension(extensions.toArray(new Extension[0])).loader((Loader)new ClasspathLoader(){

            public Reader getReader(String templateName) throws LoaderException {
                InputStream stream = servletContext.getResourceAsStream("/themes/" + templateName + ".html");
                if (stream != null) {
                    return new InputStreamReader(stream, StandardCharsets.UTF_8);
                }
                logger.warn("Could not find template named {}, falling back to default!", (Object)templateName);
                return new InputStreamReader(servletContext.getResourceAsStream("/themes/" + PortalConfiguration.getInstance().getTheme() + "/default.html"), StandardCharsets.UTF_8);
            }
        }).cacheActive(BennuPortalConfiguration.getConfiguration().themeDevelopmentMode() == false).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        block9: {
            try {
                HttpServletRequest request = (HttpServletRequest)req;
                HttpServletResponse response = (HttpServletResponse)resp;
                PortalResponseWrapper wrapper = new PortalResponseWrapper(response);
                chain.doFilter((ServletRequest)request, (ServletResponse)wrapper);
                Alert.flush(request, response);
                MenuFunctionality functionality = BennuPortalDispatcher.getSelectedFunctionality(request);
                if (functionality != null && wrapper.hasData() && request.getAttribute(SKIP_LAYOUT_INJECTION) == null) {
                    PortalBackend backend = PortalBackendRegistry.getPortalBackend(functionality.getProvider());
                    if (backend.requiresServerSideLayout()) {
                        String body = wrapper.getContent();
                        try {
                            PortalConfiguration config = PortalConfiguration.getInstance();
                            HashMap<String, Object> ctx = new HashMap<String, Object>();
                            List path = functionality.getPathFromRoot();
                            ctx.put("loggedUser", Authenticate.getUser());
                            ctx.put("body", body);
                            ctx.put("functionality", (Object)functionality);
                            ctx.put("config", (Object)config);
                            ctx.put("topLevelMenu", config.getMenu().getUserMenuStream());
                            ctx.put("contextPath", request.getContextPath());
                            ctx.put("session", resp.isCommitted() ? request.getSession(false) : request.getSession());
                            ctx.put("themePath", request.getContextPath() + "/themes/" + config.getTheme());
                            ctx.put("devMode", CoreConfiguration.getConfiguration().developmentMode());
                            ctx.put("pathFromRoot", path);
                            ctx.put("selectedTopLevel", path.get(0));
                            ctx.put("locales", CoreConfiguration.supportedLocales());
                            ctx.put("currentLocale", I18N.getLocale());
                            ctx.put("alerts", Alert.getAlertsAsJson(request, response));
                            Map<String, Object> requestContext = contextExtensions.get();
                            if (requestContext != null) {
                                ctx.putAll(requestContext);
                            }
                            PebbleTemplate template = this.engine.getTemplate(config.getTheme() + "/" + functionality.resolveLayout());
                            template.evaluate((Writer)response.getWriter(), ctx, I18N.getLocale());
                            break block9;
                        }
                        catch (PebbleException e) {
                            throw new ServletException("Could not render template!", (Throwable)e);
                        }
                    }
                    wrapper.flushBuffer();
                    break block9;
                }
                wrapper.flushBuffer();
            }
            finally {
                Map<String, Object> requestContext = contextExtensions.get();
                if (requestContext != null) {
                    requestContext.clear();
                }
            }
        }
    }

    public static void skipLayoutOn(HttpServletRequest request) {
        request.setAttribute(SKIP_LAYOUT_INJECTION, (Object)SKIP_LAYOUT_INJECTION);
    }

    public static void addContextExtension(Map<String, Object> requestContext) {
        Map<String, Object> map = contextExtensions.get();
        if (map == null) {
            map = new HashMap<String, Object>();
            contextExtensions.set(map);
        }
        map.putAll(requestContext);
    }

    public void destroy() {
    }
}

