/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.portal.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.DispatcherType;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.fenixedu.bennu.portal.domain.MenuContainer;
import org.fenixedu.bennu.portal.servlet.BennuPortalDispatcher;
import org.fenixedu.bennu.portal.servlet.ForwarderPortalBackend;
import org.fenixedu.bennu.portal.servlet.PortalBackendRegistry;
import org.fenixedu.bennu.portal.servlet.PortalBean;
import org.fenixedu.bennu.portal.servlet.RedirectPortalBackend;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebListener
public class PortalInitializer
implements ServletContextListener {
    private static final Logger logger = LoggerFactory.getLogger(PortalInitializer.class);
    private static final Set<String> themes = new HashSet<String>();

    public void contextInitialized(ServletContextEvent sce) {
        Set themePaths = sce.getServletContext().getResourcePaths("/themes/");
        if (themePaths != null) {
            for (String themePath : themePaths) {
                try (InputStream stream = sce.getServletContext().getResourceAsStream(themePath + "/default.html");){
                    if (stream == null) continue;
                    themes.add(themePath.substring("/themes/".length(), themePath.length() - 1));
                }
                catch (IOException e) {
                    logger.warn("Could not detect default layout for theme " + themePath, (Throwable)e);
                }
            }
        }
        logger.info("Available Themes : " + Arrays.toString(themes.toArray()));
        this.registerBuiltinPortalBackends();
        FilterRegistration.Dynamic registration = sce.getServletContext().addFilter("BennuPortalDispatcher", BennuPortalDispatcher.class);
        registration.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), true, new String[]{"/*"});
        sce.getServletContext().setAttribute("portal", (Object)new PortalBean(sce.getServletContext()));
        MenuContainer.migrateMenus();
    }

    private void registerBuiltinPortalBackends() {
        PortalBackendRegistry.registerPortalBackend(new RedirectPortalBackend());
        PortalBackendRegistry.registerPortalBackend(new ForwarderPortalBackend());
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }

    public static Set<String> getThemes() {
        return Collections.unmodifiableSet(themes);
    }

    public static boolean isThemeAvailable(String theme) {
        return themes.contains(theme);
    }
}

