/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.portal.servlet;

import java.io.InputStream;
import java.util.Locale;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.fenixedu.bennu.core.api.json.AuthenticatedUserViewer;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.core.rest.BennuRestResource;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.core.util.CoreConfiguration;
import org.fenixedu.bennu.portal.domain.MenuFunctionality;
import org.fenixedu.bennu.portal.domain.PortalConfiguration;
import org.fenixedu.bennu.portal.servlet.BennuPortalDispatcher;
import org.fenixedu.commons.i18n.I18N;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PortalBean {
    private final String ctxPath;
    private static final Logger LOGGER = LoggerFactory.getLogger(PortalBean.class);
    private static String DEBUG_TOOLKIT_TAG = null;
    private static String DEBUG_TOOLKIT_ANGULAR_TAG = null;

    public PortalBean(ServletContext servletContext) {
        this.ctxPath = servletContext.getContextPath();
    }

    public String bennuPortal() {
        StringBuilder builder = new StringBuilder();
        builder.append("<script>");
        builder.append("window.Bennu = ");
        builder.append(BennuRestResource.getBuilder().view(null, Void.class, AuthenticatedUserViewer.class)).append(";");
        builder.append("window.contextPath = '").append(this.ctxPath).append("';");
        builder.append("</script>");
        return builder.toString();
    }

    private NodeList getFilesForId(String id) throws Exception {
        try (InputStream is = this.getClass().getResource("/META-INF/maven/org.fenixedu/bennu-toolkit/pom.xml").openStream();){
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder b = factory.newDocumentBuilder();
            Document doc = b.parse(is);
            XPathFactory xPathfactory = XPathFactory.newInstance();
            XPath xpath = xPathfactory.newXPath();
            XPathExpression expr = xpath.compile("//project/build/plugins/plugin/executions/execution[id = '" + id + "']/configuration/jsSourceFiles/jsSourceFile");
            Object result = expr.evaluate(doc, XPathConstants.NODESET);
            NodeList nodeList = (NodeList)result;
            return nodeList;
        }
    }

    private String getDebugToolkit() {
        if (DEBUG_TOOLKIT_TAG == null) {
            try {
                NodeList nodes = this.getFilesForId("toolkit");
                StringBuilder builder = new StringBuilder();
                builder.append("<link href=\"").append(this.ctxPath).append("/bennu-toolkit/css/toolkit.css\" rel=\"stylesheet\"/>");
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node currentItem = nodes.item(i);
                    builder.append("<script type=\"text/javascript\" src=\"").append(this.ctxPath).append("/bennu-toolkit/js/").append(currentItem.getTextContent()).append("\"></script>");
                }
                DEBUG_TOOLKIT_TAG = builder.toString();
            }
            catch (Exception e) {
                LOGGER.warn("Error resolving the portal POM, falling back into compiled toolkit");
                return this.getToolkit();
            }
        }
        return this.bennuPortal() + DEBUG_TOOLKIT_TAG;
    }

    private String getDebugToolkitAngular() {
        if (DEBUG_TOOLKIT_ANGULAR_TAG == null) {
            try {
                NodeList nodes = this.getFilesForId("toolkit-angular");
                StringBuilder builder = new StringBuilder();
                builder.append("<link href=\"").append(this.ctxPath).append("/bennu-toolkit/css/toolkit.css\" rel=\"stylesheet\"/>");
                builder.append("<script type=\"text/javascript\" src=\"").append(this.ctxPath).append("/bennu-portal/js/angular.min.js\"></script>");
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node currentItem = nodes.item(i);
                    builder.append("<script type=\"text/javascript\" src=\"").append(this.ctxPath).append("/bennu-toolkit/js/").append(currentItem.getTextContent()).append("\"></script>");
                }
                DEBUG_TOOLKIT_ANGULAR_TAG = builder.toString();
            }
            catch (Exception e) {
                LOGGER.warn("Error resolving the portal POM, falling back into compiled toolkit");
                return this.getAngularToolkit();
            }
        }
        return this.bennuPortal() + DEBUG_TOOLKIT_ANGULAR_TAG;
    }

    private String getModuleVersion() {
        return this.getClass().getPackage().getImplementationVersion();
    }

    private String getVersionedLink(String ctxPath, String script, String version) {
        return String.format("<link href=\"%s%s?ver=%s\" rel=\"stylesheet\"/>", ctxPath, script, version);
    }

    private String getVersionedScript(String ctxPath, String script, String version) {
        return String.format("<script type=\"text/javascript\" src=\"%s%s?ver=%s\"></script>", ctxPath, script, version);
    }

    private String getToolkit() {
        StringBuilder builder = new StringBuilder(this.bennuPortal());
        builder.append(this.getVersionedLink(this.ctxPath, "/bennu-toolkit/css/toolkit.css", this.getModuleVersion()));
        builder.append(this.getVersionedScript(this.ctxPath, "/bennu-toolkit/js/toolkit.js", this.getModuleVersion()));
        return builder.toString();
    }

    private String getAngularToolkit() {
        StringBuilder builder = new StringBuilder(this.bennuPortal());
        builder.append(this.getVersionedLink(this.ctxPath, "/bennu-toolkit/css/toolkit.css", this.getModuleVersion()));
        builder.append(this.getVersionedScript(this.ctxPath, "/bennu-portal/js/angular.min.js", this.getModuleVersion()));
        builder.append(this.getVersionedScript(this.ctxPath, "/bennu-toolkit/js/toolkit-angular.js", this.getModuleVersion()));
        return builder.toString();
    }

    public String toolkit() {
        if (CoreConfiguration.getConfiguration().developmentMode().booleanValue()) {
            return this.getDebugToolkit();
        }
        return this.getToolkit();
    }

    public String angularToolkit() {
        if (CoreConfiguration.getConfiguration().developmentMode().booleanValue()) {
            return this.getDebugToolkitAngular();
        }
        return this.getAngularToolkit();
    }

    public PortalConfiguration getConfiguration() {
        return PortalConfiguration.getInstance();
    }

    public Locale getLocale() {
        return I18N.getLocale();
    }

    public Set<Locale> getSupportedLocales() {
        return CoreConfiguration.supportedLocales();
    }

    public boolean getDevMode() {
        return CoreConfiguration.getConfiguration().developmentMode();
    }

    public User getCurrentUser() {
        return Authenticate.getUser();
    }

    public MenuFunctionality selectedFunctionality(HttpServletRequest request) {
        return BennuPortalDispatcher.getSelectedFunctionality(request);
    }

    public String message(String bundle, String key) {
        return BundleUtil.getString((String)bundle, (String)key, (String[])new String[0]);
    }

    public String getApplicationUrl() {
        return CoreConfiguration.getConfiguration().applicationUrl();
    }
}

