/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.portal.domain;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.qubit.terra.framework.services.ServiceProvider;
import com.qubit.terra.framework.services.context.ApplicationUser;
import com.qubit.terra.portal.domain.layouts.Layout;
import com.qubit.terra.portal.domain.layouts.LayoutProvider;
import com.qubit.terra.portal.domain.menus.MenuVisibility;
import com.qubit.terra.portal.services.layouts.LayoutProviderRegistry;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.domain.groups.PersistentGroup;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.portal.domain.MenuContainer;
import org.fenixedu.bennu.portal.domain.MenuFunctionality;
import org.fenixedu.bennu.portal.domain.MenuItem$callable$delete;
import org.fenixedu.bennu.portal.domain.MenuItem_Base;
import org.fenixedu.commons.i18n.LocalizedString;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public abstract class MenuItem
extends MenuItem_Base
implements com.qubit.terra.portal.domain.menus.MenuItem {
    private static final Supplier<LayoutProviderRegistry> layoutProviderRegistrySupplier;
    public static final Advice advice$delete;

    protected MenuItem() {
        this.setOrd(1);
    }

    protected final void init(MenuContainer parent, boolean visible, String accessGroup, LocalizedString title, LocalizedString description, String path) {
        this.setVisible(visible);
        this.setVisibility(visible ? MenuVisibility.ALL.name() : MenuVisibility.INVISIBLE.name());
        this.setAccessGroup(Group.parse((String)accessGroup));
        this.setDescription(description);
        this.setTitle(title);
        this.setPath(path);
        if (parent != null) {
            parent.addChild(this);
        }
        this.setFullPath(this.computeFullPath());
    }

    protected final void init(MenuContainer parent, MenuItem original) {
        this.setVisible(original.getVisible());
        this.setVisibility(original.getVisibility());
        this.setAccessGroup(original.getAccessGroup());
        this.setDescription(original.getDescription());
        this.setTitle(original.getTitle());
        this.setPath(original.getPath());
        this.setLayout(original.getLayout());
        if (parent != null) {
            parent.addChild(this);
        }
        this.setFullPath(this.computeFullPath());
    }

    public Group getAccessGroup() {
        return this.getGroup().toGroup();
    }

    public void setAccessGroup(Group group) {
        this.setGroup(group.toPersistentGroup());
    }

    protected void setGroup(PersistentGroup group) {
        super.setGroup(group);
        if (this.getParent() != null) {
            this.getParent().updateAccessGroup();
        }
    }

    public boolean isMenuContainer() {
        return this instanceof MenuContainer;
    }

    public boolean isMenuFunctionality() {
        return this instanceof MenuFunctionality;
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new MenuItem$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(MenuItem this_) {
        this_.setParent(null);
        this_.setGroup(null);
        this_.deleteDomainObject();
    }

    public boolean isAvailable(User user) {
        return this.getGroup().isMember(user) && this.getParent().isAvailable(user);
    }

    protected boolean isItemAvailableForCurrentUser() {
        return this.getGroup().isMember(Authenticate.getUser());
    }

    @Deprecated
    public boolean isVisible() {
        return this.getVisible();
    }

    @Deprecated
    public void setVisible(boolean visible) {
        super.setVisible(Boolean.valueOf(visible));
    }

    public MenuVisibility getItemVisibility() {
        return this.getVisibility() == null ? null : MenuVisibility.valueOf((String)this.getVisibility());
    }

    public void setItemVisibility(MenuVisibility visibility) {
        if (visibility != null) {
            this.setVisibility(visibility.name());
        }
    }

    public void setItemVisible(boolean visible) {
        this.setVisible(visible);
    }

    public MenuContainer getParent() {
        return super.getParent();
    }

    public String getPath() {
        return super.getPath();
    }

    public String getFullPath() {
        return super.getFullPath();
    }

    public MenuContainer getAsMenuContainer() {
        if (this.isMenuContainer()) {
            return (MenuContainer)((Object)this);
        }
        throw new IllegalStateException("Not a MenuContainer");
    }

    public MenuFunctionality getAsMenuFunctionality() {
        if (this.isMenuFunctionality()) {
            return (MenuFunctionality)((Object)this);
        }
        throw new IllegalStateException("Not a MenuFunctionality");
    }

    public abstract MenuItem moveTo(MenuContainer var1);

    public List<com.qubit.terra.portal.domain.menus.MenuItem> getPathFromRoot() {
        return super.getPathFromRoot();
    }

    public boolean isItemRestricted() {
        if (this.getParent() == null) {
            return true;
        }
        return this.getRestricted() != null ? this.getRestricted().booleanValue() : this.getParent().isItemRestricted();
    }

    public String getRecursiveProviderImplementation() {
        if (!StringUtils.isEmpty((String)this.getProviderImplementation())) {
            return this.getProviderImplementation();
        }
        return this.getParent() != null ? this.getParent().getRecursiveProviderImplementation() : null;
    }

    public Integer getPosition() {
        return super.getOrd();
    }

    public void setItemName(com.qubit.terra.framework.tools.primitives.LocalizedString name) {
        this.setTitle(BundleUtil.convertToBennuLocalizedString((com.qubit.terra.framework.tools.primitives.LocalizedString)name));
    }

    public void setPosition(Integer position) {
        super.setOrd(position);
    }

    public com.qubit.terra.framework.tools.primitives.LocalizedString getItemName() {
        return BundleUtil.convertToPlatformLocalizedString((LocalizedString)super.getTitle());
    }

    public String getItemPath() {
        return this.getPath();
    }

    public String getFullItemPath() {
        return this.getFullPath();
    }

    public void setItemPath(String path) {
        this.setPath(path);
    }

    public String getItemIcon() {
        return super.getIcon();
    }

    public void setItemIcon(String icon) {
        this.setIcon(icon);
    }

    public String getMenuLayout() {
        return super.getLayout();
    }

    public void setMenuLayout(String layout) {
        this.setLayout(layout);
    }

    public void setMenuItemFullPath(String path) {
        this.setFullPath(path);
    }

    public com.qubit.terra.framework.tools.primitives.LocalizedString getItemDescription() {
        return BundleUtil.convertToPlatformLocalizedString((LocalizedString)super.getDescription());
    }

    public boolean isAvailableForUser(ApplicationUser appUser) {
        return this.isAvailable(this.getBennuUser(appUser));
    }

    public com.qubit.terra.portal.domain.menus.MenuContainer getParentContainer() {
        return super.getParent();
    }

    public String getItemProviderImplementation() {
        return this.getProviderImplementation();
    }

    public void setItemProviderImplementation(String providerImplementation) {
        this.setProviderImplementation(providerImplementation);
    }

    public MenuContainer asMenuContainer() {
        return this.getAsMenuContainer();
    }

    public MenuFunctionality asMenuFunctionality() {
        return this.getAsMenuFunctionality();
    }

    public String getAccessControlExpression() {
        return this.getAccessGroup() == null ? null : this.getAccessGroup().getExpression();
    }

    public void setAccessControlExpression(String expression) {
        this.setAccessGroup(Group.parse((String)expression));
    }

    public void setItemDescription(com.qubit.terra.framework.tools.primitives.LocalizedString description) {
        this.setDescription(BundleUtil.convertToBennuLocalizedString((com.qubit.terra.framework.tools.primitives.LocalizedString)description));
    }

    public void setItemRestricted(Boolean restricted) {
        this.setRestricted(restricted);
    }

    protected User getBennuUser(ApplicationUser appUser) {
        return appUser != null ? User.findByUsername((String)appUser.getUsername()) : null;
    }

    public Layout getLayoutObject() {
        return ((LayoutProvider)((LayoutProviderRegistry)layoutProviderRegistrySupplier.get()).getLayoutProviders().values().iterator().next()).getLayout(this.getLayout()).orElse(null);
    }

    public void setLayoutObject(Layout layout) {
        String layoutKey = layout == null ? null : layout.getKey();
        this.setLayout(layoutKey);
    }

    public Layout resolveLayoutObject() {
        return Optional.ofNullable(super.resolveLayoutObject()).orElse(((LayoutProvider)((LayoutProviderRegistry)layoutProviderRegistrySupplier.get()).getLayoutProviders().values().iterator().next()).getLayout("default").orElse(null));
    }

    static {
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        layoutProviderRegistrySupplier = Suppliers.memoize(() -> (LayoutProviderRegistry)ServiceProvider.getService(LayoutProviderRegistry.class));
    }
}

