/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.alerts;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.fenixedu.bennu.alerts.FlashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FlashMapManager {
    private static final Object DEFAULT_FLASH_MAPS_MUTEX = new Object();
    private static final String FLASH_MAPS_SESSION_ATTRIBUTE = FlashMapManager.class.getName() + ".FLASH_MAPS";
    private static final String SESSION_MUTEX_ATTRIBUTE = FlashMapManager.class.getName() + ".MUTEX";
    protected final Logger logger = LoggerFactory.getLogger(FlashMapManager.class);
    private int flashMapTimeout = 180;

    FlashMapManager() {
    }

    private void setFlashMapTimeout(int flashMapTimeout) {
        this.flashMapTimeout = flashMapTimeout;
    }

    private int getFlashMapTimeout() {
        return this.flashMapTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final FlashMap retrieveAndUpdate(HttpServletRequest request) {
        List<FlashMap> allFlashMaps = this.retrieveFlashMaps(request);
        if (allFlashMaps == null || allFlashMaps.isEmpty()) {
            return null;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Retrieved FlashMap(s): " + allFlashMaps);
        }
        List<FlashMap> mapsToRemove = this.getExpiredFlashMaps(allFlashMaps);
        FlashMap match = this.getMatchingFlashMap(allFlashMaps, request);
        if (match != null) {
            mapsToRemove.add(match);
        }
        if (!mapsToRemove.isEmpty()) {
            Object mutex;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Removing FlashMap(s): " + mapsToRemove);
            }
            if ((mutex = this.getFlashMapsMutex(request)) != null) {
                Object object = mutex;
                synchronized (object) {
                    allFlashMaps = this.retrieveFlashMaps(request);
                    if (allFlashMaps != null) {
                        allFlashMaps.removeAll(mapsToRemove);
                        this.updateFlashMaps(allFlashMaps, request);
                    }
                }
            } else {
                allFlashMaps.removeAll(mapsToRemove);
                this.updateFlashMaps(allFlashMaps, request);
            }
        }
        return match;
    }

    private List<FlashMap> getExpiredFlashMaps(List<FlashMap> allMaps) {
        LinkedList<FlashMap> result = new LinkedList<FlashMap>();
        for (FlashMap map : allMaps) {
            if (!map.isExpired()) continue;
            result.add(map);
        }
        return result;
    }

    private FlashMap getMatchingFlashMap(List<FlashMap> allMaps, HttpServletRequest request) {
        LinkedList<FlashMap> result = new LinkedList<FlashMap>();
        for (FlashMap flashMap : allMaps) {
            if (!this.isFlashMapForRequest(flashMap, request)) continue;
            result.add(flashMap);
        }
        if (!result.isEmpty()) {
            Collections.sort(result);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Found matching FlashMap(s): " + result);
            }
            return (FlashMap)result.get(0);
        }
        return null;
    }

    protected Multimap<String, String> splitQuery(String query) {
        try {
            ArrayListMultimap query_pairs = ArrayListMultimap.create();
            if (query != null) {
                String[] pairs;
                for (String pair : pairs = query.split("&")) {
                    int idx = pair.indexOf("=");
                    String key = idx > 0 ? URLDecoder.decode(pair.substring(0, idx), "UTF-8") : pair;
                    String value = idx > 0 && pair.length() > idx + 1 ? URLDecoder.decode(pair.substring(idx + 1), "UTF-8") : null;
                    query_pairs.put((Object)key, value);
                }
            }
            return query_pairs;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isFlashMapForRequest(FlashMap flashMap, HttpServletRequest request) {
        String requestUri;
        String expectedPath = flashMap.getTargetRequestPath();
        if (expectedPath != null && !(requestUri = this.getOriginatingRequestUri(request)).equals(expectedPath) && !requestUri.equals(expectedPath + "/")) {
            return false;
        }
        Multimap<String, String> actualParams = this.splitQuery(request.getQueryString());
        Multimap<String, String> expectedParams = flashMap.getTargetRequestParams();
        for (String expectedName : expectedParams.keySet()) {
            Collection actualValues = actualParams.get((Object)expectedName);
            if (actualValues == null) {
                return false;
            }
            for (String expectedValue : expectedParams.get((Object)expectedName)) {
                if (actualValues.contains(expectedValue)) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveOutputFlashMap(FlashMap flashMap, HttpServletRequest request) {
        if (flashMap == null || flashMap.isEmpty()) {
            return;
        }
        String path = this.decodeAndNormalizePath(flashMap.getTargetRequestPath(), request);
        flashMap.setTargetRequestPath(path);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Saving FlashMap=" + flashMap);
        }
        flashMap.startExpirationPeriod(this.getFlashMapTimeout());
        Object mutex = this.getFlashMapsMutex(request);
        if (mutex != null) {
            Object object = mutex;
            synchronized (object) {
                CopyOnWriteArrayList<FlashMap> allFlashMaps = this.retrieveFlashMaps(request);
                allFlashMaps = allFlashMaps != null ? allFlashMaps : new CopyOnWriteArrayList<FlashMap>();
                allFlashMaps.add(flashMap);
                this.updateFlashMaps(allFlashMaps, request);
            }
        } else {
            LinkedList<FlashMap> allFlashMaps = this.retrieveFlashMaps(request);
            allFlashMaps = allFlashMaps != null ? allFlashMaps : new LinkedList<FlashMap>();
            allFlashMaps.add(flashMap);
            this.updateFlashMaps(allFlashMaps, request);
        }
    }

    private String decodeRequestString(HttpServletRequest request, String source) {
        return this.decodeInternal(request, source);
    }

    private String determineEncoding(HttpServletRequest request) {
        String enc = request.getCharacterEncoding();
        if (enc == null) {
            enc = "ISO-8859-1";
        }
        return enc;
    }

    private String decodeInternal(HttpServletRequest request, String source) {
        String enc = this.determineEncoding(request);
        try {
            return URLDecoder.decode(source, enc);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    private String decodeAndNormalizePath(String path, HttpServletRequest request) {
        if (path != null && ((String)(path = this.decodeRequestString(request, (String)path))).charAt(0) != '/') {
            String requestUri = this.getRequestUri(request);
            path = requestUri.substring(0, requestUri.lastIndexOf(47) + 1) + (String)path;
            path = Paths.get((String)path, new String[0]).normalize().toString();
        }
        return path;
    }

    private String getOriginatingRequestUri(HttpServletRequest request) {
        String uri = (String)request.getAttribute("javax.servlet.forward.request_uri");
        if (uri == null) {
            uri = request.getRequestURI();
        }
        return this.decodeAndCleanUriString(request, uri);
    }

    private String decodeAndCleanUriString(HttpServletRequest request, String uri) {
        uri = this.removeSemicolonContent(uri);
        uri = this.decodeRequestString(request, uri);
        return uri;
    }

    private String removeSemicolonContent(String requestUri) {
        return this.removeSemicolonContentInternal(requestUri);
    }

    private String removeJsessionid(String requestUri) {
        int startIndex = requestUri.toLowerCase().indexOf(";jsessionid=");
        if (startIndex != -1) {
            int endIndex = requestUri.indexOf(59, startIndex + 12);
            String start = requestUri.substring(0, startIndex);
            requestUri = endIndex != -1 ? start + requestUri.substring(endIndex) : start;
        }
        return requestUri;
    }

    private String removeSemicolonContentInternal(String requestUri) {
        int semicolonIndex = requestUri.indexOf(59);
        while (semicolonIndex != -1) {
            int slashIndex = requestUri.indexOf(47, semicolonIndex);
            String start = requestUri.substring(0, semicolonIndex);
            requestUri = slashIndex != -1 ? start + requestUri.substring(slashIndex) : start;
            semicolonIndex = requestUri.indexOf(59, semicolonIndex);
        }
        return requestUri;
    }

    private String getRequestUri(HttpServletRequest request) {
        String uri = (String)request.getAttribute("javax.servlet.include.request_uri");
        if (uri == null) {
            uri = request.getRequestURI();
        }
        return this.decodeAndCleanUriString(request, uri);
    }

    private List<FlashMap> retrieveFlashMaps(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        return session != null ? (List)session.getAttribute(FLASH_MAPS_SESSION_ATTRIBUTE) : null;
    }

    private void updateFlashMaps(List<FlashMap> flashMaps, HttpServletRequest request) {
        if (flashMaps.isEmpty()) {
            HttpSession session = request.getSession(false);
            if (session != null) {
                session.removeAttribute(FLASH_MAPS_SESSION_ATTRIBUTE);
            }
        } else {
            request.getSession().setAttribute(FLASH_MAPS_SESSION_ATTRIBUTE, flashMaps);
        }
    }

    private Object getFlashMapsMutex(HttpServletRequest request) {
        HttpSession session = request.getSession();
        Object mutex = session.getAttribute(SESSION_MUTEX_ATTRIBUTE);
        if (mutex == null) {
            mutex = session;
        }
        return mutex;
    }
}

