/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.portal.model;

import com.google.gson.JsonObject;
import com.qubit.terra.framework.tools.primitives.LocalizedString;
import org.fenixedu.bennu.core.i18n.BundleUtil;

public final class Functionality
implements Comparable<Functionality>,
com.qubit.terra.portal.domain.functionalities.Functionality {
    private final String provider;
    private final String key;
    private final String path;
    private final String accessGroup;
    private final org.fenixedu.commons.i18n.LocalizedString title;
    private final org.fenixedu.commons.i18n.LocalizedString description;
    private final boolean visible;

    public Functionality(String provider, String key, String path, String accessGroup, org.fenixedu.commons.i18n.LocalizedString title, org.fenixedu.commons.i18n.LocalizedString description) {
        this(provider, key, path, accessGroup, title, description, true);
    }

    public Functionality(String provider, String key, String path, String accessGroup, org.fenixedu.commons.i18n.LocalizedString title, org.fenixedu.commons.i18n.LocalizedString description, boolean visible) {
        this.provider = provider;
        this.key = key;
        this.path = path;
        this.accessGroup = accessGroup;
        this.title = title;
        this.description = description;
        this.visible = visible;
    }

    public String getProvider() {
        return this.provider;
    }

    public String getKey() {
        return this.key;
    }

    public String getPath() {
        return this.path;
    }

    public String getAccessGroup() {
        return this.accessGroup;
    }

    public org.fenixedu.commons.i18n.LocalizedString getTitle() {
        return this.title;
    }

    public org.fenixedu.commons.i18n.LocalizedString getDescription() {
        return this.description;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public JsonObject json() {
        JsonObject obj = new JsonObject();
        obj.addProperty("path", this.path);
        obj.addProperty("accessGroup", this.accessGroup);
        obj.addProperty("key", this.key);
        obj.add("title", this.title.json());
        obj.add("description", this.description.json());
        obj.addProperty("provider", this.provider);
        return obj;
    }

    public String toString() {
        return this.json().toString();
    }

    @Override
    public int compareTo(Functionality other) {
        if (!this.visible && other.visible) {
            return -1;
        }
        if (this.visible && !other.visible) {
            return 1;
        }
        int compareTo = this.title.compareTo(other.title);
        if (compareTo != 0) {
            return compareTo;
        }
        return this.path.compareTo(other.path);
    }

    public LocalizedString getFunctionalityTitle() {
        return BundleUtil.convertToPlatformLocalizedString((org.fenixedu.commons.i18n.LocalizedString)this.getTitle());
    }
}

