/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.portal.domain;

import com.qubit.terra.portal.domain.functionalities.Functionality;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.portal.domain.BennuPortalDomainException;
import org.fenixedu.bennu.portal.domain.MenuContainer$callable$delete;
import org.fenixedu.bennu.portal.domain.MenuContainer_Base;
import org.fenixedu.bennu.portal.domain.MenuFunctionality;
import org.fenixedu.bennu.portal.domain.MenuItem;
import org.fenixedu.bennu.portal.domain.PortalConfiguration;
import org.fenixedu.bennu.portal.model.Application;
import org.fenixedu.bennu.portal.model.ApplicationRegistry;
import org.fenixedu.commons.i18n.LocalizedString;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class MenuContainer
extends MenuContainer_Base
implements com.qubit.terra.portal.domain.menus.MenuContainer {
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    MenuContainer(PortalConfiguration configuration) {
        if (configuration.getMenu() != null && configuration.getMenu() != this) {
            throw new RuntimeException("There can be only one root menu!");
        }
        this.setConfiguration(configuration);
        this.init(null, false, "anyone", new LocalizedString(), new LocalizedString(), "ROOT_PATH");
    }

    public MenuContainer(MenuContainer parent, Application application) {
        if (parent == null) {
            throw new IllegalArgumentException("MenuContainer requires a parent Container!");
        }
        this.init(parent, true, application.getAccessGroup(), application.getTitle(), application.getDescription(), application.getPath());
        for (Functionality functionality : application.getFunctionalities()) {
            new MenuFunctionality(this, (org.fenixedu.bennu.portal.model.Functionality)functionality);
        }
    }

    public MenuContainer(MenuContainer parent, boolean visible, String accessGroup, LocalizedString description, LocalizedString title, String path) {
        if (parent == null) {
            throw new IllegalArgumentException("MenuFunctionality cannot be created without a parent!");
        }
        this.init(parent, visible, accessGroup, title, description, path);
    }

    private MenuContainer(MenuContainer parent, MenuContainer original) {
        if (parent == null) {
            throw new IllegalArgumentException("MenuFunctionality cannot be created without a parent!");
        }
        this.init(parent, (MenuItem)((Object)original));
    }

    public void addChild(MenuItem child) throws BennuPortalDomainException {
        this.addChild(child, this.getNextOrder());
    }

    private Integer getNextOrder() {
        return this.getChildSet().size() + 1;
    }

    public void addChild(MenuItem child, Integer order) throws BennuPortalDomainException {
        child.setOrd(order);
        for (MenuItem existing : this.getChildSet()) {
            if (!existing.getPath().equals(child.getPath())) continue;
            throw BennuPortalDomainException.childWithPathAlreadyExists(child.getPath());
        }
        super.addChild(child);
    }

    public Set<MenuItem> getOrderedChild() {
        return Collections.unmodifiableSet(new TreeSet(this.getChildSet()));
    }

    public Stream<MenuItem> getUserMenuStream() {
        return this.getChildSet().stream().filter(item -> item.isItemVisible() && item.isItemAvailableForCurrentUser()).sorted();
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new MenuContainer$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(MenuContainer this_) {
        if (this_.getConfiguration() != null) {
            throw BennuPortalDomainException.cannotDeleteRootContainer();
        }
        this_.setConfigurationFromSubRoot(null);
        for (MenuItem child : this_.getChildSet()) {
            child.delete();
        }
        super.delete();
    }

    public boolean isRoot() {
        return this.getConfiguration() != null;
    }

    public String resolveLayout() {
        if (this.getConfiguration() != null) {
            return !StringUtils.isBlank((String)this.getLayout()) ? this.getLayout() : "default";
        }
        if (!StringUtils.isBlank((String)this.getLayout())) {
            return this.getLayout();
        }
        return this.getParent().resolveLayout();
    }

    public boolean isAvailable(User user) {
        return this.isRoot() ? true : super.isAvailable(user);
    }

    public final MenuFunctionality findFunctionalityWithPath(String[] parts) {
        return this.findFunctionalityWithPath(parts, 0, true);
    }

    public final MenuFunctionality findFunctionalityWithPathWithoutAccessControl(String[] parts) {
        return this.findFunctionalityWithPath(parts, 0, false);
    }

    private final MenuFunctionality findFunctionalityWithPath(String[] parts, int startIndex, Boolean checkUserAccessToFunctionality) {
        if (parts.length == startIndex) {
            return this.findInitialContent();
        }
        for (MenuItem child : this.getChildSet()) {
            if (!child.getPath().equals(parts[startIndex]) || !this.checkUserAccessToFunctionality(child, checkUserAccessToFunctionality)) continue;
            if (child.isMenuFunctionality()) {
                return child.getAsMenuFunctionality();
            }
            return child.getAsMenuContainer().findFunctionalityWithPath(parts, startIndex + 1, checkUserAccessToFunctionality);
        }
        return null;
    }

    private boolean checkUserAccessToFunctionality(MenuItem menuItem, Boolean checkAccess) {
        return checkAccess != false ? menuItem.isItemAvailableForCurrentUser() : true;
    }

    public MenuFunctionality findInitialContent() {
        for (MenuItem item : this.getOrderedChild()) {
            if (!item.isItemAvailableForCurrentUser()) continue;
            if (item.isMenuFunctionality()) {
                return item.getAsMenuFunctionality();
            }
            MenuFunctionality functionality = item.getAsMenuContainer().findInitialContent();
            if (functionality == null) continue;
            return functionality;
        }
        return null;
    }

    public MenuContainer moveTo(MenuContainer newParent) {
        MenuContainer copy = new MenuContainer(newParent, this);
        for (MenuItem item : this.getChildSet()) {
            item.moveTo(copy);
        }
        super.delete();
        return copy;
    }

    public boolean isSubRoot() {
        return this.getConfigurationFromSubRoot() != null;
    }

    public boolean isItemVisible() {
        return !this.isSubRoot() && super.isItemVisible();
    }

    public static MenuContainer createSubRoot(String key, LocalizedString title, LocalizedString description) {
        MenuContainer container = new MenuContainer(PortalConfiguration.getInstance().getMenu(), false, Group.anyone().getExpression(), description, title, key);
        PortalConfiguration.getInstance().addSubRoot(container);
        return container;
    }

    public void setPath(String path) {
        if (!path.equals(this.getPath())) {
            super.setPath(path);
            this.updateFullPath();
        }
    }

    public Set<com.qubit.terra.portal.domain.functionalities.Application> getApplications() {
        String availableApplicationNames = this.getAvailableApplicationNames();
        return availableApplicationNames == null ? Collections.emptySet() : Stream.of(availableApplicationNames.split(",")).map(key -> ApplicationRegistry.getAppByKey(key)).filter(app -> app != null && app.getFunctionalities().size() > 0).collect(Collectors.toSet());
    }

    public List<com.qubit.terra.portal.domain.menus.MenuItem> getChilds() {
        return this.getOrderedChild().stream().map(t -> t).collect(Collectors.toList());
    }

    public void addChildMenuItem(com.qubit.terra.portal.domain.menus.MenuItem menuItem) {
        this.addChild((MenuItem)menuItem);
    }

    public boolean isRootApplicationMenu() {
        return this.isRoot();
    }

    public void updateAccessGroup() {
        String groupExpression = this.getChildSet().stream().map(item -> item.getAccessGroup().getExpression()).collect(Collectors.joining(" | "));
        this.setAccessGroup(Group.parse((String)groupExpression));
    }

    public void setApplications(Set<com.qubit.terra.portal.domain.functionalities.Application> applications) {
        if (applications != null && !applications.isEmpty()) {
            this.setAvailableApplicationNames(applications.stream().map(app -> app.getKey()).collect(Collectors.joining(",")));
        } else {
            this.setAvailableApplicationNames(null);
        }
    }
}

