/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.portal.servlet;

import com.mitchellbosecke.pebble.PebbleEngine;
import com.mitchellbosecke.pebble.error.LoaderException;
import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.extension.Extension;
import com.mitchellbosecke.pebble.loader.ClasspathLoader;
import com.mitchellbosecke.pebble.loader.Loader;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.core.servlet.ExceptionHandlerFilter;
import org.fenixedu.bennu.portal.BennuPortalConfiguration;
import org.fenixedu.bennu.portal.domain.PortalConfiguration;
import org.fenixedu.bennu.portal.servlet.BennuPortalDispatcher;
import org.fenixedu.bennu.portal.servlet.PortalExtension;
import org.fenixedu.commons.i18n.I18N;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortalExceptionHandler
implements ExceptionHandlerFilter.ExceptionHandler {
    private static final Logger logger = LoggerFactory.getLogger(PortalExceptionHandler.class);
    private final PebbleEngine engine;

    public PortalExceptionHandler(final ServletContext context) {
        this((Loader)new ClasspathLoader(){

            public Reader getReader(String themeName) throws LoaderException {
                InputStream stream = context.getResourceAsStream("/themes/" + themeName + "/500.html");
                if (stream != null) {
                    return new InputStreamReader(stream, StandardCharsets.UTF_8);
                }
                return new InputStreamReader(context.getResourceAsStream("/bennu-portal/500.html"), StandardCharsets.UTF_8);
            }
        }, context);
    }

    protected PortalExceptionHandler(Loader loader, ServletContext context) {
        this.engine = new PebbleEngine.Builder().loader(loader).extension(new Extension[]{new PortalExtension(context)}).cacheActive(BennuPortalConfiguration.getConfiguration().themeDevelopmentMode() == false).build();
    }

    public boolean handle(ServletRequest request, ServletResponse response, Throwable exception) throws ServletException, IOException {
        if (response.isCommitted()) {
            return false;
        }
        response.reset();
        ((HttpServletResponse)response).setStatus(500);
        HttpServletRequest req = (HttpServletRequest)request;
        logger.error("Request at " + req.getRequestURI() + " threw an exception: ", exception);
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        PortalConfiguration config = PortalConfiguration.getInstance();
        ctx.put("loggedUser", Authenticate.getUser());
        ctx.put("config", (Object)config);
        ctx.put("contextPath", req.getContextPath());
        ctx.put("request", req);
        ctx.put("exception", exception);
        ctx.put("locale", I18N.getLocale());
        ctx.put("userAgent", req.getHeader("User-Agent"));
        ctx.put("referer", req.getHeader("Referer"));
        ctx.put("parameters", this.getParameters(req));
        ctx.put("attributes", this.getAttributes(req));
        ctx.put("functionality", (Object)BennuPortalDispatcher.getSelectedFunctionality(req));
        this.setExtraParameters(ctx, req, exception);
        StringWriter writer = new StringWriter(1024);
        exception.printStackTrace(new PrintWriter(writer));
        ctx.put("stackTrace", writer.toString());
        try {
            response.setContentType("text/html;charset=UTF-8");
            PebbleTemplate template = this.engine.getTemplate(config.getTheme());
            template.evaluate((Writer)response.getWriter(), ctx, I18N.getLocale());
            return true;
        }
        catch (PebbleException e) {
            throw new IOException(e);
        }
    }

    protected void setExtraParameters(Map<String, Object> ctx, HttpServletRequest req, Throwable exception) {
    }

    private Object getParameters(HttpServletRequest req) {
        TreeMap<String, String> params = new TreeMap<String, String>();
        Enumeration names = req.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            params.put(name.replace("{{", "%7B%7B"), String.join((CharSequence)" | ", req.getParameterValues(name)).replace("{{", "%7B%7B"));
        }
        return params.entrySet();
    }

    private Object getAttributes(HttpServletRequest req) {
        TreeMap<String, String> attrs = new TreeMap<String, String>();
        Enumeration names = req.getAttributeNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            try {
                Object attribute = req.getAttribute(name);
                attrs.put(name, attribute != null ? attribute.toString() : "");
            }
            catch (Throwable t) {
                attrs.put(name, "Unable to retrieve attribute due to exception " + t.getLocalizedMessage());
            }
        }
        return attrs.entrySet();
    }
}

