/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.portal.servlet;

import com.mitchellbosecke.pebble.error.LoaderException;
import com.mitchellbosecke.pebble.loader.ClasspathLoader;
import com.mitchellbosecke.pebble.loader.Loader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.fenixedu.bennu.portal.servlet.PortalExceptionHandler;

public class PortalDevModeExceptionHandler
extends PortalExceptionHandler {
    public PortalDevModeExceptionHandler(final ServletContext context) {
        super((Loader)new ClasspathLoader(){

            public Reader getReader(String themeName) throws LoaderException {
                return new InputStreamReader(context.getResourceAsStream("/bennu-portal/debugExceptionPage.html"), StandardCharsets.UTF_8);
            }
        }, context);
    }

    @Override
    protected void setExtraParameters(Map<String, Object> ctx, HttpServletRequest req, Throwable exception) {
        ctx.put("threadName", Thread.currentThread().getName());
        ctx.put("session", this.getSessionAttributes(req.getSession(false)));
        ctx.put("throwableInfos", ThrowableInfo.getFlatThrowableInfoList(exception));
    }

    private Object getSessionAttributes(HttpSession session) {
        if (session != null) {
            TreeMap<String, String> attrs = new TreeMap<String, String>();
            Enumeration names = session.getAttributeNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                try {
                    Object attribute = session.getAttribute(name);
                    attrs.put(name, attribute != null ? attribute.toString() : "");
                }
                catch (Throwable t) {
                    attrs.put(name, "Unable to retrieve attribute due to exception " + t.getLocalizedMessage());
                }
            }
            return attrs.entrySet();
        }
        return Collections.emptyList();
    }

    static class ElementInfo {
        private final StackTraceElement element;
        private final boolean isExternalClass;
        private final String simpleClassName;
        private final String packageName;

        public ElementInfo(StackTraceElement element) {
            this.element = element;
            String className = element.getClassName();
            this.simpleClassName = this.getSimpleClassName(className);
            this.packageName = className.substring(0, className.lastIndexOf("."));
            this.isExternalClass = !className.startsWith("pt.ist") && !className.contains(".fenixedu.");
        }

        private String getSimpleClassName(String className) {
            String[] parse = className.split("\\.");
            return parse[parse.length - 1];
        }

        public StackTraceElement getElement() {
            return this.element;
        }

        public boolean isExternalClass() {
            return this.isExternalClass;
        }

        public String getSimpleClassName() {
            return this.simpleClassName;
        }

        public String getPackageName() {
            return this.packageName;
        }
    }

    static class ThrowableInfo {
        private final boolean cause;
        private final boolean suppressed;
        private final int level;
        private final Throwable subject;
        private final List<ElementInfo> subjectInfo;

        public ThrowableInfo(boolean isCause, boolean isSurpressed, int level, Throwable subject) {
            this.cause = isCause;
            this.suppressed = isSurpressed;
            this.level = level;
            this.subject = subject;
            this.subjectInfo = ThrowableInfo.getSubjectInfo(subject);
        }

        public boolean isCause() {
            return this.cause;
        }

        public boolean isSuppressed() {
            return this.suppressed;
        }

        public int getLevel() {
            return this.level;
        }

        public Throwable getSubject() {
            return this.subject;
        }

        public List<ElementInfo> getSubjectInfo() {
            return this.subjectInfo;
        }

        public String getLocalizedMessage() {
            String message = this.subject.getLocalizedMessage();
            return message == null ? null : message.replace("\n", "<br />");
        }

        private static List<ElementInfo> getSubjectInfo(Throwable subject) {
            ArrayList<ElementInfo> subjectInfo = new ArrayList<ElementInfo>();
            for (StackTraceElement element : subject.getStackTrace()) {
                subjectInfo.add(new ElementInfo(element));
            }
            return subjectInfo;
        }

        public static List<ThrowableInfo> getFlatThrowableInfoList(Throwable t) {
            return ThrowableInfo.getFlatThrowableInfoList(t, false, false, 0);
        }

        private static List<ThrowableInfo> getFlatThrowableInfoList(Throwable t, boolean isCause, boolean isSurpressed, int level) {
            ArrayList<ThrowableInfo> list = new ArrayList<ThrowableInfo>();
            list.add(new ThrowableInfo(isCause, isSurpressed, level, t));
            for (Throwable supp : t.getSuppressed()) {
                list.addAll(ThrowableInfo.getFlatThrowableInfoList(supp, false, true, level + 1));
            }
            if (t.getCause() != null) {
                list.addAll(ThrowableInfo.getFlatThrowableInfoList(t.getCause(), true, false, level));
            }
            return list;
        }
    }
}

