/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.portal.domain;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.fenixedu.bennu.portal.domain.MenuContainer;
import org.fenixedu.bennu.portal.domain.MenuFunctionality_Base;
import org.fenixedu.bennu.portal.domain.MenuItem;
import org.fenixedu.bennu.portal.domain.PortalConfiguration;
import org.fenixedu.bennu.portal.model.Functionality;
import org.fenixedu.commons.i18n.LocalizedString;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.FenixFramework;

public class MenuFunctionality
extends MenuFunctionality_Base {
    private static final ConcurrentMap<String, MenuFunctionality> cache = new ConcurrentHashMap<String, MenuFunctionality>();

    public MenuFunctionality(MenuContainer parent, Functionality functionality) {
        if (parent == null) {
            throw new IllegalArgumentException("MenuFunctionality cannot be created without a parent!");
        }
        this.init(parent, functionality.isVisible(), functionality.getAccessGroup(), functionality.getTitle(), functionality.getDescription(), functionality.getPath());
        this.setDocumentationUrl("{base}");
        this.setItemKey(functionality.getKey());
        this.setProvider(functionality.getProvider());
    }

    public MenuFunctionality(MenuContainer parent, boolean visible, String key, String provider, String accessGroup, LocalizedString description, LocalizedString title, String path) {
        this(parent, visible, key, provider, accessGroup, description, title, path, "");
    }

    public MenuFunctionality(MenuContainer parent, boolean visible, String key, String provider, String accessGroup, LocalizedString description, LocalizedString title, String path, String documentationUrl) {
        if (parent == null) {
            throw new IllegalArgumentException("MenuFunctionality cannot be created without a parent!");
        }
        this.init(parent, visible, accessGroup, title, description, path);
        this.setDocumentationUrl(documentationUrl);
        this.setItemKey(key);
        this.setProvider(provider);
    }

    private MenuFunctionality(MenuContainer newParent, MenuFunctionality original) {
        if (newParent == null) {
            throw new IllegalArgumentException("MenuFunctionality cannot be created without a parent!");
        }
        this.init(newParent, (MenuItem)((Object)original));
        this.setDocumentationUrl(original.getDocumentationUrl());
        this.setItemKey(original.getItemKey());
        this.setProvider(original.getProvider());
    }

    public static MenuFunctionality findFunctionality(String provider, String key) {
        String functionality = "$$bennuPortal$$provider:" + provider + "$$bennu;Portal$$key:" + key;
        MenuFunctionality target = cache.computeIfAbsent(functionality, funct -> MenuFunctionality.findFunctionality(PortalConfiguration.getInstance().getMenu(), provider, key));
        if (target == null) {
            return null;
        }
        if (!FenixFramework.isDomainObjectValid((DomainObject)target)) {
            cache.remove(functionality, (Object)target);
            return MenuFunctionality.findFunctionality(provider, key);
        }
        return target;
    }

    public String resolveLayout() {
        if (this.getLayout() != null) {
            return this.getLayout();
        }
        return this.getParent().resolveLayout();
    }

    public String getProvider() {
        return super.getProvider();
    }

    public String getItemKey() {
        return super.getItemKey();
    }

    public String getParsedDocumentationUrl() {
        if (this.getDocumentationUrl() != null && PortalConfiguration.getInstance().getDocumentationBaseUrl() != null) {
            return this.getDocumentationUrl().replaceAll("\\{base\\}", PortalConfiguration.getInstance().getDocumentationBaseUrl());
        }
        return "";
    }

    public MenuFunctionality moveTo(MenuContainer newParent) {
        MenuFunctionality copy = new MenuFunctionality(newParent, this);
        this.delete();
        return copy;
    }

    private static MenuFunctionality findFunctionality(MenuContainer container, String provider, String key) {
        for (MenuItem item : container.getChildSet()) {
            MenuFunctionality functionality;
            if (!(item.isMenuFunctionality() ? (functionality = item.getAsMenuFunctionality()).getProvider().equals(provider) && functionality.getItemKey().equals(key) : (functionality = MenuFunctionality.findFunctionality(item.getAsMenuContainer(), provider, key)) != null)) continue;
            return functionality;
        }
        return null;
    }
}

