/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.portal.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.fenixedu.bennu.portal.client.ClientSidePortalBackend;
import org.fenixedu.bennu.portal.model.Application;
import org.fenixedu.bennu.portal.model.ApplicationRegistry;
import org.fenixedu.bennu.portal.model.Functionality;
import org.fenixedu.bennu.portal.servlet.PortalBackendRegistry;
import org.fenixedu.commons.i18n.LocalizedString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebListener
public class ClientSiteBackendInitilizer
implements ServletContextListener {
    private static final Logger logger = LoggerFactory.getLogger(ClientSiteBackendInitilizer.class);

    public void contextInitialized(ServletContextEvent sce) {
        PortalBackendRegistry.registerPortalBackend(new ClientSidePortalBackend());
        try {
            this.initAppsJsonFromJars(this.getClass().getClassLoader());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void initAppsJsonFromJars(ClassLoader classLoader) throws IOException {
        Enumeration<URL> resources = classLoader.getResources("apps.json");
        JsonParser parser = new JsonParser();
        while (resources.hasMoreElements()) {
            URL appsJsonURL = resources.nextElement();
            InputStreamReader appJsonReader = new InputStreamReader(appsJsonURL.openStream(), StandardCharsets.UTF_8);
            logger.debug("parsing apps.json for {}", (Object)appsJsonURL.toExternalForm());
            JsonArray appsJson = parser.parse((Reader)appJsonReader).getAsJsonObject().get("apps").getAsJsonArray();
            for (JsonElement appJson : appsJson) {
                this.parseApplicationInfo(appJson.getAsJsonObject());
            }
        }
    }

    private void parseApplicationInfo(JsonObject appJson) {
        String accessExpression = appJson.get("accessExpression").getAsString();
        String path = appJson.get("path").getAsString();
        LocalizedString title = LocalizedString.fromJson((JsonElement)appJson.get("title"));
        LocalizedString description = LocalizedString.fromJson((JsonElement)appJson.get("description"));
        String group = appJson.has("group") ? appJson.get("group").getAsString() : "client-side";
        Application app = new Application(path, path, accessExpression, title, description, group);
        if (appJson.has("functionalities")) {
            for (JsonElement functionality : appJson.get("functionalities").getAsJsonArray()) {
                this.parseFunctionality(app, functionality.getAsJsonObject());
            }
        }
        ApplicationRegistry.registerApplication(app);
    }

    private void parseFunctionality(Application application, JsonObject funcJson) {
        String accessExpression = funcJson.get("accessExpression").getAsString();
        String path = funcJson.get("path").getAsString();
        LocalizedString title = LocalizedString.fromJson((JsonElement)funcJson.get("title"));
        LocalizedString description = LocalizedString.fromJson((JsonElement)funcJson.get("description"));
        Functionality functionality = new Functionality("client-side", path, path, accessExpression, title, description);
        application.addFunctionality(functionality);
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }
}

