/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.portal.api.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.core.json.JsonBuilder;
import org.fenixedu.bennu.core.json.JsonCreator;
import org.fenixedu.bennu.core.json.JsonUpdater;
import org.fenixedu.bennu.core.json.JsonViewer;
import org.fenixedu.bennu.portal.api.json.SupportConfigurationAdapter;
import org.fenixedu.bennu.portal.domain.MenuContainer;
import org.fenixedu.bennu.portal.domain.MenuFunctionality;
import org.fenixedu.bennu.portal.domain.MenuItem;
import org.fenixedu.bennu.portal.domain.PortalConfiguration;
import org.fenixedu.bennu.portal.domain.SupportConfiguration;
import org.fenixedu.commons.i18n.LocalizedString;
import pt.ist.fenixframework.FenixFramework;

public class MenuItemAdapter
implements JsonViewer<MenuItem>,
JsonUpdater<MenuItem>,
JsonCreator<MenuContainer> {
    public MenuItem update(JsonElement json, MenuItem item, JsonBuilder ctx) {
        SupportConfiguration supportConfiguration;
        JsonObject jsonObj = json.getAsJsonObject();
        if (jsonObj.has("title")) {
            item.setTitle(LocalizedString.fromJson((JsonElement)jsonObj.get("title").getAsJsonObject()));
        }
        if (jsonObj.has("description")) {
            item.setDescription(LocalizedString.fromJson((JsonElement)jsonObj.get("description").getAsJsonObject()));
        }
        if (jsonObj.has("layout")) {
            item.setLayout(jsonObj.get("layout").getAsString());
        } else {
            item.setLayout(null);
        }
        if (jsonObj.has("icon")) {
            item.setIcon(jsonObj.get("icon").getAsString());
        } else {
            item.setIcon(null);
        }
        if (jsonObj.has("visible")) {
            item.setVisible(jsonObj.get("visible").getAsBoolean());
        }
        if (jsonObj.has("accessExpression")) {
            item.setAccessGroup(Group.parse((String)jsonObj.get("accessExpression").getAsString()));
        }
        if (item.isMenuFunctionality() && jsonObj.has("documentationUrl")) {
            item.getAsMenuFunctionality().setDocumentationUrl(jsonObj.get("documentationUrl").getAsString());
        }
        if (jsonObj.has("supportConfig") && (supportConfiguration = (SupportConfiguration)FenixFramework.getDomainObject((String)jsonObj.get("supportConfig").getAsString())) != null) {
            item.setSupport(supportConfiguration);
        }
        return item;
    }

    public JsonElement view(MenuItem obj, JsonBuilder ctx) {
        JsonObject json = new JsonObject();
        json.addProperty("id", obj.getExternalId());
        json.addProperty("order", (Number)obj.getOrd());
        json.addProperty("path", obj.getPath());
        json.addProperty("fullPath", obj.getFullPath());
        json.addProperty("accessExpression", obj.getAccessGroup().getExpression());
        json.addProperty("functionality", Boolean.valueOf(obj.isMenuFunctionality()));
        json.addProperty("visible", Boolean.valueOf(obj.isVisible()));
        json.addProperty("layout", obj.getLayout());
        json.addProperty("icon", obj.getIcon());
        json.add("description", ctx.view((Object)obj.getDescription()));
        json.add("title", ctx.view((Object)obj.getTitle()));
        json.add("supportConfigs", ctx.view((Object)Bennu.getInstance().getSupportConfigurationSet(), SupportConfigurationAdapter.class));
        json.add("supportConfig", ctx.view((Object)obj.getSupport(), SupportConfigurationAdapter.class));
        if (obj.isMenuContainer()) {
            MenuContainer container = obj.getAsMenuContainer();
            if (container.isRoot()) {
                json.add("title", ctx.view((Object)PortalConfiguration.getInstance().getApplicationTitle()));
                json.addProperty("appRoot", Boolean.valueOf(true));
            }
            json.add("menu", ctx.view(container.getOrderedChild(), MenuItemAdapter.class));
            json.addProperty("subRoot", Boolean.valueOf(container.isSubRoot()));
        } else {
            MenuFunctionality functionality = obj.getAsMenuFunctionality();
            json.addProperty("key", functionality.getItemKey());
            json.addProperty("provider", functionality.getProvider());
            json.addProperty("documentationUrl", functionality.getDocumentationUrl());
            json.addProperty("documentationUrlProcessed", functionality.getParsedDocumentationUrl());
        }
        return json;
    }

    public MenuContainer create(JsonElement json, JsonBuilder ctx) {
        JsonObject jsonObj = json.getAsJsonObject();
        MenuContainer parent = (MenuContainer)FenixFramework.getDomainObject((String)jsonObj.get("parent").getAsString());
        boolean visible = jsonObj.get("visible").getAsBoolean();
        String accessGroup = jsonObj.get("accessExpression").getAsString();
        LocalizedString description = LocalizedString.fromJson((JsonElement)jsonObj.get("description"));
        LocalizedString title = LocalizedString.fromJson((JsonElement)jsonObj.get("title"));
        String path = jsonObj.get("path").getAsString();
        MenuContainer container = new MenuContainer(parent, visible, accessGroup, description, title, path);
        if (jsonObj.has("layout")) {
            container.setLayout(jsonObj.get("layout").getAsString());
        }
        return container;
    }
}

