/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.portal.api.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.fenixedu.bennu.core.annotation.DefaultJsonAdapter;
import org.fenixedu.bennu.core.json.JsonBuilder;
import org.fenixedu.bennu.core.json.JsonViewer;
import org.fenixedu.bennu.portal.domain.MenuContainer;
import org.fenixedu.bennu.portal.domain.MenuItem;
import org.fenixedu.bennu.portal.domain.PortalConfiguration;

@DefaultJsonAdapter(value=MenuItem.class)
public class UserMenuViewer
implements JsonViewer<MenuItem> {
    public JsonElement view(MenuItem obj, JsonBuilder ctx) {
        JsonObject json = new JsonObject();
        json.addProperty("id", obj.getExternalId());
        json.addProperty("path", obj.getPath());
        json.addProperty("fullPath", obj.getFullPath());
        json.add("description", ctx.view((Object)obj.getDescription()));
        json.add("title", ctx.view((Object)obj.getTitle()));
        if (obj.isMenuContainer()) {
            MenuContainer container = obj.getAsMenuContainer();
            if (container.isRoot()) {
                json.add("title", ctx.view((Object)PortalConfiguration.getInstance().getApplicationTitle()));
            }
            json.add("menu", ctx.view(container.getUserMenuStream()));
        }
        return json;
    }
}

