/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.portal.api;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.core.rest.BennuRestResource;
import org.fenixedu.bennu.portal.api.MenuResource$callable$createSubRoot;
import org.fenixedu.bennu.portal.api.MenuResource$callable$createSupport;
import org.fenixedu.bennu.portal.api.MenuResource$callable$doInstall;
import org.fenixedu.bennu.portal.api.MenuResource$callable$doInstall$1;
import org.fenixedu.bennu.portal.api.MenuResource$callable$reorder;
import org.fenixedu.bennu.portal.api.json.MenuItemAdapter;
import org.fenixedu.bennu.portal.api.json.SupportConfigurationAdapter;
import org.fenixedu.bennu.portal.domain.MenuContainer;
import org.fenixedu.bennu.portal.domain.MenuFunctionality;
import org.fenixedu.bennu.portal.domain.MenuItem;
import org.fenixedu.bennu.portal.domain.SupportConfiguration;
import org.fenixedu.bennu.portal.model.Application;
import org.fenixedu.bennu.portal.model.ApplicationRegistry;
import org.fenixedu.bennu.portal.model.Functionality;
import org.fenixedu.commons.i18n.LocalizedString;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@Path(value="/bennu-portal/menu")
public class MenuResource
extends BennuRestResource {
    public static final Advice advice$createSubRoot = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
    public static final Advice advice$reorder = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createSupport = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$doInstall = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
    public static final Advice advice$doInstall$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));

    @Path(value="{oid}")
    @GET
    @Produces(value={"application/json"})
    public JsonElement getMenu(@PathParam(value="oid") String menuOid) {
        this.accessControl((Group)Group.managers());
        return this.viewMenu(this.getMenuItem(menuOid));
    }

    private JsonElement viewMenu(MenuItem menuItem) {
        return this.view(menuItem, MenuItemAdapter.class);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public JsonElement createMenu(JsonElement jsonData) {
        this.accessControl((Group)Group.managers());
        return this.viewMenu((MenuItem)this.create(jsonData, MenuContainer.class, MenuItemAdapter.class));
    }

    @POST
    @Path(value="/sub-root")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public JsonElement createSubRoot(JsonObject json) {
        this.accessControl((Group)Group.managers());
        String key = json.get("key").getAsString();
        LocalizedString title = LocalizedString.fromJson((JsonElement)json.get("title"));
        LocalizedString description = LocalizedString.fromJson((JsonElement)json.get("description"));
        return this.viewMenu(this.createSubRoot(key, title, description));
    }

    private MenuItem createSubRoot(String string, LocalizedString localizedString, LocalizedString localizedString2) {
        return (MenuItem)advice$createSubRoot.perform((Callable)new MenuResource$callable$createSubRoot(this, string, localizedString, localizedString2));
    }

    static /* synthetic */ MenuItem advised$createSubRoot(MenuResource this_, String key, LocalizedString title, LocalizedString description) {
        return MenuContainer.createSubRoot(key, title, description);
    }

    @PUT
    @Path(value="{oid}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public JsonElement updateMenu(JsonElement jsonData, @PathParam(value="oid") String oid) {
        this.accessControl((Group)Group.managers());
        return this.viewMenu((MenuItem)this.update(jsonData, this.getMenuItem(oid), MenuItemAdapter.class));
    }

    @Path(value="{oid}")
    @DELETE
    @Produces(value={"application/json"})
    public JsonElement deleteMenu(@PathParam(value="oid") String menuOid) {
        this.accessControl((Group)Group.managers());
        MenuItem menuItem = this.getMenuItem(menuOid);
        JsonElement rsp = this.viewMenu(menuItem);
        menuItem.delete();
        return rsp;
    }

    @POST
    @Path(value="/order")
    @Consumes(value={"application/json"})
    public Response reorderItems(JsonObject object) {
        this.accessControl((Group)Group.managers());
        this.reorder(object);
        return this.ok();
    }

    private void reorder(JsonObject jsonObject) {
        Object object = advice$reorder.perform((Callable)new MenuResource$callable$reorder(this, jsonObject));
    }

    static /* synthetic */ void advised$reorder(MenuResource this_, JsonObject object) {
        for (Map.Entry entry : object.entrySet()) {
            MenuItem item = (MenuItem)FenixFramework.getDomainObject((String)((String)entry.getKey()));
            item.setOrd(((JsonElement)entry.getValue()).getAsInt());
        }
    }

    @GET
    @Path(value="/applications")
    @Produces(value={"application/json"})
    public JsonElement listApps() {
        this.accessControl((Group)Group.managers());
        return this.view(ApplicationRegistry.availableApplications());
    }

    @POST
    @Path(value="/applications")
    @Consumes(value={"application/json"})
    public JsonElement installApp(JsonObject obj) {
        this.accessControl((Group)Group.managers());
        MenuContainer container = (MenuContainer)this.readDomainObject(obj.get("root").getAsString());
        Application app = ApplicationRegistry.getAppByKey(obj.get("key").getAsString());
        if (app == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        return this.viewMenu((MenuItem)((Object)this.doInstall(app, container)));
    }

    @POST
    @Path(value="/functionalities")
    @Consumes(value={"application/json"})
    public JsonElement installFunctionality(JsonObject obj) {
        this.accessControl((Group)Group.managers());
        MenuContainer container = (MenuContainer)this.readDomainObject(obj.get("root").getAsString());
        Application app = ApplicationRegistry.getAppByKey(obj.get("appKey").getAsString());
        if (app == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        Optional<MenuFunctionality> functionality = app.getFunctionalities().stream().filter(f -> f.getProvider().equals(obj.get("provider").getAsString()) && f.getKey().equals(obj.get("key").getAsString())).findAny().map(f -> this.doInstall(container, (Functionality)f));
        if (functionality.isPresent()) {
            return this.viewMenu((MenuItem)((Object)functionality.get()));
        }
        throw new WebApplicationException(Response.Status.NOT_FOUND);
    }

    @POST
    @Path(value="{oid}/support/")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public JsonElement addSupport(JsonElement jsonData, @PathParam(value="oid") String oid) {
        this.accessControl((Group)Group.managers());
        MenuItem menuItem = this.getMenuItem(oid);
        this.createSupport(menuItem, jsonData);
        return this.viewMenu(menuItem);
    }

    private void createSupport(MenuItem menuItem, JsonElement jsonElement) {
        Object object = advice$createSupport.perform((Callable)new MenuResource$callable$createSupport(this, menuItem, jsonElement));
    }

    static /* synthetic */ void advised$createSupport(MenuResource this_, MenuItem menuItem, JsonElement jsonData) {
        SupportConfiguration supportConfiguration = (SupportConfiguration)((Object)this_.create(jsonData, SupportConfiguration.class, SupportConfigurationAdapter.class));
        menuItem.setSupport(supportConfiguration);
    }

    private MenuFunctionality doInstall(MenuContainer menuContainer, Functionality functionality) {
        return (MenuFunctionality)((Object)advice$doInstall.perform((Callable)new MenuResource$callable$doInstall(this, menuContainer, functionality)));
    }

    static /* synthetic */ MenuFunctionality advised$doInstall(MenuResource this_, MenuContainer container, Functionality functionality) {
        return new MenuFunctionality(container, functionality);
    }

    private MenuContainer doInstall(Application application, MenuContainer menuContainer) {
        return (MenuContainer)((Object)advice$doInstall$1.perform((Callable)new MenuResource$callable$doInstall$1(this, application, menuContainer)));
    }

    static /* synthetic */ MenuContainer advised$doInstall(MenuResource this_, Application app, MenuContainer container) {
        return new MenuContainer(container, app);
    }

    private MenuItem getMenuItem(String oid) {
        return (MenuItem)this.readDomainObject(oid);
    }
}

