/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.alerts;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.fenixedu.bennu.alerts.FlashMap;
import org.fenixedu.bennu.alerts.FlashMapManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RedirectAttributes {
    private static final String INPUT_FLASH_MAP_ATTRIBUTE = RedirectAttributes.class.getName() + ".INPUT_FLASH_MAP";
    private static final String OUTPUT_FLASH_MAP_ATTRIBUTE = RedirectAttributes.class.getName() + ".OUTPUT_FLASH_MAP";
    private static final String FLASH_MAP_MANAGER_ATTRIBUTE = RedirectAttributes.class.getName() + ".FLASH_MAP_MANAGER";
    private static final Logger LOGGER = LoggerFactory.getLogger(RedirectAttributes.class);

    RedirectAttributes() {
    }

    protected static void initFromRequest(HttpServletRequest request) {
        if (request.getAttribute(OUTPUT_FLASH_MAP_ATTRIBUTE) == null) {
            FlashMapManager sfmm = new FlashMapManager();
            FlashMap inputFlashMap = sfmm.retrieveAndUpdate(request);
            if (inputFlashMap != null) {
                request.setAttribute(INPUT_FLASH_MAP_ATTRIBUTE, Collections.unmodifiableMap(inputFlashMap));
            }
            request.setAttribute(OUTPUT_FLASH_MAP_ATTRIBUTE, (Object)new FlashMap());
            request.setAttribute(FLASH_MAP_MANAGER_ATTRIBUTE, (Object)sfmm);
        }
    }

    protected static void flush(HttpServletRequest request, HttpServletResponse response) {
        FlashMap flashMap = (FlashMap)request.getAttribute(OUTPUT_FLASH_MAP_ATTRIBUTE);
        if (flashMap != null && !flashMap.isEmpty()) {
            FlashMapManager flashMapManager = RedirectAttributes.getFlashMapManager(request);
            int status = response.getStatus();
            if ((status == 300 || status == 301 || status == 302 || status == 303 || status == 307) && response.getHeader("Location") != null) {
                try {
                    URI url = new URI(response.getHeader("Location"));
                    flashMap.setTargetRequestPath(url.getPath());
                    flashMap.addTargetRequestParams(flashMapManager.splitQuery(url.getQuery()));
                }
                catch (URISyntaxException e) {
                    LOGGER.error("problem in ");
                }
            }
            flashMapManager.saveOutputFlashMap(flashMap, request);
        }
    }

    public static Map<String, ?> getInputFlashMap(HttpServletRequest request) {
        Object obj = request.getAttribute(INPUT_FLASH_MAP_ATTRIBUTE);
        if (obj != null) {
            return (Map)obj;
        }
        FlashMap inputFlashMap = new FlashMapManager().retrieveAndUpdate(request);
        if (inputFlashMap != null) {
            Map<String, Object> map = Collections.unmodifiableMap(inputFlashMap);
            request.setAttribute(INPUT_FLASH_MAP_ATTRIBUTE, map);
            return inputFlashMap;
        }
        return Collections.emptyMap();
    }

    public static FlashMap getOutputFlashMap(HttpServletRequest request) {
        return (FlashMap)request.getAttribute(OUTPUT_FLASH_MAP_ATTRIBUTE);
    }

    public static FlashMapManager getFlashMapManager(HttpServletRequest request) {
        return (FlashMapManager)request.getAttribute(FLASH_MAP_MANAGER_ATTRIBUTE);
    }

    public static void addFlashAttribute(HttpServletRequest request, String key, Object object) {
        RedirectAttributes.getOutputFlashMap(request).put(key, object);
    }

    public static void addFlashAttribute(HttpServletRequest request, Object object) {
        RedirectAttributes.getOutputFlashMap(request).put(object.getClass().getCanonicalName(), object);
    }
}

