/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.portal.servlet;

import java.util.HashMap;
import java.util.Map;
import org.fenixedu.bennu.portal.servlet.PortalBackend;

public final class PortalBackendRegistry {
    private static final Map<String, PortalBackend> backends = new HashMap<String, PortalBackend>();

    public static void registerPortalBackend(PortalBackend backend) {
        if (backends.containsKey(backend.getBackendKey())) {
            throw new IllegalArgumentException("Another backend with key " + backend.getBackendKey() + " is already registered");
        }
        backends.put(backend.getBackendKey(), backend);
    }

    public static PortalBackend getPortalBackend(String key) {
        PortalBackend backend = backends.get(key);
        if (backend == null) {
            throw new IllegalArgumentException("No backend for key " + key);
        }
        return backend;
    }
}

