/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.portal.servlet;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.fenixedu.bennu.portal.domain.MenuContainer;
import org.fenixedu.bennu.portal.domain.MenuFunctionality;
import org.fenixedu.bennu.portal.domain.PortalConfiguration;
import org.fenixedu.bennu.portal.servlet.PortalBackendRegistry;

public class BennuPortalDispatcher
implements Filter {
    private int contextPathLength = -1;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.contextPathLength = filterConfig.getServletContext().getContextPath().length();
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)resp;
        String path = this.trim(request.getRequestURI());
        MenuFunctionality functionality = this.selectFunctionality(path);
        if (functionality != null) {
            BennuPortalDispatcher.selectFunctionality(request, functionality);
            PortalBackendRegistry.getPortalBackend(functionality.getProvider()).getSemanticURLHandler().handleRequest(functionality, request, response, chain);
        } else {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    private MenuFunctionality selectFunctionality(String path) {
        String[] parts = path.split("/");
        MenuContainer root = PortalConfiguration.getInstance().getMenu();
        return root.findFunctionalityWithPath(parts);
    }

    public static MenuFunctionality getSelectedFunctionality(HttpServletRequest request) {
        return (MenuFunctionality)((Object)request.getAttribute("PORTAL_SELECTED_FUNCTIONALITY"));
    }

    public static void selectFunctionality(HttpServletRequest request, MenuFunctionality functionality) {
        request.setAttribute("PORTAL_SELECTED_FUNCTIONALITY", (Object)functionality);
    }

    private String trim(String value) {
        int st;
        int len = value.length();
        char[] val = value.toCharArray();
        for (st = this.contextPathLength; st < len && val[st] == '/'; ++st) {
        }
        while (st < len && val[len - 1] == '/') {
            --len;
        }
        return st > 0 || len < value.length() ? value.substring(st, len) : value;
    }
}

