/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.portal.model;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.fenixedu.bennu.portal.model.Application;

public final class ApplicationRegistry {
    private static final Map<String, Application> applications = new HashMap<String, Application>();

    public static void registerApplication(Application application) {
        if (applications.containsKey(application.getKey())) {
            throw new IllegalArgumentException("Application " + application.getKey() + " is already registered");
        }
        applications.put(application.getKey(), application);
    }

    public static Collection<Application> availableApplications() {
        return Collections.unmodifiableCollection(applications.values());
    }

    public static Application getAppByKey(String key) {
        if (!applications.containsKey(key)) {
            throw new IllegalArgumentException("No application registered under key " + key);
        }
        return applications.get(key);
    }
}

