/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.portal.domain;

import com.google.common.hash.Hashing;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.util.CoreConfiguration;
import org.fenixedu.bennu.portal.domain.MenuContainer;
import org.fenixedu.bennu.portal.domain.PortalConfiguration$callable$initialize;
import org.fenixedu.bennu.portal.domain.PortalConfiguration_Base;
import org.fenixedu.bennu.portal.servlet.PortalInitializer;
import org.fenixedu.commons.i18n.I18N;
import org.fenixedu.commons.i18n.LocalizedString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public final class PortalConfiguration
extends PortalConfiguration_Base {
    private static final Logger logger;
    public static final Advice advice$initialize;

    private PortalConfiguration() {
        InputStream stream;
        this.setRoot(Bennu.getInstance());
        this.setApplicationTitle(new LocalizedString(I18N.getLocale(), "Application Title"));
        this.setApplicationSubTitle(new LocalizedString(I18N.getLocale(), "Application Subtitle"));
        this.setApplicationCopyright(new LocalizedString(I18N.getLocale(), "Organization Copyright"));
        this.setHtmlTitle(this.getApplicationTitle());
        this.setTheme("default");
        try {
            stream = PortalConfiguration.class.getClassLoader().getResourceAsStream("META-INF/resources/img/logo_bennu.svg");
            try {
                if (stream == null) {
                    logger.error("Default logo not found in: img/logo_bennu.svg");
                } else {
                    this.setLogo(ByteStreams.toByteArray((InputStream)stream));
                    this.setLogoType("image/svg+xml");
                }
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (IOException e) {
            logger.error("Default logo could not be read from: img/logo_bennu.svg");
        }
        try {
            stream = PortalConfiguration.class.getClassLoader().getResourceAsStream("META-INF/resources/img/favicon_bennu.png");
            try {
                if (stream == null) {
                    logger.error("Default favicon not found in: img/favicon_bennu.png");
                } else {
                    this.setFavicon(ByteStreams.toByteArray((InputStream)stream));
                    this.setFaviconType("image/png");
                }
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (IOException e) {
            logger.error("Default logo could not be read from: img/favicon_bennu.png");
        }
        new MenuContainer(this);
    }

    public String getTheme() {
        String theme = super.getTheme();
        return PortalInitializer.isThemeAvailable(theme) ? theme : "default";
    }

    private static PortalConfiguration initialize() {
        return (PortalConfiguration)((Object)advice$initialize.perform((Callable)new PortalConfiguration$callable$initialize()));
    }

    static /* synthetic */ PortalConfiguration advised$initialize() {
        if (Bennu.getInstance().getConfiguration() == null) {
            return new PortalConfiguration();
        }
        return Bennu.getInstance().getConfiguration();
    }

    public static PortalConfiguration getInstance() {
        if (Bennu.getInstance().getConfiguration() == null) {
            return PortalConfiguration.initialize();
        }
        return Bennu.getInstance().getConfiguration();
    }

    public String getSupportEmailAddress() {
        return super.getSupportEmailAddress() != null ? super.getSupportEmailAddress() : CoreConfiguration.getConfiguration().defaultSupportEmailAddress();
    }

    public MenuContainer getMenu() {
        return super.getMenu();
    }

    public Set<MenuContainer> getSubRootSet() {
        return Collections.unmodifiableSet(super.getSubRootSet());
    }

    public Optional<MenuContainer> findSubRoot(String key) {
        return super.getSubRootSet().stream().filter(root -> root.getPath().equals(key)).findAny();
    }

    public String getLogoChecksum() {
        return super.getLogoChecksum();
    }

    public void setLogo(byte[] logo) {
        super.setLogo(logo);
        this.setLogoChecksum(logo == null ? null : Hashing.sha1().hashBytes(logo).toString().substring(0, 12));
    }

    static {
        advice$initialize = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
        logger = LoggerFactory.getLogger(PortalConfiguration.class);
    }
}

