/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.portal.domain;

import com.google.common.base.Strings;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.fenixedu.bennu.core.bootstrap.AdminUserBootstrapper;
import org.fenixedu.bennu.core.bootstrap.BootstrapError;
import org.fenixedu.bennu.core.bootstrap.annotations.Bootstrap;
import org.fenixedu.bennu.core.bootstrap.annotations.Bootstrapper;
import org.fenixedu.bennu.core.bootstrap.annotations.Field;
import org.fenixedu.bennu.core.bootstrap.annotations.Section;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.core.util.CoreConfiguration;
import org.fenixedu.bennu.portal.domain.MenuContainer;
import org.fenixedu.bennu.portal.domain.PortalConfiguration;
import org.fenixedu.bennu.portal.domain.SupportConfiguration;
import org.fenixedu.bennu.portal.model.ApplicationRegistry;
import org.fenixedu.commons.i18n.LocalizedString;

@Bootstrapper(bundle="resources.BennuPortalResources", name="bootstrapper.name", sections={PortalSection.class}, after={AdminUserBootstrapper.class})
public class PortalBootstrapper {
    @Bootstrap
    public static List<BootstrapError> bootstrapPortal(PortalSection portalSection) {
        PortalConfiguration portalConfiguration = PortalConfiguration.getInstance();
        new MenuContainer(portalConfiguration.getMenu(), ApplicationRegistry.getAppByKey("bennu-admin"));
        portalConfiguration.setApplicationCopyright(PortalBootstrapper.makeLocalized(portalSection.getOrganizationName()));
        portalConfiguration.setApplicationTitle(PortalBootstrapper.makeLocalized(portalSection.getApplicationTitle()));
        portalConfiguration.setApplicationSubTitle(PortalBootstrapper.makeLocalized(portalSection.getApplicationTitle()));
        portalConfiguration.setDocumentationBaseUrl(portalSection.getDocumentationUrl());
        portalConfiguration.setLoginPath(portalSection.getLoginPath());
        portalConfiguration.setSupportEmailAddress(portalSection.getSupportEmailAddress());
        if (!Strings.isNullOrEmpty((String)portalConfiguration.getSupportEmailAddress())) {
            SupportConfiguration defaultSupport = new SupportConfiguration(BundleUtil.getLocalizedString((String)"resources.BennuPortalResources", (String)"bootstrapper.default.support", (String[])new String[0]), portalConfiguration.getSupportEmailAddress());
            portalConfiguration.getMenu().setSupport(defaultSupport);
        }
        return Collections.emptyList();
    }

    private static LocalizedString makeLocalized(String value) {
        LocalizedString.Builder builder = new LocalizedString.Builder();
        for (Locale locale : CoreConfiguration.supportedLocales()) {
            builder.with(locale, value);
        }
        return builder.build();
    }

    @Section(name="bootstrapper.portalSection.name", description="bootstrapper.portalSection.description", bundle="resources.BennuPortalResources")
    public static interface PortalSection {
        @Field(name="bootstrapper.portalSection.installationName", defaultValue="FenixEdu Demo App", order=4)
        public String getApplicationTitle();

        @Field(name="bootstrapper.portalSection.organizationName", defaultValue="FenixEdu", order=3)
        public String getOrganizationName();

        @Field(name="bootstrapper.portalSection.documentationUrl", defaultValue="https://fenixedu.org/dev", order=5)
        public String getDocumentationUrl();

        @Field(name="bootstrapper.portalSection.loginUrl", defaultValue="/api/bennu-core/profile/login", order=6)
        public String getLoginPath();

        @Field(name="bootstrapper.portalSection.supportEmail", defaultValue="support@fenixedu.org", order=7)
        public String getSupportEmailAddress();
    }
}

