/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.portal.domain;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.portal.domain.MenuContainer;
import org.fenixedu.bennu.portal.domain.MenuFunctionality;
import org.fenixedu.bennu.portal.domain.MenuItem$callable$delete;
import org.fenixedu.bennu.portal.domain.MenuItem_Base;
import org.fenixedu.bennu.portal.domain.SupportConfiguration;
import org.fenixedu.commons.i18n.LocalizedString;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public abstract class MenuItem
extends MenuItem_Base
implements Comparable<MenuItem> {
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected MenuItem() {
        this.setOrd(1);
    }

    protected final void init(MenuContainer parent, boolean visible, String accessGroup, LocalizedString title, LocalizedString description, String path) {
        this.setVisible(visible);
        this.setAccessGroup(Group.parse((String)accessGroup));
        this.setDescription(description);
        this.setTitle(title);
        this.setPath(path);
        if (parent != null) {
            parent.addChild(this);
        }
        this.setFullPath(this.computeFullPath());
    }

    protected final void init(MenuContainer parent, MenuItem original) {
        this.setVisible(original.getVisible());
        this.setAccessGroup(original.getAccessGroup());
        this.setDescription(original.getDescription());
        this.setTitle(original.getTitle());
        this.setPath(original.getPath());
        this.setLayout(original.getLayout());
        if (parent != null) {
            parent.addChild(this);
        }
        this.setFullPath(this.computeFullPath());
    }

    public Group getAccessGroup() {
        return this.getGroup().toGroup();
    }

    public void setAccessGroup(Group group) {
        this.setGroup(group.toPersistentGroup());
    }

    private String computeFullPath() {
        StringBuilder builder = new StringBuilder();
        builder.append("/");
        builder.append(this.getPath());
        for (MenuContainer current = this.getParent(); current != null && current.getConfiguration() == null; current = current.getParent()) {
            builder.insert(0, current.getPath());
            builder.insert(0, "/");
        }
        return builder.toString();
    }

    @Override
    public int compareTo(MenuItem o) {
        int ord = this.getOrd().compareTo(o.getOrd());
        return ord == 0 ? this.getTitle().compareTo(o.getTitle()) : ord;
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new MenuItem$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(MenuItem this_) {
        this_.setParent(null);
        this_.setGroup(null);
        this_.setSupport(null);
        this_.deleteDomainObject();
    }

    public boolean isAvailable(User user) {
        return this.getGroup().isMember(user) && this.getParent().isAvailable(user);
    }

    public boolean isAvailableForCurrentUser() {
        return this.isAvailable(Authenticate.getUser());
    }

    protected boolean isItemAvailableForCurrentUser() {
        return this.getGroup().isMember(Authenticate.getUser());
    }

    public boolean isVisible() {
        return this.getVisible();
    }

    public MenuContainer getParent() {
        return super.getParent();
    }

    public String getPath() {
        return super.getPath();
    }

    public String getFullPath() {
        return super.getFullPath();
    }

    public boolean isMenuContainer() {
        return this instanceof MenuContainer;
    }

    public boolean isMenuFunctionality() {
        return this instanceof MenuFunctionality;
    }

    public MenuContainer getAsMenuContainer() {
        if (this.isMenuContainer()) {
            return (MenuContainer)((Object)this);
        }
        throw new IllegalStateException("Not a MenuContainer");
    }

    public MenuFunctionality getAsMenuFunctionality() {
        if (this.isMenuFunctionality()) {
            return (MenuFunctionality)((Object)this);
        }
        throw new IllegalStateException("Not a MenuFunctionality");
    }

    public List<MenuItem> getPathFromRoot() {
        ArrayList<MenuItem> result = new ArrayList<MenuItem>();
        Object current = this;
        while (current.getParent() != null) {
            result.add(0, (MenuItem)current);
            current = current.getParent();
        }
        return result;
    }

    protected abstract MenuItem moveTo(MenuContainer var1);

    public SupportConfiguration getSupport() {
        SupportConfiguration supportConfiguration = super.getSupport();
        if (supportConfiguration == null) {
            if (this.getParent() == null) {
                return null;
            }
            return this.getParent().getSupport();
        }
        return supportConfiguration;
    }
}

