/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.portal.api;

import com.google.gson.JsonElement;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Response;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.core.rest.BennuRestResource;
import org.fenixedu.bennu.core.util.CoreConfiguration;
import org.fenixedu.bennu.portal.domain.PortalConfiguration;

@Path(value="/bennu-portal/configuration")
public class PortalConfigurationResource
extends BennuRestResource {
    @GET
    @Produces(value={"application/json"})
    public JsonElement viewConfig() {
        this.accessControl((Group)Group.managers());
        return this.view((Object)PortalConfiguration.getInstance());
    }

    @GET
    @Path(value="logo")
    public Response logo(@HeaderParam(value="If-None-Match") String ifNoneMatch) {
        PortalConfiguration instance = PortalConfiguration.getInstance();
        if (instance != null && instance.getLogo() != null) {
            EntityTag etag = this.buildETag(instance);
            if (etag.toString().equals(ifNoneMatch)) {
                return Response.notModified((EntityTag)etag).build();
            }
            return Response.ok((Object)instance.getLogo(), (String)instance.getLogoType()).header("Cache-Control", (Object)CoreConfiguration.getConfiguration().staticCacheControl()).tag(etag).build();
        }
        throw new WebApplicationException(Response.Status.NOT_FOUND);
    }

    private EntityTag buildETag(PortalConfiguration instance) {
        return EntityTag.valueOf((String)("W/\"" + instance.getLogo().length + "-" + instance.getExternalId() + "\""));
    }

    @GET
    @Path(value="favicon")
    public Response favicon() {
        PortalConfiguration instance = PortalConfiguration.getInstance();
        if (instance != null && instance.getFavicon() != null) {
            return Response.ok((Object)instance.getFavicon(), (String)instance.getFaviconType()).header("Cache-Control", (Object)CoreConfiguration.getConfiguration().staticCacheControl()).build();
        }
        throw new WebApplicationException(Response.Status.NOT_FOUND);
    }

    @PUT
    @Path(value="{oid}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public JsonElement updateConfig(JsonElement jsonData, @PathParam(value="oid") String oid) {
        this.accessControl((Group)Group.managers());
        return this.view(this.update(jsonData, this.readDomainObject(oid)));
    }
}

