/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.alerts;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;

final class FlashMap
extends HashMap<String, Object>
implements Comparable<FlashMap> {
    private String targetRequestPath;
    private final Multimap<String, String> targetRequestParams = ArrayListMultimap.create();
    private long expirationTime = -1L;

    FlashMap() {
    }

    public void setTargetRequestPath(String path) {
        this.targetRequestPath = path;
    }

    public String getTargetRequestPath() {
        return this.targetRequestPath;
    }

    public FlashMap addTargetRequestParams(Multimap<String, String> params) {
        if (params != null) {
            for (String key : params.keySet()) {
                for (String value : params.get((Object)key)) {
                    this.addTargetRequestParam(key, value);
                }
            }
        }
        return this;
    }

    public FlashMap addTargetRequestParam(String name, String value) {
        if (!Strings.isNullOrEmpty((String)name) && !Strings.isNullOrEmpty((String)value)) {
            this.targetRequestParams.put((Object)name, (Object)value);
        }
        return this;
    }

    public Multimap<String, String> getTargetRequestParams() {
        return this.targetRequestParams;
    }

    public void startExpirationPeriod(int timeToLive) {
        this.expirationTime = System.currentTimeMillis() + (long)(timeToLive * 1000);
    }

    public void setExpirationTime(long expirationTime) {
        this.expirationTime = expirationTime;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public boolean isExpired() {
        return this.expirationTime != -1L && System.currentTimeMillis() > this.expirationTime;
    }

    @Override
    public int compareTo(FlashMap other) {
        int otherUrlPath;
        int thisUrlPath = this.targetRequestPath != null ? 1 : 0;
        int n = otherUrlPath = other.targetRequestPath != null ? 1 : 0;
        if (thisUrlPath != otherUrlPath) {
            return otherUrlPath - thisUrlPath;
        }
        return other.targetRequestParams.size() - this.targetRequestParams.size();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FlashMap)) {
            return false;
        }
        FlashMap otherFlashMap = (FlashMap)other;
        return super.equals(otherFlashMap) && Objects.equal((Object)this.targetRequestPath, (Object)otherFlashMap.targetRequestPath) && this.targetRequestParams.equals(otherFlashMap.targetRequestParams);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode((Object[])new Object[]{this.targetRequestPath});
        result = 31 * result + this.targetRequestParams.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "FlashMap [attributes=" + super.toString() + ", targetRequestPath=" + this.targetRequestPath + ", targetRequestParams=" + this.targetRequestParams + "]";
    }
}

