/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.alerts;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.fenixedu.bennu.alerts.AlertType;
import org.fenixedu.bennu.alerts.FlashMap;
import org.fenixedu.bennu.alerts.RedirectAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Alert {
    private static final Logger LOGGER = LoggerFactory.getLogger(Alert.class);
    private static final String ATTRIB_NAME = "__bennu-alerts__";
    private String message;
    private AlertType type;

    private Alert(String message, AlertType type) {
        this.setMessage(message);
        this.setType(type);
    }

    private static void alert(HttpServletRequest request, String message, AlertType type) {
        RedirectAttributes.initFromRequest(request);
        FlashMap attr = RedirectAttributes.getOutputFlashMap(request);
        Object o = attr.get(ATTRIB_NAME);
        if (o == null) {
            o = new ArrayList();
            attr.put(ATTRIB_NAME, o);
        }
        if (o instanceof ArrayList) {
            ((ArrayList)o).add(new Alert(message, type));
        } else {
            LOGGER.error("Can not add alert to list, object in attribute is not a ArrayList");
        }
    }

    public static void success(HttpServletRequest request, String message) {
        Alert.alert(request, message, AlertType.SUCCESS);
    }

    public static void info(HttpServletRequest request, String message) {
        Alert.alert(request, message, AlertType.INFO);
    }

    public static void danger(HttpServletRequest request, String message) {
        Alert.alert(request, message, AlertType.DANGER);
    }

    public static void warning(HttpServletRequest request, String message) {
        Alert.alert(request, message, AlertType.WARNING);
    }

    public static List<Alert> getAlerts(HttpServletRequest request, HttpServletResponse response) {
        ArrayList newAlerts;
        FlashMap map;
        ArrayList alerts = (ArrayList)RedirectAttributes.getInputFlashMap(request).get(ATTRIB_NAME);
        if (response.getStatus() == 200 && (map = RedirectAttributes.getOutputFlashMap(request)) != null && (newAlerts = (ArrayList)map.remove(ATTRIB_NAME)) != null) {
            if (alerts == null) {
                return newAlerts;
            }
            alerts.addAll(newAlerts);
        }
        return alerts;
    }

    public static JsonArray getAlertsAsJson(HttpServletRequest request, HttpServletResponse response) {
        List<Alert> alerts = Alert.getAlerts(request, response);
        if (alerts == null || alerts.isEmpty()) {
            return null;
        }
        JsonArray array = new JsonArray();
        for (Alert alert : alerts) {
            JsonObject o = new JsonObject();
            o.addProperty("message", alert.getMessage());
            o.addProperty("type", alert.getTag());
            array.add((JsonElement)o);
        }
        Alert.flush(request, response);
        return array;
    }

    public static void flush(HttpServletRequest request, HttpServletResponse response) {
        RedirectAttributes.flush(request, response);
    }

    public String getMessage() {
        return this.message;
    }

    private void setMessage(String message) {
        this.message = message;
    }

    public AlertType getType() {
        return this.type;
    }

    private void setType(AlertType type) {
        this.type = type;
    }

    public String getTag() {
        return this.getType().getTag();
    }
}

