/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.portal.servlet;

import com.google.common.base.Strings;
import com.mitchellbosecke.pebble.PebbleEngine;
import com.mitchellbosecke.pebble.error.LoaderException;
import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.extension.Extension;
import com.mitchellbosecke.pebble.loader.ClasspathLoader;
import com.mitchellbosecke.pebble.loader.Loader;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.fenixedu.bennu.core.util.CoreConfiguration;
import org.fenixedu.bennu.portal.BennuPortalConfiguration;
import org.fenixedu.bennu.portal.domain.PortalConfiguration;
import org.fenixedu.bennu.portal.login.LoginProvider;
import org.fenixedu.bennu.portal.servlet.PortalExtension;
import org.fenixedu.commons.i18n.I18N;

@WebServlet(value={"/login/*"})
public class PortalLoginServlet
extends HttpServlet {
    private static final long serialVersionUID = -4298321185506045304L;
    private PebbleEngine engine;
    private static final ConcurrentMap<String, LoginProvider> providers = new ConcurrentHashMap<String, LoginProvider>();

    public void init(ServletConfig config) throws ServletException {
        final ServletContext context = config.getServletContext();
        this.engine = new PebbleEngine.Builder().extension(new Extension[]{new PortalExtension(context)}).loader((Loader)new ClasspathLoader(){

            public Reader getReader(String themeName) throws LoaderException {
                InputStream stream = context.getResourceAsStream("/themes/" + themeName + "/login.html");
                if (stream != null) {
                    return new InputStreamReader(stream, StandardCharsets.UTF_8);
                }
                return new InputStreamReader(context.getResourceAsStream("/bennu-portal/login.html"), StandardCharsets.UTF_8);
            }
        }).cacheActive(BennuPortalConfiguration.getConfiguration().themeDevelopmentMode() == false).build();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String callback = req.getParameter("callback");
        if (!PortalLoginServlet.validateCallback(callback)) {
            resp.sendError(400, "Invalid callback URL");
            return;
        }
        boolean localLogin = CoreConfiguration.getConfiguration().localLoginEnabled();
        Collection<LoginProvider> providers = PortalLoginServlet.providers();
        if (!localLogin && providers.size() == 1) {
            providers.iterator().next().showLogin(req, resp, callback);
            return;
        }
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        PortalConfiguration config = PortalConfiguration.getInstance();
        ctx.put("config", (Object)config);
        ctx.put("callback", callback);
        ctx.put("url", req.getRequestURI());
        ctx.put("currentLocale", I18N.getLocale());
        ctx.put("contextPath", req.getContextPath());
        ctx.put("locales", CoreConfiguration.supportedLocales());
        ctx.put("providers", providers);
        ctx.put("localLogin", localLogin);
        ctx.put("loginPath", PortalConfiguration.getInstance().getLoginPath());
        try {
            resp.setContentType("text/html;charset=UTF-8");
            PebbleTemplate template = this.engine.getTemplate(config.getTheme());
            template.evaluate((Writer)resp.getWriter(), ctx, I18N.getLocale());
        }
        catch (PebbleException e) {
            throw new IOException(e);
        }
    }

    public static boolean validateCallback(String callback) {
        return Strings.isNullOrEmpty((String)callback) || callback.startsWith(CoreConfiguration.getConfiguration().applicationUrl());
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String callback = req.getParameter("callback");
        if (!PortalLoginServlet.validateCallback(callback)) {
            resp.sendError(400, "Invalid callback URL");
            return;
        }
        LoginProvider provider = this.providerFor(req.getPathInfo());
        if (provider == null) {
            resp.sendError(400, "Unrecognized Login Provider");
        } else {
            provider.showLogin(req, resp, callback);
        }
    }

    private LoginProvider providerFor(String pathInfo) {
        return pathInfo == null ? null : (LoginProvider)providers.get(pathInfo.replaceFirst("/", ""));
    }

    public void destroy() {
        this.engine = null;
    }

    public static void registerProvider(LoginProvider provider) {
        if (providers.containsKey(provider.getKey())) {
            throw new IllegalArgumentException("Another provider with key " + provider.getKey() + " already exists");
        }
        providers.put(provider.getKey(), provider);
    }

    private static Collection<LoginProvider> providers() {
        return providers.values().stream().filter(LoginProvider::isEnabled).collect(Collectors.toList());
    }
}

