/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.portal.servlet;

import com.google.common.hash.Funnels;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.hash.PrimitiveSink;
import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteStreams;
import com.mitchellbosecke.pebble.extension.AbstractExtension;
import com.mitchellbosecke.pebble.extension.Filter;
import com.mitchellbosecke.pebble.extension.Function;
import com.mitchellbosecke.pebble.extension.Test;
import com.mitchellbosecke.pebble.tokenParser.TokenParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.portal.servlet.LazyForTokenParser;
import pt.ist.fenixWebFramework.servlets.filters.contentRewrite.GenericChecksumRewriter;

class PortalExtension
extends AbstractExtension {
    private final ServletContext context;

    public PortalExtension(ServletContext context) {
        this.context = context;
    }

    public Map<String, Filter> getFilters() {
        HashMap<String, Filter> filters = new HashMap<String, Filter>();
        filters.put("base64", new Base64Filter());
        return filters;
    }

    public Map<String, Function> getFunctions() {
        HashMap<String, Function> functions = new HashMap<String, Function>();
        functions.put("i18n", new I18NFunction());
        functions.put("asset", new AssetFunction());
        functions.put("injectCheckSumInUrl", new InjectCheckSumInUrlFunction());
        return functions;
    }

    public Map<String, Test> getTests() {
        HashMap<String, Test> tests = new HashMap<String, Test>();
        tests.put("in", new InTest());
        return tests;
    }

    public List<TokenParser> getTokenParsers() {
        return Collections.singletonList(new LazyForTokenParser());
    }

    private static class InTest
    implements Test {
        private InTest() {
        }

        public List<String> getArgumentNames() {
            return Collections.singletonList("collection");
        }

        public boolean apply(Object input, Map<String, Object> args) {
            Collection collection = (Collection)args.get("collection");
            return collection.contains(input);
        }
    }

    private class AssetFunction
    implements Function {
        private final Map<String, String> pathMapping = new ConcurrentHashMap<String, String>();

        private AssetFunction() {
        }

        public List<String> getArgumentNames() {
            return Collections.singletonList("path");
        }

        public Object execute(Map<String, Object> args) {
            String path = (String)args.get("path");
            return this.pathMapping.computeIfAbsent(path, this::computePath);
        }

        private String computePath(String path) {
            String checksum;
            block14: {
                checksum = "_";
                try (InputStream stream = PortalExtension.this.context.getResourceAsStream(path);){
                    if (stream == null) break block14;
                    Hasher hasher = Hashing.sha1().newHasher();
                    try (OutputStream out = Funnels.asOutputStream((PrimitiveSink)hasher);){
                        ByteStreams.copy((InputStream)stream, (OutputStream)out);
                        checksum = hasher.hash().toString().substring(0, 12);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return PortalExtension.this.context.getContextPath() + path + "?v=" + checksum;
        }
    }

    private static class InjectCheckSumInUrlFunction
    implements Function {
        private InjectCheckSumInUrlFunction() {
        }

        public List<String> getArgumentNames() {
            ArrayList<String> names = new ArrayList<String>();
            names.add("contextPath");
            names.add("url");
            names.add("session");
            return names;
        }

        public Object execute(Map<String, Object> args) {
            String contextPath = (String)args.get("contextPath");
            String url = (String)args.get("url");
            HttpSession session = (HttpSession)args.get("session");
            return GenericChecksumRewriter.injectChecksumInUrl((String)contextPath, (String)url, (HttpSession)session);
        }
    }

    private static class I18NFunction
    implements Function {
        private I18NFunction() {
        }

        public List<String> getArgumentNames() {
            ArrayList<String> names = new ArrayList<String>();
            names.add("bundle");
            names.add("key");
            return names;
        }

        public Object execute(Map<String, Object> args) {
            String bundle = (String)args.get("bundle");
            String key = args.get("key").toString();
            return BundleUtil.getString((String)bundle, (String)key, (String[])new String[0]);
        }
    }

    private static class Base64Filter
    implements Filter {
        private Base64Filter() {
        }

        public List<String> getArgumentNames() {
            return null;
        }

        public Object apply(Object input, Map<String, Object> args) {
            if (input instanceof byte[]) {
                byte[] bytes = (byte[])input;
                return BaseEncoding.base64().encode(bytes);
            }
            return input;
        }
    }
}

