/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.portal.model;

import com.google.gson.JsonObject;
import org.fenixedu.commons.i18n.LocalizedString;

public final class Functionality
implements Comparable<Functionality> {
    private final String provider;
    private final String key;
    private final String path;
    private final String accessGroup;
    private final LocalizedString title;
    private final LocalizedString description;
    private final boolean visible;

    public Functionality(String provider, String key, String path, String accessGroup, LocalizedString title, LocalizedString description) {
        this(provider, key, path, accessGroup, title, description, true);
    }

    public Functionality(String provider, String key, String path, String accessGroup, LocalizedString title, LocalizedString description, boolean visible) {
        this.provider = provider;
        this.key = key;
        this.path = path;
        this.accessGroup = accessGroup;
        this.title = title;
        this.description = description;
        this.visible = visible;
    }

    public String getProvider() {
        return this.provider;
    }

    public String getKey() {
        return this.key;
    }

    public String getPath() {
        return this.path;
    }

    public String getAccessGroup() {
        return this.accessGroup;
    }

    public LocalizedString getTitle() {
        return this.title;
    }

    public LocalizedString getDescription() {
        return this.description;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public JsonObject json() {
        JsonObject obj = new JsonObject();
        obj.addProperty("path", this.path);
        obj.addProperty("accessGroup", this.accessGroup);
        obj.addProperty("key", this.key);
        obj.add("title", this.title.json());
        obj.add("description", this.description.json());
        obj.addProperty("provider", this.provider);
        return obj;
    }

    public String toString() {
        return this.json().toString();
    }

    @Override
    public int compareTo(Functionality other) {
        if (!this.visible && other.visible) {
            return -1;
        }
        if (this.visible && !other.visible) {
            return 1;
        }
        int compareTo = this.title.compareTo(other.title);
        if (compareTo != 0) {
            return compareTo;
        }
        return this.path.compareTo(other.path);
    }
}

