/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.oauth.util;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.hash.Hashing;
import com.google.gson.JsonObject;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Optional;
import java.util.UUID;
import org.fenixedu.bennu.oauth.OAuthProperties;
import org.fenixedu.bennu.oauth.domain.ApplicationUserSession;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.FenixFramework;

public class OAuthUtils {
    public static final String ACCESS_TOKEN = "access_token";
    public static final String STANDARD_ACCESS_TOKEN = "token";
    public static final String REFRESH_TOKEN = "refresh_token";
    public static final String EXPIRES_IN = "expires_in";
    public static final String TOKEN_TYPE = "token_type";
    public static final String TOKEN_TYPE_HEADER_ACCESS_TOKEN = "Bearer";
    public static final String USER_DIALOG = "userdialog";
    public static final String STANDARD_USER_DIALOG = "authorize";
    public static final String USER_CONFIRMATION = "userconfirmation";

    public static String generateCode() {
        return Hashing.sha512().hashString((CharSequence)UUID.randomUUID().toString(), StandardCharsets.UTF_8).toString();
    }

    public static String generateToken(DomainObject domainObject) {
        return OAuthUtils.generateToken(domainObject.getExternalId(), OAuthUtils.generateCode());
    }

    public static String generateToken(String id, String random) {
        return Base64.getEncoder().encodeToString(Joiner.on((String)":").join((Object)id, (Object)random, new Object[0]).getBytes(StandardCharsets.UTF_8)).replace("=", "").replace("+", "-").replace("/", "-");
    }

    public static JsonObject getJsonTokens(ApplicationUserSession appUserSession) {
        return OAuthUtils.getJsonTokens(appUserSession.getAccessToken(), appUserSession.getRefreshToken());
    }

    public static JsonObject getJsonTokens(String accessToken) {
        return OAuthUtils.getJsonTokens(accessToken, null, null, null);
    }

    public static JsonObject getJsonTokens(String accessToken, String refreshToken) {
        return OAuthUtils.getJsonTokens(accessToken, refreshToken, OAuthProperties.getConfiguration().getAccessTokenExpirationSeconds(), TOKEN_TYPE_HEADER_ACCESS_TOKEN);
    }

    public static JsonObject getJsonTokens(String accessToken, String refreshToken, Integer accessTokenExpirationSeconds, String tokenType) {
        JsonObject jsonResponse = new JsonObject();
        jsonResponse.addProperty(ACCESS_TOKEN, accessToken);
        if (!Strings.isNullOrEmpty((String)refreshToken)) {
            jsonResponse.addProperty(REFRESH_TOKEN, refreshToken);
        }
        if (accessTokenExpirationSeconds != null) {
            jsonResponse.addProperty(EXPIRES_IN, (Number)accessTokenExpirationSeconds);
        }
        if (!Strings.isNullOrEmpty((String)tokenType)) {
            jsonResponse.addProperty(TOKEN_TYPE, tokenType);
        }
        return jsonResponse;
    }

    public static final <T extends DomainObject> Optional<T> getDomainObject(String externalId) {
        return OAuthUtils.getDomainObject(externalId, null);
    }

    public static final <T extends DomainObject> Optional<T> getDomainObject(String externalId, Class<T> clazz) {
        try {
            DomainObject domainObject = FenixFramework.getDomainObject((String)externalId);
            if (!FenixFramework.isDomainObjectValid((DomainObject)domainObject) || clazz != null && !clazz.isAssignableFrom(domainObject.getClass())) {
                return Optional.empty();
            }
            return Optional.of(domainObject);
        }
        catch (Exception nfe) {
            return Optional.empty();
        }
    }
}

