/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.oauth.domain;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Sets;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.oauth.domain.ApplicationUserAuthorization;
import org.fenixedu.bennu.oauth.domain.ApplicationUserSession;
import org.fenixedu.bennu.oauth.domain.ExternalApplication$callable$setState;
import org.fenixedu.bennu.oauth.domain.ExternalApplicationScope;
import org.fenixedu.bennu.oauth.domain.ExternalApplicationState;
import org.fenixedu.bennu.oauth.domain.ExternalApplication_Base;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class ExternalApplication
extends ExternalApplication_Base {
    private static final Logger logger;
    public static final Advice advice$setState;

    public ExternalApplication() {
        this.init();
    }

    protected void init() {
        this.setBennu(Bennu.getInstance());
        this.setSecret(Base64.getEncoder().encodeToString(Hashing.sha512().hashBytes(UUID.randomUUID().toString().getBytes(StandardCharsets.UTF_8)).asBytes()));
        this.setState(ExternalApplicationState.ACTIVE);
    }

    public void setScopeList(List<ExternalApplicationScope> newScopes) {
        Set oldScopes = this.getScopesSet();
        Sets.SetView result = Sets.difference((Set)Sets.newHashSet(newScopes), (Set)Sets.newHashSet((Iterable)oldScopes));
        if (result.size() > 0) {
            this.deleteAuthorizations();
        }
        oldScopes.clear();
        oldScopes.addAll(newScopes);
    }

    public void removeScope(ExternalApplicationScope scope) {
        List<ExternalApplicationScope> oldScopes = this.getScopeList();
        if (oldScopes.contains((Object)scope)) {
            oldScopes.remove((Object)scope);
            this.setScopeList(oldScopes);
        }
    }

    public List<ExternalApplicationScope> getScopeList() {
        return new ArrayList<ExternalApplicationScope>(this.getScopesSet());
    }

    public boolean matchesUrl(String redirectUrl) {
        return !Strings.isNullOrEmpty((String)redirectUrl) && Arrays.asList(this.getRedirectUrl().split("\\|")).contains(redirectUrl);
    }

    public boolean matchesSecret(String secret) {
        return !Strings.isNullOrEmpty((String)secret) && secret.equals(this.getSecret());
    }

    public boolean matches(String redirectUrl, String secret) {
        return this.matchesUrl(redirectUrl) && this.matchesSecret(secret);
    }

    public ApplicationUserSession getApplicationUserSession(String code) {
        for (ApplicationUserSession applicationUserSession : this.getApplicationUserSessionSet()) {
            if (!applicationUserSession.matchesCode(code)) continue;
            return applicationUserSession;
        }
        return null;
    }

    public void deleteAuthorizations() {
        for (ApplicationUserAuthorization authorization : new HashSet(this.getApplicationUserAuthorizationSet())) {
            authorization.delete();
        }
    }

    private Set<ApplicationUserSession> getApplicationUserSessionSet() {
        return FluentIterable.from((Iterable)this.getApplicationUserAuthorizationSet()).transformAndConcat((Function)new Function<ApplicationUserAuthorization, Iterable<ApplicationUserSession>>(){

            public Iterable<ApplicationUserSession> apply(ApplicationUserAuthorization auth) {
                return auth.getSessionSet();
            }
        }).toSet();
    }

    public InputStream getLogoStream() {
        return null;
    }

    public String getAuthorApplicationName() {
        String name = this.getAuthorName();
        if (!Strings.isNullOrEmpty((String)name)) {
            return name;
        }
        return this.getAuthor().getDisplayName();
    }

    public void setLogoStream(InputStream stream) {
        try {
            byte[] byteArray;
            if (stream != null && (byteArray = ByteStreams.toByteArray((InputStream)stream)).length > 0) {
                this.setLogo(byteArray);
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public Optional<ApplicationUserAuthorization> getApplicationUserAuthorization(User user) {
        return this.getApplicationUserAuthorizationSet().stream().filter(auth -> auth.getUser().equals((Object)user)).findAny();
    }

    public ExternalApplicationState getState() {
        ExternalApplicationState state = super.getState();
        if (state == null) {
            this.setState(ExternalApplicationState.ACTIVE);
        }
        return super.getState();
    }

    public boolean hasApplicationUserAuthorization(User user) {
        return this.getApplicationUserAuthorization(user).isPresent();
    }

    public boolean isActive() {
        return this.getState().equals((Object)ExternalApplicationState.ACTIVE);
    }

    public boolean isBanned() {
        return this.getState().equals((Object)ExternalApplicationState.BANNED);
    }

    public boolean isDeleted() {
        return this.getState().equals((Object)ExternalApplicationState.DELETED);
    }

    public boolean isEditable() {
        return this.isActive() || this.isBanned();
    }

    public void setState(ExternalApplicationState externalApplicationState) {
        Object object = advice$setState.perform((Callable)new ExternalApplication$callable$setState(this, externalApplicationState));
    }

    static /* synthetic */ void advised$setState(ExternalApplication this_, ExternalApplicationState state) {
        super.setState(state);
    }

    public void setActive() {
        this.setState(ExternalApplicationState.ACTIVE);
    }

    public void setBanned() {
        this.setState(ExternalApplicationState.BANNED);
    }

    public void setDeleted() {
        this.setState(ExternalApplicationState.DELETED);
    }

    public String getSecret() {
        return super.getSecret();
    }

    static {
        advice$setState = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        logger = LoggerFactory.getLogger(ExternalApplication.class);
    }
}

