/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.oauth.domain;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.exceptions.BennuCoreDomainException;
import org.fenixedu.bennu.oauth.domain.ExternalApplicationScope_Base;

public class ExternalApplicationScope
extends ExternalApplicationScope_Base {
    public ExternalApplicationScope() {
        this.setBennu(Bennu.getInstance());
    }

    public void setScopeKey(String scopeKey) {
        if (Strings.isNullOrEmpty((String)scopeKey)) {
            throw BennuCoreDomainException.cannotCreateEntity();
        }
        Optional<ExternalApplicationScope> scopeForKey = ExternalApplicationScope.forKey(scopeKey);
        if (scopeForKey.isPresent() && !scopeForKey.get().equals((Object)this)) {
            throw BennuCoreDomainException.cannotCreateEntity();
        }
        super.setScopeKey(scopeKey);
    }

    public static Optional<ExternalApplicationScope> forKey(String ... key) {
        List<String> keys = Arrays.asList(key);
        return Bennu.getInstance().getScopesSet().stream().filter(scope -> keys.contains(scope.getScopeKey())).findAny();
    }
}

