/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.oauth.api.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.fenixedu.bennu.core.annotation.DefaultJsonAdapter;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.domain.exceptions.BennuCoreDomainException;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.core.json.JsonAdapter;
import org.fenixedu.bennu.core.json.JsonBuilder;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.core.util.CoreConfiguration;
import org.fenixedu.bennu.oauth.domain.ExternalApplication;
import org.fenixedu.bennu.oauth.domain.ExternalApplicationScope;
import pt.ist.fenixframework.FenixFramework;

@DefaultJsonAdapter(value=ExternalApplication.class)
public class ExternalApplicationAdapter
implements JsonAdapter<ExternalApplication> {
    protected boolean isManager(User user) {
        return Group.managers().isMember(user);
    }

    protected ExternalApplication create(JsonElement json) {
        ExternalApplication app = new ExternalApplication();
        app.setAuthor(Authenticate.getUser());
        return app;
    }

    public ExternalApplication create(JsonElement json, JsonBuilder ctx) {
        JsonObject jObj = json.getAsJsonObject();
        ExternalApplication app = this.create(json);
        app.setName(this.getRequiredValue(jObj, "name"));
        app.setDescription(this.getRequiredValue(jObj, "description"));
        app.setRedirectUrl(this.getRedirectUrl(jObj));
        app.setSiteUrl(this.getDefaultValue(jObj, "siteUrl", ""));
        if (jObj.has("logo") && !jObj.get("logo").isJsonNull()) {
            app.setLogo(jObj.get("logo").getAsString().getBytes(Charset.forName("UTF-8")));
        }
        if (jObj.has("scopes") && !jObj.get("scopes").isJsonNull()) {
            JsonArray jArr = jObj.get("scopes").getAsJsonArray();
            for (int i = 0; i < jArr.size(); ++i) {
                JsonObject scopeJsonObject = jArr.get(i).getAsJsonObject();
                String oid = scopeJsonObject.get("id").getAsString();
                ExternalApplicationScope scope = (ExternalApplicationScope)FenixFramework.getDomainObject((String)oid);
                if (scope.getService().booleanValue()) {
                    if (!this.isManager(Authenticate.getUser())) continue;
                    app.addScopes(scope);
                    continue;
                }
                app.addScopes(scope);
            }
        }
        return app;
    }

    protected String getRedirectUrl(JsonObject jObj) {
        return this.getRequiredValue(jObj, "redirectUrl");
    }

    public ExternalApplication update(JsonElement json, ExternalApplication app, JsonBuilder ctx) {
        JsonObject jObj = json.getAsJsonObject();
        app.setName(this.getRequiredValue(jObj, "name"));
        app.setDescription(this.getRequiredValue(jObj, "description"));
        app.setRedirectUrl(this.getRedirectUrl(jObj));
        app.setSiteUrl(this.getDefaultValue(jObj, "siteUrl", ""));
        if (jObj.has("logo") && !jObj.get("logo").isJsonNull()) {
            app.setLogo(jObj.get("logo").getAsString().getBytes(Charset.forName("UTF-8")));
        }
        if (jObj.has("scopes") && !jObj.get("scopes").isJsonNull()) {
            ArrayList<ExternalApplicationScope> newScopes = new ArrayList<ExternalApplicationScope>();
            JsonArray jArr = jObj.get("scopes").getAsJsonArray();
            for (int i = 0; i < jArr.size(); ++i) {
                JsonObject scopeJsonObject = jArr.get(i).getAsJsonObject();
                String oid = scopeJsonObject.get("id").getAsString();
                ExternalApplicationScope scope = (ExternalApplicationScope)FenixFramework.getDomainObject((String)oid);
                if (scope.getService().booleanValue()) {
                    if (!this.isManager(Authenticate.getUser())) continue;
                    newScopes.add(scope);
                    continue;
                }
                newScopes.add(scope);
            }
            app.setScopeList(newScopes);
        } else {
            app.setScopeList(new ArrayList<ExternalApplicationScope>());
        }
        return app;
    }

    public JsonElement view(ExternalApplication obj, JsonBuilder ctx) {
        JsonObject json = new JsonObject();
        json.addProperty("id", obj.getExternalId());
        json.addProperty("name", obj.getName());
        json.addProperty("description", obj.getDescription());
        json.addProperty("siteUrl", obj.getSiteUrl());
        json.addProperty("active", Boolean.valueOf(obj.isActive()));
        json.addProperty("state", obj.getState().getName());
        json.addProperty("secret", obj.getSecret());
        json.addProperty("redirectUrl", obj.getRedirectUrl());
        json.addProperty("author", obj.getAuthorApplicationName());
        json.addProperty("authorizations", (Number)obj.getApplicationUserAuthorizationSet().size());
        json.add("scopes", ctx.view((Object)obj.getScopesSet()));
        String logoUrl = CoreConfiguration.getConfiguration().applicationUrl() + "/api/bennu-oauth/applications/" + obj.getExternalId() + "/logo";
        json.addProperty("logoUrl", logoUrl);
        return json;
    }

    protected String getRequiredValue(JsonObject obj, String property) {
        if (obj.has(property)) {
            return obj.get(property).getAsString();
        }
        throw BennuCoreDomainException.cannotCreateEntity();
    }

    protected String getDefaultValue(JsonObject obj, String property, String defaultValue) {
        if (obj.has(property)) {
            return obj.get(property).getAsString();
        }
        return defaultValue;
    }
}

