/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.oauth.servlets;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.gson.JsonObject;
import com.mitchellbosecke.pebble.PebbleEngine;
import com.mitchellbosecke.pebble.error.LoaderException;
import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.extension.AbstractExtension;
import com.mitchellbosecke.pebble.extension.Extension;
import com.mitchellbosecke.pebble.extension.Function;
import com.mitchellbosecke.pebble.loader.ClasspathLoader;
import com.mitchellbosecke.pebble.loader.Loader;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.core.util.CoreConfiguration;
import org.fenixedu.bennu.oauth.OAuthProperties;
import org.fenixedu.bennu.oauth.domain.ApplicationUserAuthorization;
import org.fenixedu.bennu.oauth.domain.ApplicationUserSession;
import org.fenixedu.bennu.oauth.domain.ExternalApplication;
import org.fenixedu.bennu.oauth.domain.ServiceApplication;
import org.fenixedu.bennu.oauth.servlets.OAuthAuthorizationServlet$callable$createAppUserSession;
import org.fenixedu.bennu.oauth.util.OAuthUtils;
import org.fenixedu.bennu.portal.BennuPortalConfiguration;
import org.fenixedu.bennu.portal.domain.PortalConfiguration;
import org.fenixedu.commons.i18n.I18N;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@WebServlet(value={"/oauth/*"})
public class OAuthAuthorizationServlet
extends HttpServlet {
    private static final String GRANT_TYPE_CLIENT_CREDENTIALS = "client_credentials";
    private static final String GRANT_TYPE_AUTHORIZATION_CODE = "authorization_code";
    private static final String CODE_EXPIRED = "code expired";
    private static final String CODE_INVALID = "code invalid";
    private static final long serialVersionUID = 1L;
    private static final String OAUTH_SESSION_KEY = "OAUTH_CLIENT_ID";
    private static final String CLIENT_ID = "client_id";
    private static final String CLIENT_SECRET = "client_secret";
    private static final String REDIRECT_URI = "redirect_uri";
    private static final String CODE = "code";
    private static final String CSRF_HEADER = "X-CSRF-Token";
    private static final String ACCESS_TOKEN = "access_token";
    private static final String REFRESH_TOKEN = "refresh_token";
    private static final String GRANT_TYPE = "grant_type";
    private static final String DEVICE_ID = "device_id";
    private static final String STATE = "state";
    private static final String EXPIRES_IN = "expires_in";
    private static final String TOKEN_TYPE = "token_type";
    private static final String TOKEN_TYPE_VALUE = "Bearer";
    private static final String INVALID_GRANT = "invalid_grant";
    private static final String REFRESH_TOKEN_DOESN_T_MATCH = "refresh token doesn't match";
    private static final String CREDENTIALS_OR_REDIRECT_URI_DON_T_MATCH = "credentials or redirect_uri don't match";
    private static final String REFRESH_TOKEN_NOT_RECOGNIZED = "refresh token not recognized.";
    private static final String REFRESH_TOKEN_INVALID = "refreshTokenInvalid";
    private static final String REFRESH_TOKEN_INVALID_FORMAT = "refreshTokenInvalidFormat";
    private static final String CLIENT_ID_NOT_FOUND = "client_id not found";
    private static final String APPLICATION_BANNED = "the application has been banned.";
    private static final String APPLICATION_DELETED = "the application has been deleted.";
    private static final String NO_CSRF_HEADER = "The request don't has a CSRF header.";
    private static final String NO_CSRF_HEADER_DESCRIPTION = "To make this request the browser need to send a CSRF header.";
    private PebbleEngine engine;
    public static final Advice advice$createAppUserSession = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public void init(final ServletConfig config) throws ServletException {
        super.init(config);
        this.engine = new PebbleEngine.Builder().loader((Loader)new ClasspathLoader(){

            public Reader getReader(String pageName) throws LoaderException {
                InputStream stream = config.getServletContext().getResourceAsStream("/themes/" + PortalConfiguration.getInstance().getTheme() + "/oauth/" + pageName + ".html");
                if (stream != null) {
                    return new InputStreamReader(stream, StandardCharsets.UTF_8);
                }
                return new InputStreamReader(config.getServletContext().getResourceAsStream("/bennu-oauth/" + pageName + ".html"), StandardCharsets.UTF_8);
            }
        }).cacheActive(BennuPortalConfiguration.getConfiguration().themeDevelopmentMode() == false).extension(new Extension[]{new AbstractExtension(){

            public Map<String, Function> getFunctions() {
                HashMap<String, Function> functions = new HashMap<String, Function>();
                functions.put("i18n", new I18NFunction());
                return functions;
            }
        }}).build();
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String path;
        if (Strings.isNullOrEmpty((String)request.getPathInfo())) {
            response.sendError(404);
            return;
        }
        switch (path = this.trim(request.getPathInfo())) {
            case "userdialog": 
            case "authorize": {
                this.handleUserDialog(request, response, path);
                break;
            }
            case "userconfirmation": {
                if (!"POST".equals(request.getMethod())) {
                    response.sendError(405);
                    return;
                }
                this.userConfirmation(request, response);
                break;
            }
            case "access_token": 
            case "token": {
                if (!"POST".equals(request.getMethod())) {
                    response.sendError(405);
                    return;
                }
                this.handleAccessToken(request, response);
                break;
            }
            case "refresh_token": {
                if (!"POST".equals(request.getMethod())) {
                    response.sendError(405);
                    return;
                }
                this.handleRefreshToken(request, response);
                break;
            }
            default: {
                response.sendError(404);
            }
        }
    }

    private void handleRefreshToken(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String refreshTokenDecoded;
        String clientSecret;
        String clientId;
        String[] authorizationHeader = this.getAuthorizationHeader(request);
        if (authorizationHeader == null) {
            clientId = request.getParameter(CLIENT_ID);
            clientSecret = request.getParameter(CLIENT_SECRET);
        } else {
            clientId = authorizationHeader[0];
            clientSecret = authorizationHeader[1];
        }
        String refreshToken = request.getParameter(REFRESH_TOKEN);
        ExternalApplication externalApplication = OAuthUtils.getDomainObject(clientId, ExternalApplication.class).orElse(null);
        if (externalApplication == null) {
            this.sendOAuthErrorResponse(response, Response.Status.BAD_REQUEST, INVALID_GRANT, CLIENT_ID_NOT_FOUND);
            return;
        }
        if (!this.isValidApplication(response, externalApplication)) {
            return;
        }
        if (Strings.isNullOrEmpty((String)refreshToken)) {
            this.sendOAuthErrorResponse(response, Response.Status.UNAUTHORIZED, REFRESH_TOKEN_INVALID_FORMAT, REFRESH_TOKEN_NOT_RECOGNIZED);
            return;
        }
        try {
            refreshTokenDecoded = new String(Base64.getDecoder().decode(refreshToken), StandardCharsets.UTF_8);
        }
        catch (IllegalArgumentException iae) {
            this.sendOAuthErrorResponse(response, Response.Status.UNAUTHORIZED, REFRESH_TOKEN_INVALID_FORMAT, REFRESH_TOKEN_NOT_RECOGNIZED);
            return;
        }
        String[] refreshTokenBuilder = refreshTokenDecoded.split(":");
        if (refreshTokenBuilder.length != 2) {
            this.sendOAuthErrorResponse(response, Response.Status.UNAUTHORIZED, REFRESH_TOKEN_INVALID_FORMAT, REFRESH_TOKEN_NOT_RECOGNIZED);
            return;
        }
        String appUserSessionExternalId = refreshTokenBuilder[0];
        ApplicationUserSession appUserSession = (ApplicationUserSession)FenixFramework.getDomainObject((String)appUserSessionExternalId);
        if (!externalApplication.matchesSecret(clientSecret)) {
            this.sendOAuthErrorResponse(response, Response.Status.UNAUTHORIZED, INVALID_GRANT, CREDENTIALS_OR_REDIRECT_URI_DON_T_MATCH);
            return;
        }
        if (!FenixFramework.isDomainObjectValid((DomainObject)appUserSession) || !appUserSession.matchesRefreshToken(refreshToken)) {
            this.sendOAuthErrorResponse(response, Response.Status.UNAUTHORIZED, REFRESH_TOKEN_INVALID, REFRESH_TOKEN_DOESN_T_MATCH);
            return;
        }
        if (appUserSession.getApplicationUserAuthorization().getUser().isLoginExpired()) {
            this.sendOAuthErrorResponse(response, Response.Status.BAD_REQUEST, REFRESH_TOKEN_INVALID_FORMAT, REFRESH_TOKEN_NOT_RECOGNIZED);
            return;
        }
        String newAccessToken = OAuthUtils.generateToken((DomainObject)appUserSession);
        appUserSession.setNewAccessToken(newAccessToken);
        JsonObject jsonResponse = new JsonObject();
        jsonResponse.addProperty(ACCESS_TOKEN, newAccessToken);
        jsonResponse.addProperty(REFRESH_TOKEN, refreshToken);
        jsonResponse.addProperty(TOKEN_TYPE, TOKEN_TYPE_VALUE);
        jsonResponse.addProperty(EXPIRES_IN, (Number)OAuthProperties.getConfiguration().getAccessTokenExpirationSeconds());
        this.sendOAuthResponse(response, Response.Status.OK, jsonResponse);
    }

    private String[] getAuthorizationHeader(HttpServletRequest request) {
        String authorization = request.getHeader("Authorization");
        if (authorization != null && authorization.startsWith("Basic")) {
            String[] values;
            String base64Credentials = authorization.substring("Basic".length()).trim();
            try {
                String credentials = new String(Base64.getDecoder().decode(base64Credentials), Charset.forName("UTF-8"));
                values = credentials.split(":", 2);
            }
            catch (IllegalArgumentException iae) {
                return null;
            }
            return values.length != 2 ? null : values;
        }
        return null;
    }

    private void handleAccessToken(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String clientSecret;
        String clientId;
        String[] authorizationHeader = this.getAuthorizationHeader(request);
        if (authorizationHeader == null) {
            clientId = request.getParameter(CLIENT_ID);
            clientSecret = request.getParameter(CLIENT_SECRET);
        } else {
            clientId = authorizationHeader[0];
            clientSecret = authorizationHeader[1];
        }
        String redirectUrl = request.getParameter(REDIRECT_URI);
        String authCode = request.getParameter(CODE);
        String grantType = request.getParameter(GRANT_TYPE);
        if (Strings.isNullOrEmpty((String)clientId) || Strings.isNullOrEmpty((String)clientSecret) || Strings.isNullOrEmpty((String)grantType)) {
            this.sendOAuthErrorResponse(response, Response.Status.BAD_REQUEST, INVALID_GRANT, Joiner.on((String)",").join((Object)CLIENT_ID, (Object)CLIENT_SECRET, new Object[]{GRANT_TYPE}) + " are mandatory");
            return;
        }
        if (!GRANT_TYPE_AUTHORIZATION_CODE.equals(grantType) && !GRANT_TYPE_CLIENT_CREDENTIALS.equals(grantType)) {
            this.sendOAuthErrorResponse(response, Response.Status.BAD_REQUEST, INVALID_GRANT, "grant_type must be on of the following values: " + Joiner.on((String)",").join((Object)GRANT_TYPE_CLIENT_CREDENTIALS, (Object)GRANT_TYPE_AUTHORIZATION_CODE, new Object[0]));
            return;
        }
        if (GRANT_TYPE_AUTHORIZATION_CODE.equals(grantType) && (Strings.isNullOrEmpty((String)redirectUrl) || Strings.isNullOrEmpty((String)authCode))) {
            this.sendOAuthErrorResponse(response, Response.Status.BAD_REQUEST, INVALID_GRANT, Joiner.on((String)",").join((Object)REDIRECT_URI, (Object)CODE, new Object[0]) + " are mandatory");
            return;
        }
        ExternalApplication externalApplication = OAuthUtils.getDomainObject(clientId, ExternalApplication.class).orElse(null);
        if (externalApplication == null) {
            this.sendOAuthErrorResponse(response, Response.Status.BAD_REQUEST, INVALID_GRANT, CLIENT_ID_NOT_FOUND);
            return;
        }
        if (externalApplication instanceof ServiceApplication && !GRANT_TYPE_CLIENT_CREDENTIALS.equals(grantType)) {
            this.sendOAuthErrorResponse(response, Response.Status.BAD_REQUEST, INVALID_GRANT, CLIENT_ID_NOT_FOUND);
            return;
        }
        if (!this.isValidApplication(response, externalApplication)) {
            return;
        }
        if (!externalApplication.matches(redirectUrl, clientSecret)) {
            this.sendOAuthErrorResponse(response, Response.Status.BAD_REQUEST, INVALID_GRANT, CREDENTIALS_OR_REDIRECT_URI_DON_T_MATCH);
            return;
        }
        if (externalApplication instanceof ServiceApplication) {
            String accessToken = OAuthUtils.generateToken((DomainObject)externalApplication);
            ((ServiceApplication)((Object)externalApplication)).createServiceAuthorization(accessToken);
            JsonObject jsonResponse = new JsonObject();
            jsonResponse.addProperty(ACCESS_TOKEN, accessToken);
            this.sendOAuthResponse(response, Response.Status.OK, jsonResponse);
            return;
        }
        ApplicationUserSession appUserSession = externalApplication.getApplicationUserSession(authCode);
        if (appUserSession == null) {
            this.sendOAuthErrorResponse(response, Response.Status.BAD_REQUEST, INVALID_GRANT, CODE_INVALID);
            return;
        }
        if (appUserSession.getApplicationUserAuthorization().getUser().isLoginExpired()) {
            this.sendOAuthErrorResponse(response, Response.Status.BAD_REQUEST, INVALID_GRANT, CODE_EXPIRED);
            return;
        }
        if (appUserSession.isCodeValid()) {
            String accessToken = OAuthUtils.generateToken((DomainObject)appUserSession);
            String refreshToken = OAuthUtils.generateToken((DomainObject)appUserSession);
            appUserSession.setTokens(accessToken, refreshToken);
            JsonObject jsonResponse = new JsonObject();
            jsonResponse.addProperty(ACCESS_TOKEN, accessToken);
            jsonResponse.addProperty(REFRESH_TOKEN, refreshToken);
            jsonResponse.addProperty(TOKEN_TYPE, TOKEN_TYPE_VALUE);
            jsonResponse.addProperty(EXPIRES_IN, (Number)OAuthProperties.getConfiguration().getAccessTokenExpirationSeconds());
            this.sendOAuthResponse(response, Response.Status.OK, jsonResponse);
        } else {
            this.sendOAuthErrorResponse(response, Response.Status.BAD_REQUEST, INVALID_GRANT, CODE_EXPIRED);
        }
    }

    private void handleUserDialog(HttpServletRequest request, HttpServletResponse response, String path) throws IOException {
        String clientId = request.getParameter(CLIENT_ID);
        String redirectUrl = request.getParameter(REDIRECT_URI);
        String originalState = request.getParameter(STATE);
        User user = Authenticate.getUser();
        if (!Strings.isNullOrEmpty((String)clientId) && !Strings.isNullOrEmpty((String)redirectUrl)) {
            if (user == null) {
                String cookieValue = clientId + "|" + redirectUrl;
                if (originalState != null) {
                    cookieValue = cookieValue + "|" + Base64.getEncoder().encodeToString(originalState.getBytes(StandardCharsets.UTF_8));
                }
                response.addCookie(new Cookie(OAUTH_SESSION_KEY, Base64.getEncoder().encodeToString(cookieValue.getBytes(StandardCharsets.UTF_8))));
                response.sendRedirect(request.getContextPath() + "/login?callback=" + CoreConfiguration.getConfiguration().applicationUrl() + "/oauth/" + path);
                return;
            }
            this.redirectToRedirectUrl(request, response, user, clientId, redirectUrl, originalState);
            return;
        }
        if (user != null) {
            Cookie cookie = OAuthAuthorizationServlet.getOAuthSessionCookie(request);
            if (cookie == null) {
                this.errorPage(request, response);
                return;
            }
            String sessionClientId = cookie.getValue();
            if (!Strings.isNullOrEmpty((String)sessionClientId)) {
                this.redirectToRedirectUrl(request, response, user, cookie);
                return;
            }
        }
        this.errorPage(request, response);
    }

    private static Cookie getOAuthSessionCookie(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equalsIgnoreCase(OAUTH_SESSION_KEY)) continue;
                return cookie;
            }
        }
        return null;
    }

    private void errorPage(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        PortalConfiguration config = PortalConfiguration.getInstance();
        ctx.put("config", config);
        ctx.put("currentLocale", I18N.getLocale());
        ctx.put("contextPath", request.getContextPath());
        ctx.put("locales", CoreConfiguration.supportedLocales());
        try {
            response.setContentType("text/html;charset=UTF-8");
            PebbleTemplate template = this.engine.getTemplate("error-page");
            template.evaluate((Writer)response.getWriter(), ctx, I18N.getLocale());
        }
        catch (PebbleException e) {
            throw new IOException(e);
        }
    }

    private void authorizationPage(HttpServletRequest request, HttpServletResponse response, ExternalApplication clientApplication, String redirectUrl, String state) throws IOException {
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        PortalConfiguration config = PortalConfiguration.getInstance();
        ctx.put("config", config);
        ctx.put("app", (Object)clientApplication);
        ctx.put("currentLocale", I18N.getLocale());
        ctx.put("contextPath", request.getContextPath());
        ctx.put("locales", CoreConfiguration.supportedLocales());
        ctx.put("loggedUser", Authenticate.getUser());
        ctx.put(STATE, state);
        ctx.put("redirectUrl", redirectUrl);
        try {
            response.setContentType("text/html;charset=UTF-8");
            PebbleTemplate template = this.engine.getTemplate("auth-page");
            template.evaluate((Writer)response.getWriter(), ctx, I18N.getLocale());
        }
        catch (PebbleException e) {
            throw new IOException(e);
        }
    }

    private void redirectToRedirectUrl(HttpServletRequest request, HttpServletResponse response, User user, Cookie cookie) throws IOException {
        String cookieValue = new String(Base64.getDecoder().decode(cookie.getValue()));
        String[] values = cookieValue.split("\\|");
        String clientApplicationId = values[0];
        String redirectUrl = values[1];
        String state = null;
        if (values.length > 2 && !Strings.isNullOrEmpty((String)values[2])) {
            state = new String(Base64.getDecoder().decode(values[2]));
        }
        this.redirectToRedirectUrl(request, response, user, clientApplicationId, redirectUrl, state);
    }

    private void redirectToRedirectUrl(HttpServletRequest request, HttpServletResponse response, User user, String clientId, String redirectUrl, String state) throws IOException {
        ExternalApplication externalApplication = OAuthUtils.getDomainObject(clientId, ExternalApplication.class).orElse(null);
        if (externalApplication == null || externalApplication instanceof ServiceApplication) {
            this.sendOAuthErrorResponse(response, Response.Status.BAD_REQUEST, INVALID_GRANT, CLIENT_ID_NOT_FOUND);
            return;
        }
        if (!this.isValidApplication(response, externalApplication)) {
            return;
        }
        if (!externalApplication.matchesUrl(redirectUrl)) {
            this.sendOAuthErrorResponse(response, Response.Status.BAD_REQUEST, INVALID_GRANT, CREDENTIALS_OR_REDIRECT_URI_DON_T_MATCH);
            return;
        }
        if (!externalApplication.hasApplicationUserAuthorization(user)) {
            request.setAttribute("application", (Object)externalApplication);
            this.authorizationPage(request, response, externalApplication, redirectUrl, state);
            return;
        }
        this.redirectWithCode(request, response, user, externalApplication, redirectUrl, state);
    }

    private void redirectWithCode(HttpServletRequest request, HttpServletResponse response, User user, ExternalApplication clientApplication, String redirectUrl, String state) throws IOException {
        String code = OAuthAuthorizationServlet.createAppUserSession(clientApplication, user, request, response);
        UriBuilder builder = UriBuilder.fromUri((String)redirectUrl);
        builder.queryParam(CODE, new Object[]{code});
        if (!Strings.isNullOrEmpty((String)state)) {
            builder.queryParam(STATE, new Object[]{state});
        }
        response.sendRedirect(builder.toString());
    }

    public void userConfirmation(HttpServletRequest request, HttpServletResponse response) throws IOException {
        User user = Authenticate.getUser();
        if (user == null) {
            this.errorPage(request, response);
            return;
        }
        String clientId = request.getParameter(CLIENT_ID);
        String redirectUrl = request.getParameter(REDIRECT_URI);
        String state = request.getParameter(STATE);
        String csrfToken = request.getHeader(CSRF_HEADER);
        if (csrfToken == null) {
            this.sendOAuthErrorResponse(response, Response.Status.BAD_REQUEST, NO_CSRF_HEADER, NO_CSRF_HEADER_DESCRIPTION);
            return;
        }
        ExternalApplication externalApplication = OAuthUtils.getDomainObject(clientId).orElse(null);
        if (externalApplication == null || externalApplication instanceof ServiceApplication) {
            this.sendOAuthErrorResponse(response, Response.Status.BAD_REQUEST, INVALID_GRANT, CLIENT_ID_NOT_FOUND);
            return;
        }
        if (!this.isValidApplication(response, externalApplication)) {
            return;
        }
        if (externalApplication.matchesUrl(redirectUrl)) {
            this.redirectWithCode(request, response, user, externalApplication, redirectUrl, state);
            return;
        }
        this.errorPage(request, response);
    }

    private boolean isValidApplication(HttpServletResponse response, ExternalApplication clientApplication) {
        if (clientApplication.isDeleted()) {
            this.sendOAuthErrorResponse(response, Response.Status.UNAUTHORIZED, INVALID_GRANT, APPLICATION_DELETED);
            return false;
        }
        if (clientApplication.isBanned()) {
            this.sendOAuthErrorResponse(response, Response.Status.UNAUTHORIZED, INVALID_GRANT, APPLICATION_BANNED);
            return false;
        }
        return true;
    }

    private static String createAppUserSession(ExternalApplication externalApplication, User user, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return (String)advice$createAppUserSession.perform((Callable)new OAuthAuthorizationServlet$callable$createAppUserSession(externalApplication, user, httpServletRequest, httpServletResponse));
    }

    static /* synthetic */ String advised$createAppUserSession(ExternalApplication application, User user, HttpServletRequest request, HttpServletResponse response) {
        String code = OAuthUtils.generateCode();
        ApplicationUserAuthorization appUserAuthorization = application.getApplicationUserAuthorization(user).orElseGet(() -> new ApplicationUserAuthorization(user, application));
        ApplicationUserSession appUserSession = new ApplicationUserSession();
        appUserSession.setCode(code);
        appUserSession.setDeviceId(OAuthAuthorizationServlet.getDeviceId(request));
        appUserSession.setApplicationUserAuthorization(appUserAuthorization);
        return code;
    }

    private void sendOAuthErrorResponse(HttpServletResponse response, Response.Status status, String error, String errorDescription) {
        JsonObject errorResponse = new JsonObject();
        errorResponse.addProperty("error", error);
        errorResponse.addProperty("errorDescription", errorDescription);
        this.sendOAuthResponse(response, status, errorResponse);
    }

    private void sendOAuthResponse(HttpServletResponse response, Response.Status status, JsonObject jsonResponse) {
        response.setContentType("application/json; charset=UTF-8");
        response.setStatus(status.getStatusCode());
        try (PrintWriter pw = response.getWriter();){
            pw.print(jsonResponse.toString());
            pw.flush();
        }
        catch (IOException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    private static String getDeviceId(HttpServletRequest request) {
        String deviceId = request.getParameter(DEVICE_ID);
        if (Strings.isNullOrEmpty((String)deviceId)) {
            return request.getHeader("User-Agent");
        }
        return deviceId;
    }

    private String trim(String value) {
        int st;
        int len = value.length();
        char[] val = value.toCharArray();
        for (st = 0; st < len && val[st] == '/'; ++st) {
        }
        while (st < len && val[len - 1] == '/') {
            --len;
        }
        return st > 0 || len < value.length() ? value.substring(st, len) : value;
    }

    private static class I18NFunction
    implements Function {
        final List<String> variableArgs = Stream.of("arg0", "arg1", "arg2", "arg3", "arg4", "arg5").collect(Collectors.toList());

        private I18NFunction() {
        }

        public List<String> getArgumentNames() {
            return Stream.of("bundle", "key", "arg0", "arg1", "arg2", "arg3", "arg4", "arg5").collect(Collectors.toList());
        }

        public Object execute(Map<String, Object> args) {
            String bundle = (String)args.get("bundle");
            String key = args.get("key").toString();
            return BundleUtil.getString((String)bundle, (String)key, (String[])this.arguments(args));
        }

        public String[] arguments(Map<String, Object> args) {
            ArrayList<String> values = new ArrayList<String>();
            for (String variableArg : this.variableArgs) {
                if (!args.containsKey(variableArg) || !(args.get(variableArg) instanceof String)) continue;
                values.add((String)args.get(variableArg));
            }
            return values.toArray(new String[0]);
        }
    }
}

